/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.server.storage;

import com.quickskin.mod.QuickSkin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ServerTextureCache {
    private static ServerTextureCache instance;
    private final Map<String, byte[]> textureCache = new ConcurrentHashMap<String, byte[]>();
    private Path storageDirectory;

    private ServerTextureCache() {
    }

    public static ServerTextureCache getInstance() {
        if (instance == null) {
            instance = new ServerTextureCache();
        }
        return instance;
    }

    public void init(MinecraftServer server) {
        Path worldPath = server.getWorldPath(LevelResource.ROOT);
        this.storageDirectory = worldPath.resolve("quickskin").resolve("textures");
        try {
            Files.createDirectories(this.storageDirectory, new FileAttribute[0]);
            QuickSkin.LOGGER.info("ServerTextureCache initialized at: {}", (Object)this.storageDirectory);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to create texture storage directory", (Throwable)e);
        }
        this.loadCachedTextures();
    }

    public void storeTexture(String hash, byte[] textureData) {
        this.textureCache.put(hash, textureData);
        this.saveTextureToDisk(hash, textureData);
        QuickSkin.LOGGER.debug("Stored texture: {} ({} bytes)", (Object)hash, (Object)textureData.length);
    }

    public byte @Nullable [] getTexture(String hash) {
        return this.textureCache.get(hash);
    }

    public void saveAll() {
        QuickSkin.LOGGER.info("Saving {} textures to disk...", (Object)this.textureCache.size());
        int saved = 0;
        for (Map.Entry<String, byte[]> entry : this.textureCache.entrySet()) {
            if (!this.saveTextureToDisk(entry.getKey(), entry.getValue())) continue;
            ++saved;
        }
        QuickSkin.LOGGER.info("Saved {} textures", (Object)saved);
    }

    public void clear() {
        this.textureCache.clear();
        QuickSkin.LOGGER.info("Cleared texture cache");
    }

    private boolean saveTextureToDisk(String hash, byte[] data) {
        if (this.storageDirectory == null) {
            return false;
        }
        try {
            Path file = this.storageDirectory.resolve(hash + ".png");
            Files.write(file, data, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save texture: {}", (Object)hash, (Object)e);
            return false;
        }
    }

    private void loadCachedTextures() {
        if (this.storageDirectory == null || !Files.exists(this.storageDirectory, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(this.storageDirectory).filter(path -> path.toString().endsWith(".png")).forEach(path -> {
                try {
                    String hash = path.getFileName().toString().replace(".png", "");
                    byte[] data = Files.readAllBytes(path);
                    this.textureCache.put(hash, data);
                }
                catch (IOException e) {
                    QuickSkin.LOGGER.warn("Failed to load texture: {}", path, (Object)e);
                }
            });
            QuickSkin.LOGGER.info("Loaded {} textures from disk", (Object)this.textureCache.size());
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load cached textures", (Throwable)e);
        }
    }
}

