/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod;

import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.logging.LogUtils;
import com.quickskin.mod.Config;
import com.quickskin.mod.features.compat.SkinLayers3DCompatibility;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.webserver.WebServerManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="quickskin")
public class QuickSkin {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean isGeckoLibLoaded;

    public QuickSkin() {
        this(null);
    }

    public QuickSkin(FMLJavaModLoadingContext context) {
        IEventBus modEventBus;
        if (context != null) {
            modEventBus = context.getModEventBus();
            LOGGER.debug("Using new Forge API with injected context");
        } else {
            modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            LOGGER.debug("Using legacy Forge API with static context");
        }
        isGeckoLibLoaded = ModList.get().isLoaded("geckolib");
        if (isGeckoLibLoaded) {
            GeckoLib.initialize();
            LOGGER.info("GeckoLib found, enabling 3D player previews and animations.");
        } else {
            LOGGER.warn("GeckoLib not found. 3D player preview and animations will be disabled.");
        }
        this.validateAndRepairConfig();
        if (context != null) {
            context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        } else {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        }
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SkinLayers3DCompatibility::init);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketHandler.register();
            LOGGER.info("QuickSkin packet handler registered");
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> LOGGER.info("QuickSkin Web Server is disabled in config"));
    }

    private void validateAndRepairConfig() {
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path configFile = configDir.resolve("quickskin-client.toml");
            if (!Files.exists(configFile, new LinkOption[0])) {
                return;
            }
            String content = Files.readString(configFile);
            boolean needsRepair = false;
            HashMap<String, Integer> sectionCounts = new HashMap<String, Integer>();
            for (String line : content.split("\n")) {
                String trimmed = line.trim();
                if (!trimmed.startsWith("[") || !trimmed.endsWith("]")) continue;
                String section = trimmed.substring(1, trimmed.length() - 1);
                sectionCounts.put(section, sectionCounts.getOrDefault(section, 0) + 1);
                if ((Integer)sectionCounts.get(section) <= 1) continue;
                needsRepair = true;
                LOGGER.warn("Detected duplicate [{}] section in config", (Object)section);
            }
            if (!needsRepair) {
                try {
                    TomlFormat.instance().createParser().parse(content);
                }
                catch (ParsingException e) {
                    LOGGER.warn("Config file has parsing errors: {}", (Object)e.getMessage());
                    needsRepair = true;
                }
                catch (Exception e) {
                    LOGGER.warn("Config file validation encountered an error: {}", (Object)e.getMessage());
                    needsRepair = true;
                }
            }
            if (needsRepair) {
                LOGGER.warn("Detected corrupted config file. Backing up and regenerating...");
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
                Path backupPath = configDir.resolve("quickskin-client.toml.backup." + timestamp);
                Files.copy(configFile, backupPath, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Backed up corrupted config to: {}", (Object)backupPath);
                Files.delete(configFile);
                LOGGER.info("Deleted corrupted config. A fresh config will be generated with default values.");
            } else {
                LOGGER.debug("Config file validation passed");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while validating config file. If you continue to have issues, delete the config file manually.", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$clientSetup$2() {
        if (WebServerManager.INSTANCE.isRunning()) {
            WebServerManager.INSTANCE.stop();
        }
    }
}

