/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.Config;
import com.quickskin.mod.Constants;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.core.data.AnimationMetadata;
import com.quickskin.mod.core.util.SkinModelDetector;
import com.quickskin.mod.features.animation.client.AnimatedTextureManager;
import com.quickskin.mod.features.animation.util.GifUtil;
import com.quickskin.mod.features.appearance.common.SkinAPI;
import com.quickskin.mod.features.compat.SkinLayers3DCompatibility;
import com.quickskin.mod.features.localstorage.client.LocalAssetManager;
import com.quickskin.mod.features.localstorage.common.KnownCapes;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.networking.client.TextureChunkReceiver;
import com.quickskin.mod.features.networking.packet.C2SRequestTexturePacket;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSkinManager {
    private static final ClientSkinManager INSTANCE = new ClientSkinManager();
    private static final ResourceLocation VANILLA_ELYTRA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/elytra.png");
    private static BufferedImage vanillaElytraImage = null;
    private static final float MAX_CAPE_SCALE = 32.0f;
    private final Map<UUID, CustomSkinData> customSkins = new ConcurrentHashMap<UUID, CustomSkinData>();
    private final Map<UUID, String> modelOverrides = new ConcurrentHashMap<UUID, String>();
    private boolean serverDisableSkinTransparency = false;
    private boolean pendingServerConfigReload = false;

    private ClientSkinManager() {
    }

    public static ClientSkinManager getInstance() {
        return INSTANCE;
    }

    private void refreshPlayerRenderer(UUID playerUuid) {
        Player player;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91060_ != null && (player = mc.f_91073_.m_46003_(playerUuid)) != null) {
            BlockPos pos = player.m_20183_();
            mc.f_91060_.m_109721_(pos, mc.f_91073_.m_8055_(pos), mc.f_91073_.m_8055_(pos));
            SkinLayers3DCompatibility.refreshPlayerLayers(playerUuid);
        }
    }

    public void applyLook(UUID playerUuid, String skinId, @Nullable String capeId, @Nullable String model) {
        String hash;
        if (playerUuid == null) {
            QuickSkin.LOGGER.error("Cannot apply look: playerUuid is null");
            return;
        }
        String finalModel = model;
        if ("auto".equalsIgnoreCase(model) || model != null && model.isEmpty()) {
            byte[] skinData;
            finalModel = skinId.startsWith("local_skin:") ? ((skinData = LocalAssetManager.INSTANCE.getTextureBytes(hash = skinId.substring("local_skin:".length()))) != null ? SkinModelDetector.detectSkinModel(skinData) : "classic") : "";
        }
        if (finalModel != null) {
            this.setModelOverride(playerUuid, finalModel);
        }
        if (skinId.startsWith("local_skin:")) {
            hash = skinId.substring("local_skin:".length());
            if (!LocalAssetManager.INSTANCE.hasTexture(hash) && Minecraft.m_91087_().m_91403_() != null) {
                TextureChunkReceiver.getInstance().registerPendingRequest(hash, "skin");
                PacketHandler.INSTANCE.sendToServer((Object)new C2SRequestTexturePacket(hash));
            }
            ResourceLocation location = LocalAssetManager.INSTANCE.getTextureLocation(hash);
            this.updateCustomSkinData(playerUuid, skinId, location, capeId, this.modelOverrides.get(playerUuid));
            this.processCapeById(playerUuid, capeId);
            this.refreshPlayerRenderer(playerUuid);
        } else {
            this.updateCustomSkinData(playerUuid, skinId, null, capeId, this.modelOverrides.get(playerUuid));
            this.processCapeById(playerUuid, capeId);
            SkinAPI.fetchProfile(skinId).thenAcceptAsync(profile -> {
                if (profile != null) {
                    this.applySkin(playerUuid, (GameProfile)profile);
                }
            }, (Executor)Minecraft.m_91087_());
        }
    }

    private void processCapeById(UUID playerUuid, @Nullable String capeId) {
        block26: {
            CustomSkinData data = this.customSkins.get(playerUuid);
            if (data == null) {
                return;
            }
            if (capeId != null && !capeId.isBlank() && !capeId.equals("__NONE__")) {
                if (capeId.startsWith("local_cape:")) {
                    String hash = capeId.substring("local_cape:".length());
                    if (!LocalAssetManager.INSTANCE.hasTexture(hash) && Minecraft.m_91087_().m_91403_() != null) {
                        TextureChunkReceiver.getInstance().registerPendingRequest(hash, "cape");
                        PacketHandler.INSTANCE.sendToServer((Object)new C2SRequestTexturePacket(hash));
                    }
                    String animationId = "cape_" + hash;
                    boolean isAnimated = false;
                    if (!AnimatedTextureManager.hasAnimation(animationId)) {
                        meta = LocalAssetManager.INSTANCE.getAnimationMetadata(hash);
                        if (meta != null && meta.frameCount() > 1) {
                            isAnimated = true;
                            BufferedImage atlasImage = LocalAssetManager.INSTANCE.getSourceImage(hash);
                            if (atlasImage != null) {
                                NativeImage nativeAtlas = LocalAssetManager.convertToNativeImage(atlasImage);
                                AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, meta.frames(), meta.frameCount());
                            } else {
                                QuickSkin.LOGGER.error("Could not find source atlas image for animated cape hash: {}", (Object)hash);
                            }
                        }
                    } else {
                        meta = LocalAssetManager.INSTANCE.getAnimationMetadata(hash);
                        boolean bl = isAnimated = meta != null && meta.frameCount() > 1;
                    }
                    if (isAnimated) {
                        this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
                    } else {
                        ResourceLocation capeTexture = LocalAssetManager.INSTANCE.getTextureLocation(hash, LocalAssetManager.TextureQuality.PREVIEW);
                        this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, capeTexture, data.model());
                    }
                } else if (capeId.startsWith("KNOWN_CAPE:")) {
                    String id = capeId.substring("KNOWN_CAPE:".length());
                    KnownCapes cape = KnownCapes.getById(id);
                    if (cape != null) {
                        if (cape.isAnimated()) {
                            String animationId = "cape_known_" + id;
                            if (!AnimatedTextureManager.hasAnimation(animationId)) {
                                try {
                                    ResourceLocation capeTexture = cape.getTextureLocation();
                                    InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(capeTexture).get()).m_215507_();
                                    BufferedImage atlasImage = ImageIO.read(stream);
                                    stream.close();
                                    if (atlasImage != null) {
                                        int frameHeight;
                                        int width = atlasImage.getWidth();
                                        int height = atlasImage.getHeight();
                                        int frameCount = height / (frameHeight = width / 2);
                                        if (frameCount > 1) {
                                            ArrayList<GifUtil.FrameData> frames = new ArrayList<GifUtil.FrameData>();
                                            for (int i = 0; i < frameCount; ++i) {
                                                frames.add(new GifUtil.FrameData(50));
                                            }
                                            NativeImage nativeAtlas = LocalAssetManager.convertToNativeImage(atlasImage);
                                            AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, frames, frameCount);
                                            QuickSkin.LOGGER.info("Registered animation for KnownCape: {} ({} frames)", (Object)id, (Object)frameCount);
                                            this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
                                        } else {
                                            this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, cape.getTextureLocation(), data.model());
                                        }
                                        break block26;
                                    }
                                    QuickSkin.LOGGER.error("Failed to load texture for animated KnownCape: {}", (Object)id);
                                    this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, cape.getTextureLocation(), data.model());
                                }
                                catch (IOException e) {
                                    QuickSkin.LOGGER.error("Error loading animated KnownCape texture: {}", (Object)id, (Object)e);
                                    this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, cape.getTextureLocation(), data.model());
                                }
                            } else {
                                this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
                            }
                        } else {
                            this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, cape.getTextureLocation(), data.model());
                        }
                    }
                } else {
                    SkinAPI.fetchProfile(capeId).thenAcceptAsync(profile -> {
                        if (profile != null) {
                            this.applyCape(playerUuid, (GameProfile)profile);
                        }
                    }, (Executor)Minecraft.m_91087_());
                }
            } else {
                this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
            }
        }
    }

    @Nullable
    public ResourceLocation getCapeLocationForId(@Nullable String capeId) {
        if (capeId == null || capeId.isEmpty()) {
            return null;
        }
        if (capeId.equals("__NONE__")) {
            return Constants.HIDE_CAPE_SENTINEL;
        }
        if (capeId.startsWith("local_cape:")) {
            boolean isAnimated;
            String hash = capeId.substring("local_cape:".length());
            AnimationMetadata animMeta = LocalAssetManager.INSTANCE.getAnimationMetadata(hash);
            boolean bl = isAnimated = animMeta != null && animMeta.frameCount() > 1;
            if (isAnimated) {
                ResourceLocation animatedTexture;
                BufferedImage atlasImage;
                String animationId = "cape_" + hash;
                if (!AnimatedTextureManager.hasAnimation(animationId) && (atlasImage = LocalAssetManager.INSTANCE.getSourceImage(hash)) != null) {
                    NativeImage nativeAtlas = LocalAssetManager.convertToNativeImage(atlasImage);
                    AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, animMeta.frames(), animMeta.frameCount());
                }
                if ((animatedTexture = AnimatedTextureManager.getCurrentFrameTexture(animationId)) != null) {
                    return animatedTexture;
                }
                return LocalAssetManager.INSTANCE.getTextureLocation(hash, LocalAssetManager.TextureQuality.FULL);
            }
            return LocalAssetManager.INSTANCE.getTextureLocation(hash, LocalAssetManager.TextureQuality.FULL);
        }
        if (capeId.startsWith("KNOWN_CAPE:")) {
            String id = capeId.substring("KNOWN_CAPE:".length());
            KnownCapes cape = KnownCapes.getById(id);
            if (cape != null) {
                if (cape.isAnimated()) {
                    String animationId = "cape_known_" + id;
                    ResourceLocation animatedTexture = AnimatedTextureManager.getCurrentFrameTexture(animationId);
                    if (animatedTexture != null) {
                        return animatedTexture;
                    }
                    return cape.getTextureLocation();
                }
                return cape.getTextureLocation();
            }
            return null;
        }
        return null;
    }

    public void applyLookLocally(String skinId, String capeId, String model) {
        UUID localPlayerId = Minecraft.m_91087_().m_91094_().m_240411_();
        if (localPlayerId == null) {
            QuickSkin.LOGGER.error("Cannot apply look locally: player UUID is null (user profile not initialized)");
            return;
        }
        this.applyLook(localPlayerId, skinId, capeId, model);
        SkinLayers3DCompatibility.refreshLocalPlayerLayers();
    }

    public void applySkin(UUID playerUuid, GameProfile profile) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, texture) -> {
            if (type == MinecraftProfileTexture.Type.SKIN) {
                this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> {
                    String finalModel = data.model();
                    if (finalModel == null || finalModel.isEmpty() || "auto".equalsIgnoreCase(finalModel)) {
                        try {
                            InputStream textureStream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).orElse(null)).m_215507_();
                            if (textureStream != null) {
                                finalModel = SkinModelDetector.detectSkinModel(textureStream);
                                QuickSkin.LOGGER.debug("Auto-detected model type '{}' for Mojang skin: {}", (Object)finalModel, (Object)profile.getName());
                                this.setModelOverride(playerUuid, finalModel);
                                textureStream.close();
                            } else {
                                QuickSkin.LOGGER.warn("Could not open texture stream for model detection, defaulting to classic");
                                finalModel = "classic";
                            }
                        }
                        catch (Exception e) {
                            QuickSkin.LOGGER.error("Error detecting model type from Mojang skin, defaulting to classic", (Throwable)e);
                            finalModel = "classic";
                        }
                    }
                    return new CustomSkinData(data.skinId(), location, data.capeId(), data.capeLocation(), finalModel);
                });
                this.refreshPlayerRenderer(playerUuid);
            }
        }, true);
    }

    public void applyCape(UUID playerUuid, GameProfile profile) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, texture) -> {
            if (type == MinecraftProfileTexture.Type.CAPE) {
                this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> new CustomSkinData(data.skinId(), data.skinLocation(), data.capeId(), location, data.model()));
                this.refreshPlayerRenderer(playerUuid);
            }
        }, true);
    }

    private void updateCustomSkinData(UUID playerUuid, String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable String model) {
        this.updateCustomSkinData(playerUuid, skinId, skinLocation, capeId, null, model);
    }

    private void updateCustomSkinData(UUID playerUuid, String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable ResourceLocation capeLocation, @Nullable String model) {
        this.customSkins.compute(playerUuid, (uuid, data) -> {
            String finalModel;
            String finalCapeId;
            String oldCapeId;
            String string = oldCapeId = data != null ? data.capeId() : null;
            String string2 = capeId != null ? capeId : (finalCapeId = data != null ? data.capeId() : "");
            if (oldCapeId != null && !oldCapeId.equals(finalCapeId) && oldCapeId.startsWith("local_cape:")) {
                String hash = oldCapeId.substring("local_cape:".length());
                String animationId = "cape_" + hash;
                AnimatedTextureManager.removeAnimation(animationId);
            }
            String string3 = model != null ? model : (finalModel = data != null ? data.model() : "classic");
            ResourceLocation finalCapeLocation = capeLocation != null ? capeLocation : (data != null ? data.capeLocation() : null);
            return new CustomSkinData(skinId, skinLocation, finalCapeId, finalCapeLocation, finalModel);
        });
    }

    public void clearSkin(UUID playerUuid) {
        CustomSkinData data = this.customSkins.remove(playerUuid);
        if (data != null) {
            if (data.capeId() != null && data.capeId().startsWith("local_cape:")) {
                String hash = data.capeId().substring("local_cape:".length());
                String animationId = "cape_" + hash;
                AnimatedTextureManager.removeAnimation(animationId);
            }
            this.refreshPlayerRenderer(playerUuid);
        }
        this.modelOverrides.remove(playerUuid);
    }

    @Nullable
    public ResourceLocation getSkinLocation(UUID playerUuid) {
        CustomSkinData data = this.customSkins.get(playerUuid);
        if (data == null) {
            return null;
        }
        if (data.skinId != null && data.skinId.startsWith("local_skin:")) {
            String hash = data.skinId.substring("local_skin:".length());
            return LocalAssetManager.INSTANCE.getTextureLocation(hash);
        }
        return data.skinLocation();
    }

    @Nullable
    public ResourceLocation getCapeLocation(UUID playerUuid) {
        String hash;
        CustomSkinData data = this.customSkins.get(playerUuid);
        if (data == null || data.capeId() == null) {
            return null;
        }
        ResourceLocation dynamicLocation = this.getCapeLocationForId(data.capeId());
        if (dynamicLocation != null) {
            return dynamicLocation;
        }
        if (data.capeId().startsWith("local_cape:") && LocalAssetManager.INSTANCE.isAnimated(hash = data.capeId().substring("local_cape:".length()))) {
            BufferedImage atlasImage;
            String animationId = "cape_" + hash;
            AnimationMetadata meta = LocalAssetManager.INSTANCE.getAnimationMetadata(hash);
            if (meta != null && meta.frameCount() > 1 && (atlasImage = LocalAssetManager.INSTANCE.getSourceImage(hash)) != null) {
                NativeImage nativeAtlas = LocalAssetManager.convertToNativeImage(atlasImage);
                AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, meta.frames(), meta.frameCount());
                dynamicLocation = AnimatedTextureManager.getCurrentFrameTexture(animationId);
                if (dynamicLocation != null) {
                    return dynamicLocation;
                }
            }
            return LocalAssetManager.INSTANCE.getTextureLocation(hash, LocalAssetManager.TextureQuality.FULL);
        }
        return data.capeLocation();
    }

    @Nullable
    public String getModelName(UUID playerUuid) {
        if (this.modelOverrides.containsKey(playerUuid)) {
            return this.modelOverrides.get(playerUuid);
        }
        CustomSkinData data = this.customSkins.get(playerUuid);
        return data != null ? data.model() : null;
    }

    public void setModelOverride(UUID playerUuid, String model) {
        if (playerUuid == null) {
            QuickSkin.LOGGER.error("Cannot set model override: playerUuid is null");
            return;
        }
        String finalModel = model == null || model.isBlank() ? "classic" : model;
        this.modelOverrides.put(playerUuid, finalModel);
        this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> new CustomSkinData(data.skinId(), data.skinLocation(), data.capeId(), data.capeLocation(), finalModel));
        this.refreshPlayerRenderer(playerUuid);
    }

    public void clearAll() {
        for (CustomSkinData data : this.customSkins.values()) {
            if (data.capeId() == null || !data.capeId().startsWith("local_cape:")) continue;
            String hash = data.capeId().substring("local_cape:".length());
            AnimatedTextureManager.removeAnimation("cape_" + hash);
        }
        this.customSkins.clear();
        this.modelOverrides.clear();
    }

    public void refreshUsersOfTexture(String textureHash) {
        String localSkinId = "local_skin:" + textureHash;
        String localCapeId = "local_cape:" + textureHash;
        for (Map.Entry<UUID, CustomSkinData> entry : this.customSkins.entrySet()) {
            boolean capeMatch;
            UUID playerUuid = entry.getKey();
            CustomSkinData data = entry.getValue();
            boolean bl = capeMatch = data.capeId() != null && data.capeId().equals(localCapeId);
            if ((data.skinId() == null || !data.skinId().equals(localSkinId)) && !capeMatch) continue;
            if (capeMatch) {
                String animationId = "cape_" + textureHash;
                AnimatedTextureManager.refreshAnimation(animationId);
            }
            this.refreshPlayerRenderer(playerUuid);
        }
    }

    public boolean hasActiveSkin(UUID playerUuid) {
        CustomSkinData data = this.customSkins.get(playerUuid);
        return data != null && data.skinId() != null && !data.skinId().isEmpty();
    }

    public boolean hasModelOverride(UUID playerUuid) {
        return this.modelOverrides.containsKey(playerUuid);
    }

    public boolean hasActiveCape(UUID playerUuid) {
        boolean hasActiveCape;
        CustomSkinData data = this.customSkins.get(playerUuid);
        boolean bl = hasActiveCape = data != null && data.capeId() != null && !data.capeId().isEmpty();
        if (hasActiveCape) {
            // empty if block
        }
        return hasActiveCape;
    }

    public void debugPlayerCapeAnimation(UUID playerUuid) {
    }

    private BufferedImage getVanillaElytraImage() {
        if (vanillaElytraImage == null) {
            try {
                InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(VANILLA_ELYTRA_TEXTURE).get()).m_215507_();
                vanillaElytraImage = ImageIO.read(stream);
                stream.close();
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Failed to load vanilla elytra texture", (Throwable)e);
            }
        }
        return vanillaElytraImage;
    }

    public boolean getServerDisableSkinTransparency() {
        return this.serverDisableSkinTransparency;
    }

    public void setServerDisableSkinTransparency(boolean value) {
        boolean changed = this.serverDisableSkinTransparency != value;
        this.serverDisableSkinTransparency = value;
        if (changed) {
            QuickSkin.LOGGER.info("Server config updated: disableSkinTransparency = {}", (Object)value);
            this.pendingServerConfigReload = true;
        }
    }

    public void checkAndReloadIfPending() {
        if (this.pendingServerConfigReload) {
            QuickSkin.LOGGER.info("Executing deferred server config reload (player skins only)");
            this.pendingServerConfigReload = false;
            this.reloadPlayerSkinsOnly();
        }
    }

    public boolean shouldDisableSkinTransparency() {
        Minecraft mc = Minecraft.m_91087_();
        boolean isRemoteServer = mc.m_91089_() != null;
        boolean isLANWorld = mc.m_91091_() && mc.m_91092_() != null && mc.m_91092_().m_6992_();
        boolean isMultiplayer = isRemoteServer || isLANWorld;
        boolean clientWantsDisabled = (Boolean)Config.DISABLE_SKIN_TRANSPARENCY.get();
        if (isMultiplayer) {
            return this.serverDisableSkinTransparency || clientWantsDisabled;
        }
        return clientWantsDisabled;
    }

    public void reloadAllPlayerSkins() {
        QuickSkin.LOGGER.info("Reloading all player skins and capes");
        LocalAssetManager.INSTANCE.clearTextureCaches();
        this.customSkins.forEach((uuid, data) -> {
            if (data.skinId() != null && !data.skinId().isEmpty()) {
                this.applyLook((UUID)uuid, data.skinId(), data.capeId(), data.model());
            }
        });
    }

    public void reloadPlayerSkinsOnly() {
        QuickSkin.LOGGER.info("Reloading player skins in world (keeping GUI textures)");
        LocalAssetManager.INSTANCE.clearPlayerSkinTextures();
        this.customSkins.forEach((uuid, data) -> {
            if (data.skinId() != null && !data.skinId().isEmpty()) {
                this.applyLook((UUID)uuid, data.skinId(), data.capeId(), data.model());
            }
        });
    }

    private record CustomSkinData(String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable ResourceLocation capeLocation, String model) {
    }
}

