/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.core.data;

import com.quickskin.mod.core.data.SkinResolution;
import javax.annotation.Nullable;

public record SkinData(String username, String model, String capeUsername, @Nullable String friendlyName, @Nullable SkinResolution resolution) {
    public static final String PART_SEPARATOR = ";";
    public static final String USER_MODEL_SEPARATOR = ":";
    public static final String LOCAL_FRIENDLY_NAME_SEPARATOR = "|";
    public static final String RESOLUTION_SEPARATOR = "@";
    public static final String DEFAULT_MODEL = "classic";

    public SkinData(String username, String model, String capeUsername, @Nullable String friendlyName) {
        this(username, model, capeUsername, friendlyName, null);
    }

    public static SkinData fromString(String encoded) {
        String username;
        String userAndFriendlyPart;
        String model;
        int lastColon;
        if (encoded == null || encoded.isBlank()) {
            return new SkinData("", DEFAULT_MODEL, "", null, null);
        }
        String[] capeParts = encoded.split(PART_SEPARATOR, 2);
        String userModelPart = capeParts[0];
        String capeUser = capeParts.length > 1 ? capeParts[1] : "";
        String friendlyName = null;
        SkinResolution resolution = null;
        String[] resolutionParts = userModelPart.split(RESOLUTION_SEPARATOR, 2);
        if (resolutionParts.length > 1) {
            try {
                resolution = SkinResolution.valueOf(resolutionParts[1]);
                userModelPart = resolutionParts[0];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((lastColon = userModelPart.lastIndexOf(USER_MODEL_SEPARATOR)) == -1) {
            model = DEFAULT_MODEL;
            userAndFriendlyPart = userModelPart;
        } else {
            model = userModelPart.substring(lastColon + 1);
            userAndFriendlyPart = userModelPart.substring(0, lastColon);
        }
        if (userAndFriendlyPart.contains(LOCAL_FRIENDLY_NAME_SEPARATOR)) {
            String[] friendlyParts = userAndFriendlyPart.split("\\|", 2);
            username = friendlyParts[0];
            if (friendlyParts.length > 1) {
                friendlyName = friendlyParts[1];
            }
        } else {
            username = userAndFriendlyPart;
        }
        return new SkinData(username, model, capeUser, friendlyName, resolution);
    }

    public String getUsername() {
        return this.username != null ? this.username : "";
    }

    public String getModel() {
        return this.model != null && !this.model.isBlank() ? this.model : DEFAULT_MODEL;
    }

    public String getCapeUsername() {
        return this.capeUsername != null ? this.capeUsername : "";
    }

    @Nullable
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Nullable
    public SkinResolution getResolution() {
        return this.resolution;
    }

    public boolean isHD() {
        return this.resolution != null && this.resolution.isHD();
    }

    public String toEncodedString() {
        Object userPart = this.getUsername();
        if (this.getFriendlyName() != null && !this.getFriendlyName().isBlank()) {
            userPart = (String)userPart + LOCAL_FRIENDLY_NAME_SEPARATOR + this.getFriendlyName();
        }
        String base = (String)userPart + USER_MODEL_SEPARATOR + this.getModel();
        if (this.resolution != null) {
            base = base + RESOLUTION_SEPARATOR + this.resolution.name();
        }
        if (this.getCapeUsername().isBlank()) {
            return base;
        }
        return base + PART_SEPARATOR + this.getCapeUsername();
    }

    public String getDisplayName() {
        if (this.getUsername().startsWith("local_skin:")) {
            return this.friendlyName() != null && !this.friendlyName().isBlank() ? this.friendlyName() : "Local Skin";
        }
        return this.getUsername();
    }
}

