/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.core.data;

public enum SkinResolution {
    LEGACY(64, 32),
    STANDARD(64, 64),
    HD_128(128, 64),
    HD_256(256, 128),
    HD_512(512, 256),
    HD_1024(1024, 512),
    HD_2048(2048, 1024);

    public final int width;
    public final int height;

    private SkinResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static SkinResolution fromDimensions(int width, int height) {
        for (SkinResolution resolution : SkinResolution.values()) {
            if (resolution.width != width || resolution.height != height) continue;
            return resolution;
        }
        return null;
    }

    public boolean isValid(int width, int height) {
        if (this == LEGACY) {
            return width == 64 && height == 32;
        }
        double n = Math.log((double)width / 64.0) / Math.log(2.0);
        if (n < 0.0 || n != Math.floor(n)) {
            return false;
        }
        int expectedHeight = (int)(Math.pow(2.0, n - 1.0) * 64.0);
        return height == expectedHeight;
    }

    public static boolean isValidSkinDimension(int width, int height) {
        return SkinResolution.fromDimensions(width, height) != null || SkinResolution.isHDResolution(width, height);
    }

    private static boolean isHDResolution(int width, int height) {
        double log2;
        if (width < 64 || height < 32) {
            return false;
        }
        double scale = (double)width / 64.0;
        if (scale != Math.floor(scale)) {
            return false;
        }
        if (scale > 1.0 && (log2 = Math.log(scale) / Math.log(2.0)) != Math.floor(log2)) {
            return false;
        }
        return height == width || height * 2 == width;
    }

    public boolean isHD() {
        return this != LEGACY && this != STANDARD;
    }

    public int getScale() {
        return this.width / 64;
    }
}

