/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.core.util;

import com.quickskin.mod.QuickSkin;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class SkinModelDetector {
    private static final ColumnCheck[] COLUMNS_TO_CHECK = new ColumnCheck[]{new ColumnCheck(54, 20, 32), new ColumnCheck(55, 20, 32), new ColumnCheck(46, 52, 64), new ColumnCheck(47, 52, 64)};
    private static final double SLIM_THRESHOLD = 0.5;
    private static final int ALPHA_THRESHOLD = 10;

    public static String detectSkinModel(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                QuickSkin.LOGGER.warn("Failed to read image file: {}", (Object)file.getAbsolutePath());
                return "classic";
            }
            return SkinModelDetector.detectSkinModel(image);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Error reading skin file for model detection: {}", (Object)file.getAbsolutePath(), (Object)e);
            return "classic";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectSkinModel(byte[] imageData) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
            BufferedImage image = ImageIO.read(is);
            if (image == null) {
                QuickSkin.LOGGER.warn("Failed to read image from byte array");
                String string = "classic";
                return string;
            }
            String string = SkinModelDetector.detectSkinModel(image);
            return string;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Error reading skin data for model detection", (Throwable)e);
            return "classic";
        }
    }

    public static String detectSkinModel(BufferedImage image) {
        boolean isModern;
        int width = image.getWidth();
        int height = image.getHeight();
        if (width % 64 != 0) {
            QuickSkin.LOGGER.warn("Non-standard skin width (not a multiple of 64): {}x{}", (Object)width, (Object)height);
            return "classic";
        }
        int scale = width / 64;
        boolean isLegacy = height == width / 2;
        boolean bl = isModern = height == width;
        if (!isLegacy && !isModern) {
            QuickSkin.LOGGER.warn("Invalid skin aspect ratio: {}x{}", (Object)width, (Object)height);
            return "classic";
        }
        int transparentPixels = 0;
        int totalPixels = 0;
        for (ColumnCheck column : COLUMNS_TO_CHECK) {
            int scaledX = column.x * scale;
            int scaledYStart = column.yStart * scale;
            int scaledYEnd = column.yEnd * scale;
            if (scaledYEnd > height) continue;
            for (int y = scaledYStart; y < scaledYEnd; ++y) {
                int argb = image.getRGB(scaledX, y);
                int alpha = argb >> 24 & 0xFF;
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                ++totalPixels;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        double transparencyRatio = (double)transparentPixels / (double)totalPixels;
        boolean isSlim = transparencyRatio > 0.5;
        String model = isSlim ? "slim" : "classic";
        return model;
    }

    public static String detectSkinModel(InputStream inputStream) {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            if (image == null) {
                QuickSkin.LOGGER.warn("Failed to read image from input stream");
                return "classic";
            }
            return SkinModelDetector.detectSkinModel(image);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Error reading skin data from input stream for model detection", (Throwable)e);
            return "classic";
        }
    }

    private static class ColumnCheck {
        final int x;
        final int yStart;
        final int yEnd;

        ColumnCheck(int x, int yStart, int yEnd) {
            this.x = x;
            this.yStart = yStart;
            this.yEnd = yEnd;
        }
    }
}

