/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.core.util;

import com.quickskin.mod.QuickSkin;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureAlphaDetector {
    private static final Map<ResourceLocation, Boolean> transparencyCache = new ConcurrentHashMap<ResourceLocation, Boolean>();

    public static boolean hasTransparency(ResourceLocation textureLocation) {
        if (textureLocation == null) {
            return false;
        }
        Boolean cached = transparencyCache.get(textureLocation);
        if (cached != null) {
            return cached;
        }
        boolean hasAlpha = TextureAlphaDetector.detectTransparency(textureLocation);
        transparencyCache.put(textureLocation, hasAlpha);
        return hasAlpha;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean detectTransparency(ResourceLocation textureLocation) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91098_() == null) {
                return false;
            }
            Resource resource = mc.m_91098_().m_213713_(textureLocation).orElse(null);
            if (resource == null) {
                QuickSkin.LOGGER.debug("Could not find texture resource: {}", (Object)textureLocation);
                return false;
            }
            try (InputStream inputStream = resource.m_215507_();){
                BufferedImage image = ImageIO.read(inputStream);
                if (image == null) {
                    QuickSkin.LOGGER.debug("Could not read image from resource: {}", (Object)textureLocation);
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = TextureAlphaDetector.checkImageForTransparency(image);
                return bl;
            }
        }
        catch (IOException e) {
            QuickSkin.LOGGER.debug("Failed to check transparency for texture {}: {}", (Object)textureLocation, (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Unexpected error checking transparency for texture {}", (Object)textureLocation, (Object)e);
            return false;
        }
    }

    private static boolean checkImageForTransparency(BufferedImage image) {
        if (!image.getColorModel().hasAlpha()) {
            return false;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int sampleRate = Math.max(1, Math.min(width, height) / 32);
        for (int y = 0; y < height; y += sampleRate) {
            for (int x = 0; x < width; x += sampleRate) {
                int pixel = image.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha >= 255) continue;
                QuickSkin.LOGGER.debug("Found transparency in texture at pixel ({}, {}) with alpha {}", new Object[]{x, y, alpha});
                return true;
            }
        }
        return TextureAlphaDetector.checkEdgesForTransparency(image);
    }

    private static boolean checkEdgesForTransparency(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int x = 0; x < width; ++x) {
            int bottomPixel;
            int topPixel = image.getRGB(x, 0);
            if ((topPixel >> 24 & 0xFF) < 255) {
                return true;
            }
            if (height <= 1 || ((bottomPixel = image.getRGB(x, height - 1)) >> 24 & 0xFF) >= 255) continue;
            return true;
        }
        for (int y = 0; y < height; ++y) {
            int rightPixel;
            int leftPixel = image.getRGB(0, y);
            if ((leftPixel >> 24 & 0xFF) < 255) {
                return true;
            }
            if (width <= 1 || ((rightPixel = image.getRGB(width - 1, y)) >> 24 & 0xFF) >= 255) continue;
            return true;
        }
        return false;
    }

    public static void clearCache() {
        transparencyCache.clear();
    }

    public static int getCacheSize() {
        return transparencyCache.size();
    }

    public static void forceTransparency(ResourceLocation textureLocation, boolean hasTransparency) {
        transparencyCache.put(textureLocation, hasTransparency);
    }
}

