/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.animation.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.quickskin.mod.QuickSkin;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationManager
implements ResourceManagerReloadListener {
    private static final AnimationManager INSTANCE = new AnimationManager();
    private final List<String> availableAnimations = new ArrayList<String>();
    private final Map<String, ResourceLocation> animationFiles = new HashMap<String, ResourceLocation>();
    private static final String ANIMATION_FOLDER = "animations";
    private static final String ANIMATION_SUFFIX = ".animation.json";

    private AnimationManager() {
    }

    public static AnimationManager getInstance() {
        return INSTANCE;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.availableAnimations.clear();
        this.animationFiles.clear();
        try {
            Map animationResources = resourceManager.m_214159_(ANIMATION_FOLDER, path -> path.m_135815_().endsWith(ANIMATION_SUFFIX));
            for (Map.Entry entry : animationResources.entrySet()) {
                ResourceLocation location = (ResourceLocation)entry.getKey();
                if (!location.m_135827_().equals("quickskin")) continue;
                try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).m_215507_());){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (!json.has(ANIMATION_FOLDER)) continue;
                    JsonObject animations = json.getAsJsonObject(ANIMATION_FOLDER);
                    for (Map.Entry animEntry : animations.entrySet()) {
                        String animationName = (String)animEntry.getKey();
                        if (this.availableAnimations.contains(animationName)) continue;
                        this.availableAnimations.add(animationName);
                        this.animationFiles.put(animationName, location);
                    }
                }
                catch (Exception e) {
                    QuickSkin.LOGGER.error("Failed to load animation file: {}", (Object)location, (Object)e);
                }
            }
            Collections.sort(this.availableAnimations);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to load player animations", (Throwable)e);
        }
    }

    public List<String> getAvailableAnimations() {
        return Collections.unmodifiableList(this.availableAnimations);
    }

    public ResourceLocation getAnimationFile(String animationName) {
        return this.animationFiles.get(animationName);
    }

    public Map<String, ResourceLocation> getAllAnimationFiles() {
        return Collections.unmodifiableMap(this.animationFiles);
    }
}

