/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.animation.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.quickskin.mod.QuickSkin;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class AnimationValidator {
    public static void validate(ResourceManager resourceManager) {
        ResourceLocation[] modelFiles;
        HashMap modelBoneMap = new HashMap();
        HashSet animationBones = new HashSet();
        for (ResourceLocation modelFile : modelFiles = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/player.geo.json"), ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/player_slim.geo.json"), ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/cape.geo.json")}) {
            try {
                for (Resource resource : resourceManager.m_213829_(modelFile)) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_());){
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        json.getAsJsonArray("minecraft:geometry").forEach(geo -> geo.getAsJsonObject().getAsJsonArray("bones").forEach(bone -> {
                            String boneName = bone.getAsJsonObject().get("name").getAsString();
                            String lowerBoneName = boneName.toLowerCase();
                            modelBoneMap.computeIfAbsent(lowerBoneName, k -> new HashSet()).add(boneName);
                        }));
                    }
                }
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Validator could not read model file: {}", (Object)modelFile, (Object)e);
            }
        }
        Map animationResources = resourceManager.m_214159_("animations", path -> path.m_135815_().endsWith(".animation.json"));
        for (Map.Entry entry : animationResources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!location.m_135827_().equals("quickskin")) continue;
            try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).m_215507_());){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (!json.has("animations")) continue;
                json.getAsJsonObject("animations").entrySet().forEach(animEntry -> {
                    JsonObject animation = ((JsonElement)animEntry.getValue()).getAsJsonObject();
                    if (animation.has("bones")) {
                        animation.getAsJsonObject("bones").entrySet().forEach(boneEntry -> animationBones.add((String)boneEntry.getKey()));
                    }
                });
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Validator could not read animation file: {}", (Object)location, (Object)e);
            }
        }
        boolean hasErrors = false;
        for (Map.Entry entry : modelBoneMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            hasErrors = true;
            QuickSkin.LOGGER.error("==========================================================");
            QuickSkin.LOGGER.error("ANIMATION VALIDATION FAILED: Inconsistent bone casing across model files!");
            QuickSkin.LOGGER.error("For bone '{}', found multiple definitions: {}", entry.getKey(), entry.getValue());
            QuickSkin.LOGGER.error("Please ensure all model files (.geo.json) use the exact same casing for this bone name.");
            QuickSkin.LOGGER.error("==========================================================");
        }
        if (hasErrors) {
            return;
        }
        Set consistentModelBones = modelBoneMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (String animBone : animationBones) {
            if (consistentModelBones.contains(animBone)) continue;
            String lowerAnimBone = animBone.toLowerCase();
            boolean foundCaseMismatch = false;
            for (String modelBone : consistentModelBones) {
                if (!modelBone.toLowerCase().equals(lowerAnimBone)) continue;
                QuickSkin.LOGGER.error("==========================================================");
                QuickSkin.LOGGER.error("ANIMATION VALIDATION FAILED: Bone casing mismatch!");
                QuickSkin.LOGGER.error("Animation uses '{}' but model uses '{}'", (Object)animBone, (Object)modelBone);
                QuickSkin.LOGGER.error("Please ensure animation files use the exact same bone names as the model files.");
                QuickSkin.LOGGER.error("==========================================================");
                foundCaseMismatch = true;
                break;
            }
            if (foundCaseMismatch) continue;
            QuickSkin.LOGGER.warn("Animation bone '{}' not found in any model", (Object)animBone);
        }
    }
}

