/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.appearance.client;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.core.data.AnimationMetadata;
import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.core.util.SkinModelDetector;
import com.quickskin.mod.features.localstorage.client.LocalAssetManager;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.networking.TextureChunker;
import com.quickskin.mod.features.networking.packet.C2STextureChunkPacket;
import com.quickskin.mod.features.networking.packet.C2SUpdateSkinPacket;
import com.quickskin.mod.features.networking.packet.C2SUploadAnimationMetadataPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinSwapper {
    public static void applySkin(String skinUsername, String capeId, String model) {
        String hash;
        byte[] data;
        if (skinUsername == null || skinUsername.isBlank()) {
            SkinSwapper.clearSkin();
            return;
        }
        String finalModel = model;
        if ("auto".equalsIgnoreCase(model) || model != null && model.isEmpty()) {
            finalModel = skinUsername.startsWith("local_skin:") ? ((data = LocalAssetManager.INSTANCE.getTextureBytes(hash = skinUsername.substring("local_skin:".length()))) != null ? SkinModelDetector.detectSkinModel(data) : "classic") : "";
        }
        if (Minecraft.m_91087_().m_91403_() != null) {
            List<C2STextureChunkPacket> chunks;
            SkinResolution resolution;
            if (skinUsername.startsWith("local_skin:") && (data = LocalAssetManager.INSTANCE.getTextureBytes(hash = skinUsername.substring("local_skin:".length()))) != null) {
                resolution = LocalAssetManager.INSTANCE.getResolution(hash);
                chunks = TextureChunker.chunkTextureForUpload(hash, data, resolution);
                chunks.forEach(chunk -> PacketHandler.INSTANCE.sendToServer(chunk));
            }
            if (capeId != null && capeId.startsWith("local_cape:")) {
                AnimationMetadata metadata;
                hash = capeId.substring("local_cape:".length());
                data = LocalAssetManager.INSTANCE.getTextureBytes(hash);
                if (data != null) {
                    resolution = LocalAssetManager.INSTANCE.getResolution(hash);
                    chunks = TextureChunker.chunkTextureForUpload(hash, data, resolution);
                    chunks.forEach(chunk -> PacketHandler.INSTANCE.sendToServer(chunk));
                }
                if (LocalAssetManager.INSTANCE.isAnimated(hash) && (metadata = LocalAssetManager.INSTANCE.getAnimationMetadata(hash)) != null) {
                    PacketHandler.INSTANCE.sendToServer((Object)new C2SUploadAnimationMetadataPacket(hash, metadata));
                }
            }
            PacketHandler.INSTANCE.sendToServer((Object)new C2SUpdateSkinPacket(skinUsername, capeId != null ? capeId : "", finalModel));
        } else {
            QuickSkin.LOGGER.warn("Cannot apply skin to server (not connected). Skin has been saved and will be applied when you join a world.");
        }
    }

    public static void clearSkin() {
        if (Minecraft.m_91087_().m_91403_() != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new C2SUpdateSkinPacket("", "", "slim"));
        } else {
            QuickSkin.LOGGER.warn("Cannot clear skin on server (not connected). Skin has been cleared locally and will be reset when you join a world.");
        }
    }
}

