/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.geckolib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.features.animation.client.AnimationManager;
import com.quickskin.mod.features.gui.client.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.features.gui.client.widget.PlayerWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.client.event.ScreenEvent;

public class GeckoClientEvents {
    @Nullable
    private static PlayerWidget playerWidget;
    private static Button changeSkinButton;
    private static Button animationToggleButton;
    private static final List<Button> animationButtons;
    private static boolean isAnimationDropdownOpen;

    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            int buttonY;
            int buttonX;
            TitleScreen screen2 = (TitleScreen)screen;
            if (playerWidget == null) {
                playerWidget = new PlayerWidget(0, 0, 144, 144, (Component)Component.m_237113_((String)""));
            }
            animationButtons.clear();
            isAnimationDropdownOpen = false;
            accessibilityButton = null;
            int vanillaButtonsY = screen2.f_96544_ / 4 + 48 + 72;
            for (GuiEventListener listener : event.getListenersList()) {
                ImageButton button2;
                if (!(listener instanceof ImageButton) || (button2 = (ImageButton)listener).m_252907_() != vanillaButtonsY || button2.m_252754_() <= screen2.f_96543_ / 2 || button2.m_5711_() != 20 || button2.m_93694_() != 20 || accessibilityButton != null && button2.m_252754_() <= accessibilityButton.m_252754_()) continue;
                accessibilityButton = button2;
            }
            if (accessibilityButton != null) {
                buttonX = accessibilityButton.m_252754_() + accessibilityButton.m_5711_() + 4;
                buttonY = accessibilityButton.m_252907_();
            } else {
                buttonX = screen2.f_96543_ / 2 + 128;
                buttonY = screen2.f_96544_ / 4 + 48 + 84;
            }
            changeSkinButton = Button.m_253074_((Component)Component.m_237113_((String)"Change Skin!"), button -> Minecraft.m_91087_().m_91152_((Screen)new PlayerSkinMenuScreen((Screen)screen2, playerWidget))).m_252987_(buttonX, buttonY, 98, 20).m_253136_();
            event.addListener((GuiEventListener)changeSkinButton);
            int spacing = 4;
            int smallButtonHeight = 20;
            int smallButtonY = changeSkinButton.m_252907_() - smallButtonHeight - spacing;
            int animToggleX = changeSkinButton.m_252754_();
            int animToggleWidth = 20;
            animationToggleButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> GeckoClientEvents.toggleAnimationDropdown()).m_252987_(animToggleX, smallButtonY, animToggleWidth, 20).m_253136_();
            event.addListener((GuiEventListener)animationToggleButton);
            int rotateButtonWidth = 20;
            int rotateButtonX = changeSkinButton.m_252754_() + changeSkinButton.m_5711_() - rotateButtonWidth;
            Button.OnPress onPress = button -> {
                if (playerWidget != null) {
                    playerWidget.toggleRotation();
                }
            };
            Button.CreateNarration createNarration = Supplier::get;
            Button rotateButton = new Button(rotateButtonX, smallButtonY, rotateButtonWidth, 20, (Component)Component.m_237113_((String)"\u21ba"), onPress, createNarration){

                public void m_280139_(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                    Component message = this.m_6035_();
                    PoseStack poseStack = pGuiGraphics.m_280168_();
                    poseStack.m_85836_();
                    float scale = 2.8f;
                    float textWidth = pFont.m_92852_((FormattedText)message);
                    poseStack.m_252880_((float)this.m_252754_() + (float)this.m_5711_() / 1.8f, (float)this.m_252907_() + (float)this.m_93694_() / 4.0f, 0.0f);
                    poseStack.m_85841_(scale, scale, 1.0f);
                    int n = (int)(-textWidth / 2.0f);
                    Objects.requireNonNull(pFont);
                    pGuiGraphics.m_280430_(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
                    poseStack.m_85849_();
                }
            };
            rotateButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Rotate Preview")));
            event.addListener((GuiEventListener)rotateButton);
            List<String> availableAnimations = AnimationManager.getInstance().getAvailableAnimations();
            for (int i = 0; i < availableAnimations.size(); ++i) {
                String animName = availableAnimations.get(i);
                int index = i;
                Button animButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {
                    if (playerWidget != null) {
                        playerWidget.setAnimation(animName);
                    }
                    GeckoClientEvents.toggleAnimationDropdown();
                }).m_252987_(animToggleX, smallButtonY - (i + 1) * 22, animToggleWidth, 20).m_253136_();
                animButton.f_93624_ = false;
                animButton.f_93623_ = false;
                animationButtons.add(animButton);
                event.addListener((GuiEventListener)animButton);
            }
            boolean offsetX = false;
            int offsetY = -82;
            int widgetX = changeSkinButton.m_252754_() + 0;
            int widgetY = changeSkinButton.m_252907_() + -82;
            playerWidget.m_252865_(widgetX);
            playerWidget.m_253211_(widgetY);
            playerWidget.clearModelButtons();
            playerWidget.setChangeSkinButton(changeSkinButton);
            event.addListener((GuiEventListener)playerWidget);
        } else {
            accessibilityButton = event.getScreen();
            if (accessibilityButton instanceof PauseScreen) {
                PauseScreen screen3 = (PauseScreen)accessibilityButton;
                if (playerWidget == null) {
                    playerWidget = new PlayerWidget(0, 0, 144, 144, (Component)Component.m_237113_((String)""));
                }
                animationButtons.clear();
                isAnimationDropdownOpen = false;
                int buttonX = 0;
                int buttonY = 0;
                boolean customPosFound = false;
                Button saveAndQuitButton = null;
                int maxWidth = 0;
                for (Object listener : event.getListenersList()) {
                    Button button3;
                    if (!(listener instanceof Button) || (button3 = (Button)listener).m_5711_() <= maxWidth) continue;
                    maxWidth = button3.m_5711_();
                }
                if (maxWidth > 0) {
                    int maxY = -1;
                    for (GuiEventListener listener : event.getListenersList()) {
                        Button button4;
                        if (!(listener instanceof Button) || (button4 = (Button)listener).m_5711_() != maxWidth || button4.m_252907_() <= maxY) continue;
                        maxY = button4.m_252907_();
                        saveAndQuitButton = button4;
                    }
                }
                if (saveAndQuitButton != null) {
                    buttonX = saveAndQuitButton.m_252754_() + saveAndQuitButton.m_5711_() + 4;
                    buttonY = saveAndQuitButton.m_252907_();
                    customPosFound = true;
                }
                if (!customPosFound) {
                    int fallbackButtonWidth = 90;
                    int fallbackAnimToggleWidth = 20;
                    int rightMargin = 4;
                    int topMargin = 4;
                    buttonX = screen3.f_96543_ - rightMargin - fallbackAnimToggleWidth - 4 - fallbackButtonWidth;
                    buttonY = topMargin;
                }
                int changeSkinButtonWidth = 98;
                int rotateButtonWidth = 20;
                int animToggleWidth = 20;
                int spacing = 4;
                changeSkinButton = Button.m_253074_((Component)Component.m_237113_((String)"Change Skin!"), button -> Minecraft.m_91087_().m_91152_((Screen)new PlayerSkinMenuScreen((Screen)screen3, playerWidget))).m_252987_(buttonX, buttonY, changeSkinButtonWidth, 20).m_253136_();
                event.addListener((GuiEventListener)changeSkinButton);
                int smallButtonHeight = 20;
                int smallButtonY = changeSkinButton.m_252907_() - smallButtonHeight - spacing;
                if (!Minecraft.m_91087_().m_257720_()) {
                    int animToggleX = changeSkinButton.m_252754_();
                    animationToggleButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> GeckoClientEvents.toggleAnimationDropdown()).m_252987_(animToggleX, smallButtonY, animToggleWidth, 20).m_253136_();
                    event.addListener((GuiEventListener)animationToggleButton);
                    List<String> availableAnimations = AnimationManager.getInstance().getAvailableAnimations();
                    for (int i = 0; i < availableAnimations.size(); ++i) {
                        String animName = availableAnimations.get(i);
                        int index = i;
                        Button animButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {
                            if (playerWidget != null) {
                                playerWidget.setAnimation(animName);
                            }
                            GeckoClientEvents.toggleAnimationDropdown();
                        }).m_252987_(animToggleX, smallButtonY - (i + 1) * 22, animToggleWidth, 20).m_253136_();
                        animButton.f_93624_ = false;
                        animButton.f_93623_ = false;
                        animationButtons.add(animButton);
                        event.addListener((GuiEventListener)animButton);
                    }
                }
                int rotateButtonX = changeSkinButton.m_252754_() + changeSkinButton.m_5711_() - rotateButtonWidth;
                Button.OnPress onPress = button -> {
                    if (playerWidget != null) {
                        playerWidget.toggleRotation();
                    }
                };
                Button.CreateNarration createNarration = Supplier::get;
                Button rotateButton = new Button(rotateButtonX, smallButtonY, rotateButtonWidth, 20, (Component)Component.m_237113_((String)"\u21ba"), onPress, createNarration){

                    public void m_280139_(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                        Component message = this.m_6035_();
                        PoseStack poseStack = pGuiGraphics.m_280168_();
                        poseStack.m_85836_();
                        float scale = 2.8f;
                        float textWidth = pFont.m_92852_((FormattedText)message);
                        poseStack.m_252880_((float)this.m_252754_() + (float)this.m_5711_() / 1.8f, (float)this.m_252907_() + (float)this.m_93694_() / 4.0f, 0.0f);
                        poseStack.m_85841_(scale, scale, 1.0f);
                        int n = (int)(-textWidth / 2.0f);
                        Objects.requireNonNull(pFont);
                        pGuiGraphics.m_280430_(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
                        poseStack.m_85849_();
                    }
                };
                rotateButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Rotate Preview")));
                event.addListener((GuiEventListener)rotateButton);
                boolean offsetX = false;
                int offsetY = -85;
                int widgetX = changeSkinButton.m_252754_() + 0;
                int widgetY = changeSkinButton.m_252907_() + -85;
                playerWidget.m_252865_(widgetX);
                playerWidget.m_253211_(widgetY);
                playerWidget.clearModelButtons();
                playerWidget.setChangeSkinButton(changeSkinButton);
                event.addListener((GuiEventListener)playerWidget);
            }
        }
    }

    private static String getShortAnimName(String fullAnimName) {
        if (fullAnimName.contains(".")) {
            return fullAnimName.substring(fullAnimName.lastIndexOf(46) + 1);
        }
        return fullAnimName;
    }

    private static void toggleAnimationDropdown() {
        isAnimationDropdownOpen = !isAnimationDropdownOpen;
        GeckoClientEvents.updateAnimationDropdownState();
    }

    private static void updateAnimationDropdownState() {
        if (animationToggleButton != null) {
            animationToggleButton.m_93666_((Component)Component.m_237113_((String)(isAnimationDropdownOpen ? "\u00d7" : ">")));
        }
        for (Button button : animationButtons) {
            button.f_93624_ = isAnimationDropdownOpen;
            button.f_93623_ = isAnimationDropdownOpen;
        }
    }

    public static void onClientDisconnect() {
        playerWidget = null;
        isAnimationDropdownOpen = false;
        animationButtons.clear();
    }

    static {
        animationButtons = new ArrayList<Button>();
        isAnimationDropdownOpen = false;
    }
}

