/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.geckolib.client;

import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.features.animation.util.GifUtil;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeoPlayerEntity
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ResourceLocation skinLocation;
    private String currentAnimation = "animation.player.idle";
    private String modelName = "classic";
    private SkinResolution resolution = null;
    private String capeIdentifier;
    private GifUtil.GifData gifData = null;

    public GeoPlayerEntity(ResourceLocation skinLocation, String modelName) {
        this.skinLocation = skinLocation != null ? skinLocation : DefaultPlayerSkin.m_118627_((UUID)Util.f_137441_);
        this.modelName = modelName != null ? modelName : "classic";
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main_controller", 0, this::animationPredicate)});
    }

    private PlayState animationPredicate(AnimationState<GeoPlayerEntity> animationState) {
        animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(false, false, 0.0f, 0.0f));
        animationState.setData(DataTickets.TICK, (Object)this.getTick(null));
        animationState.setData(DataTickets.ENTITY, null);
        if (this.currentAnimation != null && !this.currentAnimation.isEmpty()) {
            animationState.getController().setAnimation(RawAnimation.begin().then(this.currentAnimation, Animation.LoopType.LOOP));
        } else {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.player.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.f_91065_ != null) {
            return mc.f_91065_.m_93079_();
        }
        return (double)System.currentTimeMillis() / 50.0;
    }

    public void setAnimation(String animationName) {
        this.currentAnimation = animationName != null && !animationName.trim().isEmpty() ? animationName : "animation.player.idle";
    }

    public String getCurrentAnimation() {
        return this.currentAnimation;
    }

    public ResourceLocation getSkinLocation() {
        return this.skinLocation != null ? this.skinLocation : DefaultPlayerSkin.m_118627_((UUID)Util.f_137441_);
    }

    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation != null ? skinLocation : DefaultPlayerSkin.m_118627_((UUID)Util.f_137441_);
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName != null ? modelName : "classic";
    }

    public SkinResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(SkinResolution resolution) {
        this.resolution = resolution;
    }

    public GifUtil.GifData getGifData() {
        return this.gifData;
    }

    public void setGifData(GifUtil.GifData gifData) {
        this.gifData = gifData;
    }

    public void setCapeIdentifier(String capeIdentifier) {
        this.capeIdentifier = capeIdentifier;
    }

    public String getCapeId() {
        return this.capeIdentifier;
    }
}

