/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.geckolib.client.model;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.features.animation.client.AnimationManager;
import com.quickskin.mod.features.geckolib.client.GeoPlayerEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class GeoCapeModel
extends GeoModel<GeoPlayerEntity> {
    private static final ResourceLocation MODEL_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/cape.geo.json");
    private static final ResourceLocation FALLBACK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/steve.png");
    private static final ResourceLocation FALLBACK_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"animations/idle.animation.json");

    public ResourceLocation getModelResource(GeoPlayerEntity animatable) {
        return MODEL_RESOURCE;
    }

    public ResourceLocation getTextureResource(GeoPlayerEntity animatable) {
        if (animatable == null) {
            return FALLBACK_TEXTURE;
        }
        return animatable.getSkinLocation();
    }

    public ResourceLocation getAnimationResource(GeoPlayerEntity animatable) {
        String animationName;
        if (animatable != null && (animationName = animatable.getCurrentAnimation()) != null && !animationName.isEmpty()) {
            ResourceLocation animationFile = AnimationManager.getInstance().getAnimationFile(animationName);
            if (animationFile != null) {
                return animationFile;
            }
            QuickSkin.LOGGER.warn("Could not find animation file for cape animation: {}. Falling back to default.", (Object)animationName);
        }
        return FALLBACK_ANIMATION;
    }

    public void applyMolangQueries(GeoPlayerEntity animatable, double currentTick) {
    }

    public void setCustomAnimations(GeoPlayerEntity animatable, long instanceId, AnimationState<GeoPlayerEntity> animationState) {
        if (animatable == null || animationState == null) {
            return;
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }

    public void handleAnimations(GeoPlayerEntity animatable, long instanceId, AnimationState<GeoPlayerEntity> animationState) {
        if (animatable == null || animationState == null) {
            return;
        }
        super.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }
}

