/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client;

import com.quickskin.mod.features.gui.client.effect.BlurHandler;
import com.quickskin.mod.features.gui.client.widget.ButtonFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DeletionConfirmScreen
extends Screen {
    private final Screen parent;
    private final Component message;
    private final Consumer<Boolean> callback;
    private final boolean isPermanentDelete;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int MESSAGE_COLOR = 0xFFFFFF;
    private static final int WARNING_COLOR = 0xFFCC00;
    private int panelWidth = 340;
    private int panelHeight = 160;
    private int panelX;
    private int panelY;
    private Button confirmButton;
    private Button cancelButton;

    public DeletionConfirmScreen(Screen parent, Component title, Component message, Consumer<Boolean> callback, boolean isPermanentDelete) {
        super(title);
        this.parent = parent;
        this.message = message;
        this.callback = callback;
        this.isPermanentDelete = isPermanentDelete;
    }

    protected void m_7856_() {
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        this.cancelButton = ButtonFactory.createStyled(buttonStartX, buttonY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Cancel"), button -> this.callback.accept(false));
        this.confirmButton = ButtonFactory.createDanger(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Delete"), button -> this.callback.accept(true));
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.m_142416_((GuiEventListener)this.confirmButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.m_88315_(graphics, -1, -1, partialTicks);
        }
        graphics.m_280262_();
        BlurHandler.renderBlur();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x60000000);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + 1, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        int titleY = this.panelY + 20;
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, titleY, 0xFFFFFF);
        int iconY = this.panelY + 45;
        String warningIcon = "!";
        graphics.m_280137_(this.f_96547_, warningIcon, this.f_96543_ / 2, iconY, 0xFFCC00);
        int messageY = this.panelY + 65;
        int messageMaxWidth = this.panelWidth - 40;
        String messageText = this.message.getString();
        List<String> wrappedLines = this.wrapText(messageText, messageMaxWidth);
        int lineHeight = 10;
        int currentY = messageY;
        for (String line : wrappedLines) {
            graphics.m_280137_(this.f_96547_, line, this.f_96543_ / 2, currentY, 0xFFFFFF);
            currentY += lineHeight;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            int lineWidth = this.f_96547_.m_92895_((String)testLine);
            if (lineWidth > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public void m_7861_() {
        super.m_7861_();
        BlurHandler.cleanup();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        this.callback.accept(false);
    }

    public boolean m_6913_() {
        return true;
    }
}

