/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client;

import com.quickskin.mod.Config;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.features.gui.client.effect.BlurHandler;
import com.quickskin.mod.features.gui.client.widget.ButtonFactory;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.networking.packet.C2SServerConfigPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class SettingsScreen
extends Screen {
    private final Screen parent;
    private boolean needsTextureReload = false;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int MESSAGE_COLOR = 0xAAAAAA;
    private int panelWidth = 400;
    private int panelHeight = 200;
    private int panelX;
    private int panelY;
    private Tab currentTab = Tab.CLIENT;
    private Button clientTabButton;
    private Button serverTabButton;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_SPACING = 2;
    private Button closeButton;
    private Checkbox transparencyCheckbox;
    private Checkbox styledButtonsCheckbox;
    private Checkbox serverTransparencyCheckbox;

    public SettingsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Settings"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
        boolean isMultiplayer = this.isMultiplayerWorld();
        int tabY = this.panelY;
        int tabStartX = this.panelX;
        this.clientTabButton = ButtonFactory.createTab(tabStartX, tabY, 100, 30, (Component)Component.m_237113_((String)"Client"), this.currentTab == Tab.CLIENT, button -> this.switchTab(Tab.CLIENT));
        this.m_142416_((GuiEventListener)this.clientTabButton);
        if (isMultiplayer) {
            this.serverTabButton = ButtonFactory.createTab(tabStartX + 100 + 2, tabY, 100, 30, (Component)Component.m_237113_((String)"Server"), this.currentTab == Tab.SERVER, button -> this.switchTab(Tab.SERVER));
            this.m_142416_((GuiEventListener)this.serverTabButton);
        } else if (this.currentTab == Tab.SERVER) {
            this.currentTab = Tab.CLIENT;
        }
        int contentX = this.panelX + 20;
        int contentY = this.panelY + 30 + 30;
        int contentWidth = this.panelWidth - 40;
        if (this.currentTab == Tab.CLIENT) {
            this.initClientTab(contentX, contentY, contentWidth);
        } else if (isMultiplayer) {
            this.initServerTab(contentX, contentY, contentWidth);
        }
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int buttonX = this.panelX + (this.panelWidth - buttonWidth) / 2;
        this.closeButton = ButtonFactory.createPrimary(buttonX, buttonY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Close"), button -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.closeButton);
    }

    private boolean isMultiplayerWorld() {
        if (this.f_96541_.m_91089_() != null) {
            return true;
        }
        if (this.f_96541_.m_91091_() && this.f_96541_.m_91092_() != null) {
            return this.f_96541_.m_91092_().m_6992_();
        }
        return false;
    }

    private boolean isPlayerAdmin() {
        if (this.f_96541_.f_91074_ != null) {
            return this.f_96541_.f_91074_.m_20310_(2);
        }
        return false;
    }

    private void switchTab(Tab newTab) {
        if (this.currentTab != newTab) {
            this.currentTab = newTab;
            this.m_232761_();
        }
    }

    private void initClientTab(int contentX, int contentY, int contentWidth) {
        int spacing = 30;
        int currentY = contentY;
        this.transparencyCheckbox = new Checkbox(contentX, currentY, 20, 20, (Component)Component.m_237113_((String)"Disable Skin Transparency"), ((Boolean)Config.DISABLE_SKIN_TRANSPARENCY.get()).booleanValue());
        this.m_142416_((GuiEventListener)this.transparencyCheckbox);
        this.styledButtonsCheckbox = new Checkbox(contentX, currentY += spacing, 20, 20, (Component)Component.m_237113_((String)"Enable Styled Buttons"), ((Boolean)Config.ENABLE_STYLED_BUTTONS.get()).booleanValue());
        this.m_142416_((GuiEventListener)this.styledButtonsCheckbox);
    }

    private void initServerTab(int contentX, int contentY, int contentWidth) {
        boolean isAdmin = this.isPlayerAdmin();
        this.serverTransparencyCheckbox = new Checkbox(contentX, contentY, 20, 20, (Component)Component.m_237113_((String)"Disable Skin Transparency (Server)"), ClientSkinManager.getInstance().getServerDisableSkinTransparency());
        this.serverTransparencyCheckbox.f_93623_ = isAdmin;
        this.m_142416_((GuiEventListener)this.serverTransparencyCheckbox);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.m_88315_(graphics, -1, -1, partialTicks);
        }
        graphics.m_280262_();
        BlurHandler.renderBlur();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x60000000);
        int contentPanelY = this.panelY + 30;
        int contentPanelHeight = this.panelHeight - 30;
        graphics.m_280509_(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, -1342177280);
        graphics.m_280509_(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, contentPanelY + contentPanelHeight - 1, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, contentPanelY, this.panelX + 1, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        if (this.currentTab == Tab.SERVER && !this.isPlayerAdmin()) {
            int contentX = this.panelX + 20;
            int contentY = this.panelY + 30 + 30 + 35;
            graphics.m_280488_(this.f_96547_, "Only server admins can change this setting.", contentX, contentY, 0xFFCC00);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7861_() {
        super.m_7861_();
        BlurHandler.cleanup();
        if (this.needsTextureReload) {
            this.reloadPlayerTextures();
        }
        ClientSkinManager.getInstance().checkAndReloadIfPending();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        boolean oldValue;
        boolean newValue;
        if (this.transparencyCheckbox != null && (newValue = this.transparencyCheckbox.m_93840_()) != (oldValue = ((Boolean)Config.DISABLE_SKIN_TRANSPARENCY.get()).booleanValue())) {
            Config.DISABLE_SKIN_TRANSPARENCY.set((Object)newValue);
            this.needsTextureReload = true;
        }
        if (this.styledButtonsCheckbox != null && (newValue = this.styledButtonsCheckbox.m_93840_()) != (Boolean)Config.ENABLE_STYLED_BUTTONS.get()) {
            Config.ENABLE_STYLED_BUTTONS.set((Object)newValue);
        }
        if (this.serverTransparencyCheckbox != null && this.isPlayerAdmin() && (newValue = this.serverTransparencyCheckbox.m_93840_()) != (oldValue = ClientSkinManager.getInstance().getServerDisableSkinTransparency())) {
            PacketHandler.INSTANCE.sendToServer((Object)new C2SServerConfigPacket("disableSkinTransparency", newValue));
        }
        Config.SPEC.save();
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6913_() {
        return true;
    }

    private void reloadPlayerTextures() {
        ClientSkinManager.getInstance().reloadAllPlayerSkins();
    }

    private static enum Tab {
        CLIENT,
        SERVER;

    }
}

