/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.QuickSkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;

public class BlurHandler {
    private static PostChain blurShader = null;
    private static long fadeStartTime = -1L;
    private static final int FADE_TIME_MS = 200;
    private static final ResourceLocation BLUR_SHADER = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"shaders/post/blur.json");
    private static float blurRadius = 5.0f;

    public static void renderBlur() {
        Minecraft mc = Minecraft.m_91087_();
        if (blurShader == null) {
            try {
                blurShader = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), BLUR_SHADER);
                blurShader.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
                fadeStartTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load blur shader", (Throwable)e);
                return;
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        blurShader.m_110023_(0.0f);
        mc.m_91385_().m_83947_(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static float getProgress() {
        if (fadeStartTime < 0L) {
            return 1.0f;
        }
        long elapsed = System.currentTimeMillis() - fadeStartTime;
        float progress = Math.min((float)elapsed / 200.0f, 1.0f);
        return progress * (2.0f - progress);
    }

    public static void cleanup() {
        if (blurShader != null) {
            blurShader.close();
            blurShader = null;
            fadeStartTime = -1L;
        }
    }

    public static void resize(int width, int height) {
        if (blurShader != null) {
            blurShader.m_110025_(width, height);
        }
    }

    public static void setBlurRadius(float radius) {
        blurRadius = radius;
        QuickSkin.LOGGER.info("Blur radius set to: {}", (Object)Float.valueOf(radius));
    }

    public static float getBlurRadius() {
        return blurRadius;
    }
}

