/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.effect;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.quickskin.mod.QuickSkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CustomBlurEffect {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private RenderTarget blurTarget1;
    private RenderTarget blurTarget2;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private static final int BLUR_PASSES = 4;
    private static final float BLUR_RADIUS = 40.0f;

    private void ensureTargetsReady(int width, int height) {
        if (this.blurTarget1 == null || this.lastWidth != width || this.lastHeight != height) {
            QuickSkin.LOGGER.info("[BLUR DEBUG] Creating/resizing render targets to {}x{}", (Object)width, (Object)height);
            if (this.blurTarget1 != null) {
                QuickSkin.LOGGER.info("[BLUR DEBUG] Destroying old blurTarget1");
                this.blurTarget1.m_83930_();
            }
            if (this.blurTarget2 != null) {
                QuickSkin.LOGGER.info("[BLUR DEBUG] Destroying old blurTarget2");
                this.blurTarget2.m_83930_();
            }
            this.blurTarget1 = new TextureTarget(width, height, true, Minecraft.f_91002_);
            this.blurTarget2 = new TextureTarget(width, height, true, Minecraft.f_91002_);
            QuickSkin.LOGGER.info("[BLUR DEBUG] Created new render targets: blurTarget1 and blurTarget2");
            this.lastWidth = width;
            this.lastHeight = height;
        } else {
            QuickSkin.LOGGER.info("[BLUR DEBUG] Render targets already ready at {}x{}", (Object)width, (Object)height);
        }
    }

    public void applyBlur() {
        QuickSkin.LOGGER.info("[BLUR DEBUG] applyBlur() called");
        int width = this.minecraft.m_91385_().f_83915_;
        int height = this.minecraft.m_91385_().f_83916_;
        QuickSkin.LOGGER.info("[BLUR DEBUG] Main render target dimensions: {}x{}", (Object)width, (Object)height);
        this.ensureTargetsReady(width, height);
        QuickSkin.LOGGER.info("[BLUR DEBUG] Targets ready - blurTarget1: {}, blurTarget2: {}", this.blurTarget1 != null ? this.blurTarget1.f_83915_ + "x" + this.blurTarget1.f_83916_ : "null", this.blurTarget2 != null ? this.blurTarget2.f_83915_ + "x" + this.blurTarget2.f_83916_ : "null");
        RenderTarget mainTarget = this.minecraft.m_91385_();
        Matrix4f savedProjection = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        VertexSorting savedSorting = RenderSystem.getVertexSorting();
        QuickSkin.LOGGER.info("[BLUR DEBUG] Starting blur process - {} passes, radius {}", (Object)4, (Object)Float.valueOf(40.0f));
        this.blurTarget1.m_83954_(Minecraft.f_91002_);
        this.blurTarget1.m_83947_(false);
        RenderSystem.setShaderTexture((int)0, (int)mainTarget.m_83975_());
        this.drawTexturedQuad(width, height);
        QuickSkin.LOGGER.info("[BLUR DEBUG] Copied main target to blur target 1");
        for (int i = 0; i < 4; ++i) {
            QuickSkin.LOGGER.info("[BLUR DEBUG] Pass {} - Horizontal blur", (Object)i);
            this.blurTarget2.m_83954_(Minecraft.f_91002_);
            this.blurTarget2.m_83947_(false);
            RenderSystem.setShaderTexture((int)0, (int)this.blurTarget1.m_83975_());
            this.drawBlurredQuad(width, height, 40.0f, 0.0f);
            QuickSkin.LOGGER.info("[BLUR DEBUG] Pass {} - Vertical blur", (Object)i);
            this.blurTarget1.m_83954_(Minecraft.f_91002_);
            this.blurTarget1.m_83947_(false);
            RenderSystem.setShaderTexture((int)0, (int)this.blurTarget2.m_83975_());
            this.drawBlurredQuad(width, height, 0.0f, 40.0f);
        }
        QuickSkin.LOGGER.info("[BLUR DEBUG] Drawing final blurred result back to main target");
        mainTarget.m_83947_(false);
        RenderSystem.setShaderTexture((int)0, (int)this.blurTarget1.m_83975_());
        this.drawTexturedQuad(width, height);
        QuickSkin.LOGGER.info("[BLUR DEBUG] Drew blurred texture back to main target");
        mainTarget.m_83947_(false);
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        RenderSystem.setProjectionMatrix((Matrix4f)savedProjection, (VertexSorting)savedSorting);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (int)0);
        QuickSkin.LOGGER.info("[BLUR DEBUG] applyBlur() completed successfully");
    }

    private void drawTexturedQuad(int width, int height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.f_276633_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(0.0, (double)height, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)width, (double)height, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)width, 0.0, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void drawBlurredQuad(int width, int height, float radiusX, float radiusY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        Matrix4f matrix = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.f_276633_);
        int samples = 9;
        float alpha = 1.0f / (float)(samples * 2 - 1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        float offsetXStep = radiusX / (float)width;
        float offsetYStep = radiusY / (float)height;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        for (int i = -samples + 1; i < samples; ++i) {
            float offsetX = (float)i * offsetXStep;
            float offsetY = (float)i * offsetYStep;
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_5483_(0.0, (double)height, 0.0).m_7421_(0.0f + offsetX, 0.0f + offsetY).m_5752_();
            bufferBuilder.m_5483_((double)width, (double)height, 0.0).m_7421_(1.0f + offsetX, 0.0f + offsetY).m_5752_();
            bufferBuilder.m_5483_((double)width, 0.0, 0.0).m_7421_(1.0f + offsetX, 1.0f + offsetY).m_5752_();
            bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f + offsetX, 1.0f + offsetY).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void close() {
        if (this.blurTarget1 != null) {
            this.blurTarget1.m_83930_();
            this.blurTarget1 = null;
        }
        if (this.blurTarget2 != null) {
            this.blurTarget2.m_83930_();
            this.blurTarget2 = null;
        }
        this.lastWidth = 0;
        this.lastHeight = 0;
    }
}

