/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.QuickSkin;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;

public class MenuBlurEffect {
    private static final ResourceLocation BLUR_SHADER = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"shaders/post/menu_blur.json");
    private static final int FADE_TIME_MS = 200;
    private static final int BLUR_RADIUS = 8;
    private final Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    private PostChain blurEffect;
    @Nullable
    private List<PostPass> passes;
    private long fadeStartTime = -1L;
    private boolean isActive = false;

    public void init() {
        if (this.blurEffect != null) {
            this.blurEffect.close();
            this.blurEffect = null;
        }
        int windowWidth = this.minecraft.m_91268_().m_85441_();
        int windowHeight = this.minecraft.m_91268_().m_85442_();
        try {
            this.blurEffect = new PostChain(this.minecraft.m_91097_(), this.minecraft.m_91098_(), this.minecraft.m_91385_(), BLUR_SHADER);
            this.blurEffect.m_110025_(windowWidth, windowHeight);
            try {
                Field passesField = PostChain.class.getDeclaredField("f_110002_");
                passesField.setAccessible(true);
                this.passes = (List)passesField.get(this.blurEffect);
            }
            catch (NoSuchFieldException e) {
                try {
                    Field passesField = PostChain.class.getDeclaredField("passes");
                    passesField.setAccessible(true);
                    this.passes = (List)passesField.get(this.blurEffect);
                }
                catch (Exception ex) {
                    QuickSkin.LOGGER.error("Failed to access PostChain passes field", (Throwable)ex);
                    this.passes = null;
                }
            }
            this.isActive = true;
            this.fadeStartTime = System.currentTimeMillis();
            QuickSkin.LOGGER.info("Menu blur effect initialized successfully");
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to load blur shader", (Throwable)e);
            this.blurEffect = null;
            this.passes = null;
            this.isActive = false;
        }
    }

    public void render(float partialTicks) {
        if (!this.isActive || this.blurEffect == null) {
            return;
        }
        float progress = this.getFadeProgress();
        this.updateUniforms(progress);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.resetTextureMatrix();
        this.blurEffect.m_110023_(partialTicks);
        this.minecraft.m_91385_().m_83947_(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.viewport((int)0, (int)0, (int)this.minecraft.m_91268_().m_85441_(), (int)this.minecraft.m_91268_().m_85442_());
    }

    private float getFadeProgress() {
        if (this.fadeStartTime < 0L) {
            return 1.0f;
        }
        long elapsed = System.currentTimeMillis() - this.fadeStartTime;
        float progress = Math.min((float)elapsed / 200.0f, 1.0f);
        progress *= 2.0f - progress;
        return progress;
    }

    private void updateUniforms(float progress) {
        if (this.blurEffect == null || this.passes == null) {
            return;
        }
        for (PostPass pass : this.passes) {
            pass.m_110074_().m_108960_("Progress").m_5985_(progress);
            pass.m_110074_().m_108960_("Radius").m_5985_(8.0f);
        }
    }

    public void close() {
        if (this.blurEffect != null) {
            this.blurEffect.close();
            this.blurEffect = null;
        }
        this.passes = null;
        this.isActive = false;
        this.fadeStartTime = -1L;
    }

    public void resize(int width, int height) {
        if (this.blurEffect != null) {
            this.blurEffect.m_110025_(width, height);
        }
    }

    public boolean isActive() {
        return this.isActive && this.blurEffect != null;
    }
}

