/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class StarfieldBackground {
    private final List<Star> stars = new ArrayList<Star>();
    private final Random random = new Random();
    private static final int STAR_COUNT = 500;
    private static final float SPEED = 0.5f;
    private int lastWidth = 0;
    private int lastHeight = 0;

    private void ensureStarsInitialized(int width, int height) {
        if (this.stars.isEmpty() || this.lastWidth != width || this.lastHeight != height) {
            this.stars.clear();
            for (int i = 0; i < 500; ++i) {
                this.stars.add(new Star(this.random.nextFloat() * (float)width, this.random.nextFloat() * (float)height, 1.0f + this.random.nextFloat() * 2.5f, 0.3f + this.random.nextFloat() * 0.7f, -0.25f + this.random.nextFloat() * 0.5f, -0.25f + this.random.nextFloat() * 0.5f));
            }
            this.lastWidth = width;
            this.lastHeight = height;
        }
    }

    public void tick(int width, int height) {
        this.ensureStarsInitialized(width, height);
        for (Star star : this.stars) {
            star.x += star.vx;
            star.y += star.vy;
            if (star.x < 0.0f) {
                star.x = width;
            }
            if (star.x > (float)width) {
                star.x = 0.0f;
            }
            if (star.y < 0.0f) {
                star.y = height;
            }
            if (!(star.y > (float)height)) continue;
            star.y = 0.0f;
        }
    }

    public void render(GuiGraphics graphics, int width, int height) {
        this.ensureStarsInitialized(width, height);
        graphics.m_280024_(0, 0, width, height, -15066598, -16119286);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (Star star : this.stars) {
            this.drawStarQuad(bufferBuilder, matrix, star, 1.0f, 1.0f);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void drawStarQuad(BufferBuilder buffer, Matrix4f matrix, Star star, float sizeMultiplier, float alphaMultiplier) {
        float halfSize = star.size * sizeMultiplier / 2.0f;
        int alpha = (int)(star.brightness * alphaMultiplier * 255.0f);
        int color = alpha << 24 | 0xFFFFFF;
        buffer.m_252986_(matrix, star.x - halfSize, star.y + halfSize, 0.0f).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix, star.x + halfSize, star.y + halfSize, 0.0f).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix, star.x + halfSize, star.y - halfSize, 0.0f).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix, star.x - halfSize, star.y - halfSize, 0.0f).m_193479_(color).m_5752_();
    }

    public void close() {
    }

    private static class Star {
        float x;
        float y;
        float size;
        float brightness;
        float vx;
        float vy;

        Star(float x, float y, float size, float brightness, float vx, float vy) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.brightness = brightness;
            this.vx = vx;
            this.vy = vy;
        }
    }
}

