/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.list;

import com.quickskin.mod.features.gui.client.list.SkinEntry;
import com.quickskin.mod.features.gui.client.screen.PlayerSkinMenuScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SkinList
extends ContainerObjectSelectionList<SkinEntry> {
    private final PlayerSkinMenuScreen parentScreen;

    public SkinList(PlayerSkinMenuScreen parentScreen, Minecraft mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
        this.parentScreen = parentScreen;
    }

    public void makeVisible(SkinEntry entry) {
        this.m_93498_((AbstractSelectionList.Entry)entry);
    }

    public int addEntry(SkinEntry entry) {
        return super.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public void clear() {
        this.m_93516_();
    }

    public int m_5759_() {
        return this.f_93388_ - 8;
    }

    protected int m_5756_() {
        return this.getRight() - 6;
    }

    protected void m_239227_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_239227_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_5773_() <= 2) {
            int rowTop = this.m_7610_(this.m_5773_());
            int areaTop = Math.max(rowTop, this.getTop());
            int areaBottom = this.getBottom();
            if (areaBottom - areaTop > 60) {
                int areaLeft = this.m_5747_();
                int areaWidth = this.m_5759_();
                int centerX = areaLeft + areaWidth / 2;
                int centerY = areaTop + (areaBottom - areaTop) / 2;
                int zoneWidth = Math.min(areaWidth - 40, 300);
                int zoneHeight = Math.min(areaBottom - areaTop - 40, 140);
                int zoneX = centerX - zoneWidth / 2;
                int zoneY = centerY - zoneHeight / 2;
                boolean isHovering = mouseX >= zoneX && mouseX <= zoneX + zoneWidth && mouseY >= zoneY && mouseY <= zoneY + zoneHeight;
                int bgColor = isHovering ? 0x1AFFFFFF : 0xFFFFFFF;
                graphics.m_280509_(zoneX, zoneY, zoneX + zoneWidth, zoneY + zoneHeight, bgColor);
                this.drawDashedBorder(graphics, zoneX, zoneY, zoneWidth, zoneHeight, isHovering);
                MutableComponent mainMessage = Component.m_237113_((String)"Drop skin files here");
                MutableComponent subMessage = Component.m_237113_((String)"or click 'Import Skin'");
                int mainColor = isHovering ? 0xFFFFFF : 0xE0E0E0;
                int subColor = isHovering ? 0xB0B0B0 : 0x909090;
                Font font = this.parentScreen.getFont();
                Objects.requireNonNull(this.parentScreen.getFont());
                graphics.m_280653_(font, (Component)mainMessage, centerX, centerY - 9 - 2, mainColor);
                graphics.m_280653_(this.parentScreen.getFont(), (Component)subMessage, centerX, centerY + 2, subColor);
            }
        }
    }

    private void drawDashedBorder(GuiGraphics graphics, int x, int y, int width, int height, boolean highlight) {
        int segmentLength;
        int i;
        int color = highlight ? -1 : -2130706433;
        int dashLength = 8;
        int gapLength = 4;
        int totalLength = dashLength + gapLength;
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y, x + i + segmentLength, y + 1, color);
        }
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y + height - 1, x + i + segmentLength, y + height, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x, y + i, x + 1, y + i + segmentLength, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x + width - 1, y + i, x + width, y + i + segmentLength, color);
        }
    }
}

