/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.logic;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.core.data.SkinData;
import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.core.util.SkinModelDetector;
import com.quickskin.mod.features.appearance.client.SkinSwapper;
import com.quickskin.mod.features.appearance.common.SkinAPI;
import com.quickskin.mod.features.gui.client.list.SkinEntry;
import com.quickskin.mod.features.gui.client.screen.PlayerSkinMenuScreen;
import com.quickskin.mod.features.localstorage.client.HDTextureProcessor;
import com.quickskin.mod.features.localstorage.client.LocalAssetManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.commons.codec.digest.DigestUtils;

public class SkinMenuLogicHandler {
    private final PlayerSkinMenuScreen screen;
    private final Minecraft minecraft;
    private SkinData currentSkinData;

    public SkinMenuLogicHandler(PlayerSkinMenuScreen screen) {
        this.screen = screen;
        this.minecraft = Minecraft.m_91087_();
        String initialSkinId = (String)Config.ACTIVE_SKIN.get();
        if (initialSkinId.isBlank() && this.minecraft.m_91094_() != null) {
            String playerName = this.minecraft.m_91094_().m_92546_();
            this.currentSkinData = new SkinData(playerName, "auto", "", null);
        } else {
            this.currentSkinData = SkinData.fromString(initialSkinId);
        }
    }

    public SkinData getCurrentSkinData() {
        return this.currentSkinData;
    }

    private void applyAndSaveChanges() {
        if (this.currentSkinData.getUsername().isBlank()) {
            return;
        }
        if (this.minecraft.m_91403_() != null) {
            SkinSwapper.applySkin(this.currentSkinData.getUsername(), this.currentSkinData.getCapeUsername(), this.currentSkinData.getModel());
        }
        ClientSkinManager.getInstance().applyLookLocally(this.currentSkinData.getUsername(), this.currentSkinData.getCapeUsername(), this.currentSkinData.getModel());
        Config.ACTIVE_SKIN.set((Object)this.currentSkinData.toEncodedString());
        Config.ACTIVE_SKIN.save();
        this.updateSavedSkinInConfig(this.currentSkinData);
    }

    public void onSkinSelected(@Nullable SkinEntry entry) {
        if (entry == null) {
            if (!this.currentSkinData.getUsername().startsWith("local_skin:")) {
                this.currentSkinData = new SkinData(this.screen.getUsernameBoxValue(), "auto", this.currentSkinData.getCapeUsername(), null);
            }
        } else {
            this.currentSkinData = entry.getSkinData();
            this.applyAndSaveChanges();
        }
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void onUsernameBoxChanged(String username) {
        SkinEntry matchingEntry = this.screen.findEntry(e -> e.getSortName().equalsIgnoreCase(username));
        if (matchingEntry != null) {
            if (this.screen.getSelectedEntry() != matchingEntry) {
                this.screen.setSelectedEntry(matchingEntry);
                this.onSkinSelected(matchingEntry);
            }
        } else {
            this.screen.setSelectedEntry(null);
            this.currentSkinData = new SkinData(username, "auto", this.currentSkinData.getCapeUsername(), null);
            if (!username.isBlank()) {
                this.screen.schedulePreviewUpdate();
            }
            this.screen.updateAllWidgets();
        }
    }

    public void setModel(String newModel) {
        String normalizedCurrent;
        String currentModel = this.currentSkinData.getModel();
        String normalizedNew = newModel == null ? "" : newModel;
        String string = normalizedCurrent = currentModel == null ? "" : currentModel;
        if (this.currentSkinData.getUsername().isBlank() || normalizedNew.equalsIgnoreCase(normalizedCurrent)) {
            return;
        }
        this.currentSkinData = new SkinData(this.currentSkinData.getUsername(), newModel, this.currentSkinData.getCapeUsername(), this.currentSkinData.getFriendlyName());
        SkinEntry selectedEntry = this.screen.getSelectedEntry();
        if (selectedEntry != null && selectedEntry.getSkinData().getUsername().equalsIgnoreCase(this.currentSkinData.getUsername())) {
            selectedEntry.setSkinData(this.currentSkinData);
        }
        this.applyAndSaveChanges();
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void setCape(String capeIdentifier) {
        this.currentSkinData = new SkinData(this.currentSkinData.getUsername(), this.currentSkinData.getModel(), capeIdentifier, this.currentSkinData.getFriendlyName());
        SkinEntry selectedEntry = this.screen.getSelectedEntry();
        if (selectedEntry != null && selectedEntry.getSkinData().getUsername().equalsIgnoreCase(this.currentSkinData.getUsername())) {
            selectedEntry.setSkinData(this.currentSkinData);
        }
        this.applyAndSaveChanges();
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void addOrUpdateSkinInList() {
        if (this.screen.isApplyingSkin() || this.currentSkinData.getUsername().isBlank()) {
            return;
        }
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        SkinData dataToSave = this.currentSkinData;
        int existingIndex = -1;
        for (int i = 0; i < saved.size(); ++i) {
            if (!SkinData.fromString((String)saved.get(i)).getUsername().equalsIgnoreCase(dataToSave.getUsername())) continue;
            existingIndex = i;
            break;
        }
        if (existingIndex != -1) {
            saved.set(existingIndex, dataToSave.toEncodedString());
            Config.SAVED_SKINS.set(saved);
            Config.SAVED_SKINS.save();
            this.screen.refreshSkinList();
            this.screen.selectSkinInList(dataToSave.getUsername());
        } else if (!dataToSave.getUsername().startsWith("local_skin:")) {
            String friendlyName = dataToSave.getFriendlyName() != null ? dataToSave.getFriendlyName() : dataToSave.getUsername();
            QuickSkin.LOGGER.info("Downloading skin for '{}' to save to upload folder...", (Object)friendlyName);
            SkinAPI.fetchProfile(dataToSave.getUsername()).thenAcceptAsync(profile -> {
                if (profile != null) {
                    byte[] skinBytes = this.downloadSkinFromProfile((GameProfile)profile);
                    if (skinBytes != null) {
                        String hash = DigestUtils.sha1Hex((byte[])skinBytes);
                        String detectedModel = this.extractSkinModel((GameProfile)profile, skinBytes);
                        try {
                            ByteArrayInputStream bis = new ByteArrayInputStream(skinBytes);
                            BufferedImage img = ImageIO.read(bis);
                            SkinResolution resolution = null;
                            if (img != null) {
                                resolution = SkinResolution.fromDimensions(img.getWidth(), img.getHeight());
                            }
                            LocalAssetManager.INSTANCE.saveTextureToUpload(hash, skinBytes, "skin", resolution, friendlyName);
                            String localSkinId = "local_skin:" + hash;
                            SkinData newData = new SkinData(localSkinId, "auto", dataToSave.getCapeUsername(), friendlyName);
                            ArrayList<String> currentSaved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
                            currentSaved.add(newData.toEncodedString());
                            Config.SAVED_SKINS.set(currentSaved);
                            Config.SAVED_SKINS.save();
                            QuickSkin.LOGGER.info("Downloaded and saved searched skin '{}' to upload folder as {} with model: {}", new Object[]{friendlyName, localSkinId, detectedModel});
                            this.minecraft.execute(() -> {
                                this.screen.refreshSkinList();
                                this.screen.selectSkinInList(localSkinId);
                            });
                        }
                        catch (Exception e) {
                            QuickSkin.LOGGER.error("Failed to process downloaded skin for '{}'", (Object)friendlyName, (Object)e);
                        }
                    } else {
                        QuickSkin.LOGGER.warn("Could not download skin texture for: {}", (Object)dataToSave.getUsername());
                    }
                }
            }, (Executor)this.minecraft);
        } else {
            return;
        }
    }

    private byte[] downloadSkinFromProfile(GameProfile profile) {
        block10: {
            byte[] byArray;
            block11: {
                Property textures = profile.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
                if (textures == null) {
                    return null;
                }
                String decoded = new String(Base64.getDecoder().decode(textures.getValue()));
                JsonObject json = JsonParser.parseString((String)decoded).getAsJsonObject();
                if (!json.has("textures") || !json.getAsJsonObject("textures").has("SKIN")) {
                    return null;
                }
                String skinUrl = json.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                URL url = new URL(skinUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                if (connection.getResponseCode() != 200) break block10;
                InputStream in = connection.getInputStream();
                try {
                    byArray = in.readAllBytes();
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        QuickSkin.LOGGER.error("Failed to download skin from profile", (Throwable)e);
                    }
                }
                in.close();
            }
            return byArray;
        }
        return null;
    }

    private String extractSkinModel(GameProfile profile, byte[] skinBytes) {
        try {
            JsonObject skinObj;
            String decoded;
            JsonObject json;
            Property textures = profile.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
            if (textures != null && (json = JsonParser.parseString((String)(decoded = new String(Base64.getDecoder().decode(textures.getValue())))).getAsJsonObject()).has("textures") && json.getAsJsonObject("textures").has("SKIN") && (skinObj = json.getAsJsonObject("textures").getAsJsonObject("SKIN")).has("metadata") && skinObj.getAsJsonObject("metadata").has("model")) {
                String model = skinObj.getAsJsonObject("metadata").get("model").getAsString();
                QuickSkin.LOGGER.debug("Extracted skin model from GameProfile metadata: {}", (Object)model);
                return model;
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.warn("Failed to extract model from GameProfile metadata, falling back to detection", (Throwable)e);
        }
        if (skinBytes != null) {
            String detectedModel = SkinModelDetector.detectSkinModel(skinBytes);
            QuickSkin.LOGGER.debug("Auto-detected skin model from pixels: {}", (Object)detectedModel);
            return detectedModel;
        }
        return "classic";
    }

    public void removeSkinFromList(SkinData skinDataToRemove) {
        String sortName;
        String hash;
        LocalAssetManager.DeleteResult result;
        ArrayList<String> saved;
        boolean wasRemoved;
        if (skinDataToRemove == null || skinDataToRemove.getUsername().isBlank()) {
            return;
        }
        ArrayList currentEntries = new ArrayList(this.screen.getSkinList().m_6702_());
        int deletedIndex = -1;
        for (int i = 0; i < currentEntries.size(); ++i) {
            if (!((SkinEntry)((Object)currentEntries.get(i))).getSkinData().getUsername().equalsIgnoreCase(skinDataToRemove.getUsername())) continue;
            deletedIndex = i;
            break;
        }
        if (!(wasRemoved = (saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get())).removeIf(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(skinDataToRemove.getUsername())))) {
            return;
        }
        Config.SAVED_SKINS.set(saved);
        Config.SAVED_SKINS.save();
        if (skinDataToRemove.getUsername().startsWith("local_skin:") && (result = LocalAssetManager.INSTANCE.deleteLocalAsset(hash = skinDataToRemove.getUsername().substring("local_skin:".length()))) == LocalAssetManager.DeleteResult.IO_ERROR && this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not delete the skin file.").m_130938_(s -> s.m_178520_(0xFF5555)));
        }
        boolean wasSelected = false;
        String string = sortName = skinDataToRemove.getFriendlyName() != null ? skinDataToRemove.getFriendlyName() : skinDataToRemove.getUsername();
        if (this.screen.getUsernameBoxValue().equalsIgnoreCase(sortName)) {
            wasSelected = true;
        }
        if (this.currentSkinData != null && this.currentSkinData.getUsername().equalsIgnoreCase(skinDataToRemove.getUsername())) {
            wasSelected = true;
        }
        this.screen.refreshSkinList();
        if (wasSelected && deletedIndex >= 0) {
            ArrayList newEntries = new ArrayList(this.screen.getSkinList().m_6702_());
            if (!newEntries.isEmpty()) {
                int indexToSelect = Math.min(deletedIndex, newEntries.size() - 1);
                SkinEntry nextEntry = (SkinEntry)((Object)newEntries.get(indexToSelect));
                this.screen.setSelectedEntry(nextEntry);
                this.screen.getSkinList().makeVisible(nextEntry);
                this.currentSkinData = nextEntry.getSkinData();
                this.applyAndSaveChanges();
                this.screen.updateAllWidgets();
                this.screen.updatePreviewImmediately();
            } else {
                this.screen.setSelectedEntry(null);
                String playerName = this.minecraft.m_91094_() != null ? this.minecraft.m_91094_().m_92546_() : "";
                this.screen.setUsernameBoxValue(playerName);
                this.currentSkinData = new SkinData(playerName, "auto", this.currentSkinData.getCapeUsername(), null);
                this.applyAndSaveChanges();
                this.screen.updateAllWidgets();
                this.screen.updatePreviewImmediately();
            }
        }
    }

    public void renameLocalSkin(SkinData skinData, String newFriendlyName) {
        String hash = skinData.getUsername().substring("local_skin:".length());
        LocalAssetManager.RenameResult result = LocalAssetManager.INSTANCE.renameLocalAsset(hash, newFriendlyName);
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        switch (result) {
            case SUCCESS: {
                SkinData newData = new SkinData(skinData.getUsername(), skinData.getModel(), skinData.getCapeUsername(), newFriendlyName);
                this.updateSavedSkinInConfig(newData);
                this.screen.refreshSkinList();
                this.screen.selectSkinInList(newData.getUsername());
                break;
            }
            case NAME_TAKEN: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: A skin file with that name already exists.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case INVALID_NAME: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: The name contains invalid characters or is empty.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case IO_ERROR: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not rename the file. See logs.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case NOT_FOUND: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not find the original file.").m_130938_(s -> s.m_178520_(0xFF5555)));
            }
        }
    }

    public void importLocalSkins() {
        List<LocalAssetManager.LocalAsset> newAssets = LocalAssetManager.INSTANCE.scanAndCacheUploads();
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        int newSkinsCount = 0;
        String firstNewSkinId = null;
        for (LocalAssetManager.LocalAsset asset : newAssets) {
            if (!"skin".equals(asset.type())) continue;
            String skinId = "local_skin:" + asset.hash();
            if (!saved.stream().noneMatch(s -> SkinData.fromString(s).getUsername().equals(skinId))) continue;
            SkinData newSkinData = new SkinData(skinId, "auto", "", asset.friendlyName());
            saved.add(newSkinData.toEncodedString());
            if (firstNewSkinId == null) {
                firstNewSkinId = skinId;
            }
            ++newSkinsCount;
            QuickSkin.LOGGER.info("Imported skin '{}' with automatic model detection", (Object)asset.friendlyName());
        }
        if (newSkinsCount > 0) {
            Config.SAVED_SKINS.set(saved);
            Config.SAVED_SKINS.save();
            this.screen.refreshSkinList();
            if (firstNewSkinId != null) {
                this.screen.selectSkinInList(firstNewSkinId);
            }
        }
    }

    public void savePendingChanges() {
        if (this.screen.getSelectedEntry() == null && !this.currentSkinData.getUsername().isBlank() && !this.screen.isApplyingSkin()) {
            this.applyAndSaveChanges();
            this.addOrUpdateSkinInList();
        }
    }

    public void updateSavedSkinInConfig(SkinData skinData) {
        ArrayList<String> savedSkins = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        for (int i = 0; i < savedSkins.size(); ++i) {
            if (!SkinData.fromString((String)savedSkins.get(i)).getUsername().equalsIgnoreCase(skinData.getUsername())) continue;
            savedSkins.set(i, skinData.toEncodedString());
            Config.SAVED_SKINS.set(savedSkins);
            Config.SAVED_SKINS.save();
            return;
        }
    }

    public void handleFileDrop(List<Path> paths) {
        List pngFiles = paths.stream().filter(p -> p.toString().toLowerCase().endsWith(".png")).collect(Collectors.toList());
        if (pngFiles.isEmpty()) {
            return;
        }
        Path uploadsDir = LocalAssetManager.INSTANCE.getSkinsUploadDir();
        try {
            Files.createDirectories(uploadsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            return;
        }
        int successCount = 0;
        for (Path skinFile : pngFiles) {
            try {
                BufferedImage image = ImageIO.read(skinFile.toFile());
                BufferedImage finalImage = HDTextureProcessor.normalizeSkin(image);
                if (finalImage == null) continue;
                Path targetPath = uploadsDir.resolve(skinFile.getFileName());
                ImageIO.write((RenderedImage)finalImage, "png", targetPath.toFile());
                ++successCount;
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Could not process dropped skin file {}: {}", (Object)skinFile, (Object)e.getMessage());
            }
        }
        if (successCount > 0) {
            this.importLocalSkins();
        }
    }

    public void handleFileSelection(Path selectedPath) {
        try {
            BufferedImage image = ImageIO.read(selectedPath.toFile());
            BufferedImage finalImage = HDTextureProcessor.normalizeSkin(image);
            if (finalImage != null) {
                Path uploadsDir = LocalAssetManager.INSTANCE.getSkinsUploadDir();
                Files.createDirectories(uploadsDir, new FileAttribute[0]);
                Path targetPath = uploadsDir.resolve(selectedPath.getFileName());
                ImageIO.write((RenderedImage)finalImage, "png", targetPath.toFile());
                this.minecraft.execute(() -> {
                    this.importLocalSkins();
                    if (this.minecraft.f_91074_ != null) {
                        this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u2713 Imported normalized skin: ").m_7220_((Component)Component.m_237113_((String)targetPath.getFileName().toString()).m_130938_(s -> s.m_178520_(0x55FF55))));
                    }
                });
            } else {
                this.sendInvalidSkinMessage();
            }
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Could not copy selected skin file {}", (Object)selectedPath, (Object)e);
        }
    }

    private void sendInvalidSkinMessage() {
        if (this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u26a0 Invalid skin image (must follow Minecraft skin format: 64x32, 64x64, or HD resolutions like 512x256, 1024x512, etc.).").m_130938_(s -> s.m_178520_(0xFFAA00)));
        }
    }
}

