/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.core.data.SkinData;
import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.features.animation.client.AnimatedTextureManager;
import com.quickskin.mod.features.animation.util.GifUtil;
import com.quickskin.mod.features.gui.client.DeletionConfirmScreen;
import com.quickskin.mod.features.gui.client.effect.BlurHandler;
import com.quickskin.mod.features.gui.client.effect.StarfieldBackground;
import com.quickskin.mod.features.gui.client.util.GuiScaleManager;
import com.quickskin.mod.features.gui.client.util.GuiScalingUtils;
import com.quickskin.mod.features.gui.client.widget.ButtonFactory;
import com.quickskin.mod.features.gui.client.widget.PlayerWidget;
import com.quickskin.mod.features.localstorage.client.HDTextureProcessor;
import com.quickskin.mod.features.localstorage.client.LocalAssetManager;
import com.quickskin.mod.features.localstorage.common.KnownCapes;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class CapeSelectionScreen
extends Screen {
    private static final int BASE_CAPE_DISPLAY_SIZE = 64;
    private static final int BASE_CAPE_PADDING = 8;
    private static final int BASE_SCROLL_SPEED = 20;
    private static final int ACTION_BUTTON_SIZE = 11;
    private static final int HEADER_HEIGHT = 20;
    private static final int MIN_GRID_WIDTH = 300;
    private static final int MAX_GRID_WIDTH = 600;
    private static final int MIN_GRID_HEIGHT = 200;
    private static final int MAX_GRID_HEIGHT = 500;
    private int capeDisplaySize;
    private int capePadding;
    private int capesPerRow;
    private int scrollSpeed;
    private final StarfieldBackground starfield;
    private final Screen parent;
    private final Consumer<String> callback;
    private final String currentCape;
    private final boolean renderPanorama;
    private PlayerWidget playerWidget;
    private Button backButton;
    private Button importButton;
    private Button downloadButton;
    private AbstractSliderButton animationSpeedSlider;
    private double scrollOffset = 0.0;
    private double targetScrollOffset = 0.0;
    private int maxScroll = 0;
    private boolean isDraggingScrollbar = false;
    private double scrollbarClickOffset = 0.0;
    private int totalContentHeight = 0;
    private int gridX;
    private int gridY;
    private int gridWidth;
    private int gridHeight;
    private int playerWidgetX;
    private int playerWidgetY;
    private int playerWidgetWidth;
    private int playerWidgetHeight;
    private Object selectedCapeObject = null;
    private final List<Object> localCapes = new ArrayList<Object>();
    private final List<KnownCapes> knownCapes = new ArrayList<KnownCapes>();
    private final Map<String, Integer> animatedCapeHeightCache = new HashMap<String, Integer>();
    private String importMessage = "";
    private int importMessageTimer = 0;
    private int importMessageColor = 0xFFFFFF;
    private boolean firstInit = true;

    public CapeSelectionScreen(Screen parent, String currentCape, Consumer<String> callback, boolean renderPanorama, PanoramaRenderer panorama) {
        super((Component)Component.m_237115_((String)"gui.quickskin.cape.grid.title"));
        this.parent = parent;
        this.callback = callback;
        this.currentCape = currentCape;
        this.renderPanorama = renderPanorama;
        this.starfield = new StarfieldBackground();
        if (currentCape.equals("__NONE__")) {
            this.selectedCapeObject = KnownCapes.NONE;
        } else if (currentCape.startsWith("local_cape:")) {
            String hash = currentCape.substring("local_cape:".length());
            LocalAssetManager.INSTANCE.discoverLocalAssets().stream().filter(asset -> asset.hash().equals(hash)).findFirst().ifPresent(asset -> {
                this.selectedCapeObject = asset;
            });
            if (this.selectedCapeObject == null) {
                this.selectedCapeObject = new LocalAssetManager.LocalAsset(hash, "Selected", "cape", null, null, false, 1, null);
            }
        } else if (currentCape.startsWith("KNOWN_CAPE:")) {
            String capeId = currentCape.substring("KNOWN_CAPE:".length());
            this.selectedCapeObject = KnownCapes.getById(capeId);
        }
    }

    protected void m_7856_() {
        int widgetSize;
        if (this.firstInit) {
            this.firstInit = false;
            if (GuiScaleManager.setMenuGuiScale(GuiScaleManager.getOptimalMenuScale())) {
                return;
            }
        }
        super.m_7856_();
        this.calculateAdaptiveDimensions();
        int desiredGridWidth = (int)((float)this.f_96543_ * 0.55f);
        this.gridWidth = Mth.m_14045_((int)desiredGridWidth, (int)300, (int)Math.min(600, this.f_96543_ - this.scaleValue(200)));
        int gridTopY = this.scaleValue(40);
        int bottomButtonY = this.f_96544_ - this.scaleValue(60);
        int sliderYPos = bottomButtonY - this.scaleValue(30);
        int availableHeight = sliderYPos - gridTopY - this.scaleValue(10);
        this.gridHeight = Mth.m_14045_((int)availableHeight, (int)200, (int)500);
        int buttonSpacingCalc = 10;
        int buttonWidthCalc = Math.min(150, (this.f_96543_ - 60 - buttonSpacingCalc * 2) / 3);
        int totalButtonWidthCalc = buttonWidthCalc * 3 + buttonSpacingCalc * 2;
        int buttonStartXCalc = (this.f_96543_ - totalButtonWidthCalc) / 2;
        int backButtonX = buttonStartXCalc + (buttonWidthCalc + buttonSpacingCalc) * 2;
        int gridRightEdge = backButtonX + (int)((float)buttonWidthCalc * 0.25f);
        this.gridX = gridRightEdge - this.gridWidth;
        this.gridY = this.scaleValue(40);
        this.refineCapesPerRowForGridWidth();
        this.refreshCapeListAsync();
        this.updateGridDimensions();
        int bottomY = this.f_96544_ - this.scaleValue(60);
        int sliderY = bottomY - this.scaleValue(30);
        int buttonSpacing = 10;
        int buttonWidth = Math.min(150, (this.f_96543_ - 60 - buttonSpacing * 2) / 3);
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = (this.f_96543_ - totalButtonWidth) / 2;
        this.animationSpeedSlider = (AbstractSliderButton)this.m_142416_((GuiEventListener)new SpeedSlider(this.f_96543_ / 2 - 75, sliderY, 150, 20));
        this.importButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createStyled(buttonStartX, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Import Cape"), button -> this.openFileDialog()));
        this.downloadButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createStyled(buttonStartX + buttonWidth + buttonSpacing, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Download Cape Website"), button -> Util.m_137581_().m_137646_("https://minecraftcapes.net/gallery")));
        this.backButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createPrimary(buttonStartX + (buttonWidth + buttonSpacing) * 2, bottomY, buttonWidth, this.scaleValue(20), (Component)Component.m_237113_((String)"Back"), button -> this.applyAndClose()));
        int availableWidthForWidget = this.f_96543_ - (this.gridX + this.gridWidth) - this.scaleValue(40);
        int availableHeightForBackButton = this.backButton.m_252907_() - this.gridY - this.scaleValue(20);
        this.playerWidgetWidth = widgetSize = Mth.m_14045_((int)Math.min(availableWidthForWidget, availableHeightForBackButton), (int)this.scaleValue(100), (int)this.scaleValue(200));
        this.playerWidgetHeight = (int)((float)widgetSize * 1.8f);
        if (this.playerWidgetX == 0 && this.playerWidgetY == 0) {
            int gridRight = this.gridX + this.gridWidth;
            int gridCenter = this.gridY + this.gridHeight / 2;
            this.playerWidgetX = gridRight + -13;
            this.playerWidgetY = gridCenter - this.playerWidgetHeight / 2 + -81;
        }
        this.playerWidget = (PlayerWidget)this.m_142416_((GuiEventListener)new PlayerWidget(this.playerWidgetX, this.playerWidgetY, this.playerWidgetWidth, this.playerWidgetHeight, (Component)Component.m_237119_()));
        this.playerWidget.toggleRotation();
        if (this.playerWidget != null) {
            this.playerWidget.clearModelButtons();
        }
        this.updateSpeedSliderVisibility();
        this.updatePlayerPreview();
    }

    private void updatePlayerPreview() {
        if (this.playerWidget == null || this.selectedCapeObject == null) {
            return;
        }
        SkinData activeSkin = SkinData.fromString((String)Config.ACTIVE_SKIN.get());
        String skinId = activeSkin.getUsername();
        if (skinId.isBlank() && this.f_96541_ != null && this.f_96541_.m_91094_() != null) {
            skinId = this.f_96541_.m_91094_().m_92546_();
        }
        String model = activeSkin.getModel().isBlank() ? "auto" : activeSkin.getModel();
        Object capeId = "";
        Object object = this.selectedCapeObject;
        if (object instanceof KnownCapes) {
            KnownCapes cape = (KnownCapes)((Object)object);
            capeId = cape.isNoCape() ? "__NONE__" : "KNOWN_CAPE:" + cape.getId();
        } else {
            object = this.selectedCapeObject;
            if (object instanceof LocalAssetManager.LocalAsset) {
                LocalAssetManager.LocalAsset localCape = (LocalAssetManager.LocalAsset)object;
                capeId = "local_cape:" + localCape.hash();
            }
        }
        this.playerWidget.loadPlayerSkinWithRetry(skinId, (String)capeId, model, null);
    }

    private void updateSpeedSliderVisibility() {
        LocalAssetManager.LocalAsset asset;
        boolean show = false;
        Object object = this.selectedCapeObject;
        if (object instanceof LocalAssetManager.LocalAsset && (asset = (LocalAssetManager.LocalAsset)object).isAnimated()) {
            show = true;
        }
        if (this.animationSpeedSlider != null) {
            this.animationSpeedSlider.f_93624_ = show;
            this.animationSpeedSlider.f_93623_ = show;
        }
    }

    private void applyAndClose() {
        this.m_7379_();
    }

    private void refreshCapeListAsync() {
        CompletableFuture.runAsync(() -> {
            List<LocalAssetManager.LocalAsset> discoveredLocalCapes = LocalAssetManager.INSTANCE.discoverLocalAssets().stream().filter(asset -> "cape".equals(asset.type())).toList();
            if (this.f_96541_ != null) {
                this.f_96541_.execute(() -> {
                    this.localCapes.clear();
                    this.knownCapes.clear();
                    this.localCapes.add((Object)KnownCapes.NONE);
                    this.localCapes.addAll(discoveredLocalCapes);
                    for (KnownCapes cape : KnownCapes.values()) {
                        if (cape == KnownCapes.NONE) continue;
                        this.knownCapes.add(cape);
                    }
                    this.updateGridDimensions();
                    for (LocalAssetManager.LocalAsset asset : discoveredLocalCapes) {
                        LocalAssetManager.INSTANCE.getTextureLocation(asset.hash(), LocalAssetManager.TextureQuality.FULL);
                    }
                    Object patt15353$temp = this.selectedCapeObject;
                    if (patt15353$temp instanceof LocalAssetManager.LocalAsset) {
                        LocalAssetManager.LocalAsset oldAsset = (LocalAssetManager.LocalAsset)patt15353$temp;
                        this.localCapes.stream().filter(c -> c instanceof LocalAssetManager.LocalAsset && ((LocalAssetManager.LocalAsset)c).hash().equals(oldAsset.hash())).findFirst().ifPresent(newAsset -> {
                            this.selectedCapeObject = newAsset;
                        });
                    }
                    this.updateSpeedSliderVisibility();
                    this.updatePlayerPreview();
                });
            }
        });
    }

    private void preloadVisibleTextures() {
        for (Object capeObject : this.localCapes) {
            if (!(capeObject instanceof LocalAssetManager.LocalAsset)) continue;
            LocalAssetManager.LocalAsset localAsset = (LocalAssetManager.LocalAsset)capeObject;
            CompletableFuture.runAsync(() -> LocalAssetManager.INSTANCE.getTextureLocation(localAsset.hash(), LocalAssetManager.TextureQuality.FULL, true));
        }
    }

    private void updateGridDimensions() {
        int totalHeight = 0;
        if (!this.localCapes.isEmpty()) {
            totalHeight += 20;
            int localRows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            totalHeight += localRows * (this.capeDisplaySize + this.capePadding);
        }
        if (!this.knownCapes.isEmpty()) {
            totalHeight += 40;
            int knownRows = (int)Math.ceil((double)this.knownCapes.size() / (double)this.capesPerRow);
            totalHeight += knownRows * (this.capeDisplaySize + this.capePadding);
        }
        this.totalContentHeight = totalHeight + this.capePadding;
        this.maxScroll = Math.max(0, this.totalContentHeight - this.gridHeight);
    }

    private void calculateAdaptiveDimensions() {
        float scale = GuiScalingUtils.getScaleMultiplier(this.f_96543_, this.f_96544_);
        this.capeDisplaySize = Math.max(48, Math.min(96, Math.round(64.0f * scale)));
        this.capePadding = Math.max(4, Math.round(8.0f * scale));
        this.scrollSpeed = Math.max(10, Math.round(20.0f * scale));
        int estimatedGridWidth = (int)((float)this.f_96543_ * 0.55f);
        int capeWithPadding = this.capeDisplaySize + this.capePadding;
        this.capesPerRow = Mth.m_14045_((int)((estimatedGridWidth - this.capePadding * 2) / capeWithPadding), (int)2, (int)8);
        if (GuiScalingUtils.isSmallScreen(this.f_96543_, this.f_96544_)) {
            this.capesPerRow = Math.max(2, this.capesPerRow - 1);
            this.capeDisplaySize = Math.round((float)this.capeDisplaySize * 0.85f);
        }
        if (GuiScalingUtils.isLargeScreen(this.f_96543_, this.f_96544_)) {
            this.capesPerRow = Math.min(10, this.capesPerRow + 1);
        }
    }

    private void refineCapesPerRowForGridWidth() {
        int capeWithPadding = this.capeDisplaySize + this.capePadding;
        int availableWidth = this.gridWidth - this.capePadding * 2;
        int maxPerRow = Math.max(2, availableWidth / capeWithPadding);
        this.capesPerRow = Mth.m_14045_((int)maxPerRow, (int)2, (int)10);
    }

    private int scaleValue(int baseValue) {
        return GuiScalingUtils.scaleValue(baseValue, this.f_96543_, this.f_96544_);
    }

    public void m_280273_(GuiGraphics graphics) {
        if (!this.renderPanorama) {
            super.m_280273_(graphics);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.importMessageTimer > 0) {
            --this.importMessageTimer;
        }
        AnimatedTextureManager.tickAll();
        if (this.renderPanorama) {
            this.starfield.tick(this.f_96543_, this.f_96544_);
        }
        this.preloadVisibleTextures();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Object hoveredCape;
        if (this.renderPanorama) {
            this.starfield.render(graphics, this.f_96543_, this.f_96544_);
        } else {
            this.m_280273_(graphics);
        }
        if (((Boolean)Config.ENABLE_MENU_BLUR.get()).booleanValue()) {
            graphics.m_280262_();
            BlurHandler.renderBlur();
        }
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x70000000);
        int titleY = this.scaleValue(15);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, titleY, 0xFFFFFF);
        graphics.m_280509_(this.gridX - 5, this.gridY - 5, this.gridX + this.gridWidth + 5, this.gridY + this.gridHeight + 5, -1879048192);
        graphics.m_280588_(this.gridX, this.gridY, this.gridX + this.gridWidth, this.gridY + this.gridHeight);
        this.scrollOffset += (this.targetScrollOffset - this.scrollOffset) * 0.5;
        this.renderCapeGridOptimized(graphics, mouseX, mouseY);
        graphics.m_280618_();
        this.renderScrollbar(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.importMessageTimer > 0 && !this.importMessage.isEmpty()) {
            int messageY = this.gridY + this.gridHeight + 10;
            graphics.m_280137_(this.f_96547_, this.importMessage, this.f_96543_ / 2, messageY, this.importMessageColor);
        }
        if (this.isMouseOverGrid(mouseX, mouseY) && (hoveredCape = this.getCapeAt(mouseX, mouseY)) != null) {
            int y;
            int deleteButtonY;
            int margin;
            int x;
            int deleteButtonX;
            int[] pos;
            boolean deleteHovered = false;
            if (hoveredCape instanceof LocalAssetManager.LocalAsset && (pos = this.getCapePosition(hoveredCape)) != null && this.isMouseOver(mouseX, mouseY, deleteButtonX = (x = pos[0]) + this.capeDisplaySize - 11 - (margin = 2), deleteButtonY = (y = pos[1]) + margin, 11, 11)) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Delete"), mouseX, mouseY);
                deleteHovered = true;
            }
            if (!deleteHovered) {
                graphics.m_280677_(this.f_96547_, this.getCapeTooltip(hoveredCape), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private void renderCapeGridOptimized(GuiGraphics graphics, int mouseX, int mouseY) {
        int currentY = this.gridY - (int)this.scrollOffset;
        if (!this.localCapes.isEmpty()) {
            currentY = this.renderSection(graphics, "My Capes", this.localCapes, currentY, mouseX, mouseY);
        }
        if (!this.knownCapes.isEmpty()) {
            this.renderSection(graphics, "Default Capes", this.knownCapes, currentY + 20, mouseX, mouseY);
        }
    }

    private int renderSection(GuiGraphics graphics, String title, List<?> capes, int startY, int mouseX, int mouseY) {
        int row;
        int numCapes;
        int headerY = startY + 10 - 4;
        if (headerY > this.gridY - 8 && headerY < this.gridY + this.gridHeight + 8) {
            int gridCenterX = this.gridX + this.gridWidth / 2;
            graphics.m_280137_(this.f_96547_, title, gridCenterX, headerY, 0xFFFFFF);
        }
        int currentY = startY + 20;
        for (int i = 0; i < capes.size(); ++i) {
            Object capeObject = capes.get(i);
            int row2 = i / this.capesPerRow;
            int col = i % this.capesPerRow;
            int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
            int y = currentY + this.capePadding + row2 * (this.capeDisplaySize + this.capePadding);
            if (y + this.capeDisplaySize < this.gridY || y > this.gridY + this.gridHeight) continue;
            this.renderCapeEntry(graphics, capeObject, x, y, mouseX, mouseY);
        }
        if ("My Capes".equals(title) && (numCapes = capes.size()) < this.capesPerRow && (row = numCapes / this.capesPerRow) == 0) {
            int col = numCapes % this.capesPerRow;
            int dropZoneX = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
            int dropZoneY = currentY + this.capePadding;
            int dropZoneWidth = this.gridX + this.gridWidth - dropZoneX - this.capePadding;
            int dropZoneHeight = this.capeDisplaySize;
            if (dropZoneWidth > this.capePadding) {
                this.renderDropZone(graphics, dropZoneX, dropZoneY, dropZoneWidth, dropZoneHeight, mouseX, mouseY);
            }
        }
        int rows = (int)Math.ceil((double)capes.size() / (double)this.capesPerRow);
        return currentY + rows * (this.capeDisplaySize + this.capePadding);
    }

    private void renderDropZone(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        boolean isHovering = this.isMouseOver(mouseX, mouseY, x, y, width, height) && mouseY >= this.gridY && mouseY < this.gridY + this.gridHeight;
        int bgColor = isHovering ? 0x2AFFFFFF : 0x1AFFFFFF;
        graphics.m_280509_(x, y, x + width, y + height, bgColor);
        this.drawDashedBorder(graphics, x, y, width, height, isHovering);
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        MutableComponent mainMessage = Component.m_237113_((String)"Drop cape files here");
        MutableComponent subMessage = Component.m_237113_((String)"or click 'Import Cape'");
        int mainColor = isHovering ? 0xFFFFFF : 0xE0E0E0;
        int subColor = isHovering ? 0xB0B0B0 : 0x909090;
        double d = height;
        Objects.requireNonNull(this.f_96547_);
        if (d > 9.0 * 2.5 && width > this.f_96547_.m_92852_((FormattedText)subMessage)) {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)mainMessage, centerX, centerY - 9 / 2 - 1, mainColor);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)subMessage, centerX, centerY + 9 / 2 + 1, subColor);
        } else if (width > this.f_96547_.m_92852_((FormattedText)mainMessage)) {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)mainMessage, centerX, centerY - 9 / 2, mainColor);
        }
    }

    private void drawDashedBorder(GuiGraphics graphics, int x, int y, int width, int height, boolean highlight) {
        int segmentLength;
        int i;
        int color = highlight ? -1 : -2130706433;
        int dashLength = 8;
        int gapLength = 4;
        int totalLength = dashLength + gapLength;
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y, x + i + segmentLength, y + 1, color);
        }
        for (i = 0; i < width; i += totalLength) {
            segmentLength = Math.min(dashLength, width - i);
            graphics.m_280509_(x + i, y + height - 1, x + i + segmentLength, y + height, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x, y + i, x + 1, y + i + segmentLength, color);
        }
        for (i = 0; i < height; i += totalLength) {
            segmentLength = Math.min(dashLength, height - i);
            graphics.m_280509_(x + width - 1, y + i, x + width, y + i + segmentLength, color);
        }
    }

    private void renderCapeEntry(GuiGraphics graphics, Object capeObject, int x, int y, int mouseX, int mouseY) {
        KnownCapes cape;
        ResourceLocation texture;
        LocalAssetManager.LocalAsset localAsset = null;
        if (capeObject instanceof KnownCapes) {
            KnownCapes cape2 = (KnownCapes)((Object)capeObject);
            if (cape2 == KnownCapes.NONE) {
                graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, -1879048192);
                graphics.m_280137_(this.f_96547_, "None", x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2 - 4, 0xFFFFFF);
                texture = null;
            } else {
                texture = cape2.getTextureLocation();
            }
        } else if (capeObject instanceof LocalAssetManager.LocalAsset) {
            LocalAssetManager.LocalAsset la;
            localAsset = la = (LocalAssetManager.LocalAsset)capeObject;
            texture = LocalAssetManager.INSTANCE.getTextureLocation(la.hash(), LocalAssetManager.TextureQuality.FULL);
        } else {
            return;
        }
        boolean hovered = this.isMouseOver(mouseX, mouseY, x, y, this.capeDisplaySize, this.capeDisplaySize);
        if (texture != null) {
            this.renderCapeTexture(graphics, texture, x, y, capeObject);
        }
        if (capeObject instanceof KnownCapes && (cape = (KnownCapes)((Object)capeObject)) != KnownCapes.NONE) {
            this.renderRarityIndicator(graphics, cape, x, y);
            if (cape.isAnimated()) {
                this.renderAnimatedIndicator(graphics, x, y);
            }
        } else if (localAsset != null) {
            this.renderCustomIndicator(graphics, x, y);
            if (localAsset.isAnimated()) {
                this.renderAnimatedIndicator(graphics, x, y);
            }
        }
        if (this.isSelected(capeObject)) {
            graphics.m_280637_(x - 2, y - 2, this.capeDisplaySize + 4, this.capeDisplaySize + 4, -256);
        } else if (hovered) {
            graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, 0x33FFFFFF);
        }
        if (localAsset != null && hovered) {
            int margin = 2;
            int deleteButtonX = x + this.capeDisplaySize - 11 - margin;
            int deleteButtonY = y + margin;
            boolean deleteHovered = this.isMouseOver(mouseX, mouseY, deleteButtonX, deleteButtonY, 11, 11);
            int deleteBgColor = deleteHovered ? -1595916224 : -2134900736;
            graphics.m_280509_(deleteButtonX, deleteButtonY, deleteButtonX + 11, deleteButtonY + 11, deleteBgColor);
            graphics.m_280488_(this.f_96547_, "x", deleteButtonX + 3, deleteButtonY + 1, -1);
        }
    }

    public void m_7400_(List<Path> paths) {
        List validFiles = paths.stream().filter(p -> {
            String name = p.toString().toLowerCase();
            return name.endsWith(".png") || name.endsWith(".gif");
        }).collect(Collectors.toList());
        if (validFiles.isEmpty()) {
            this.showImportMessage("No PNG or GIF files found", 0xFFAA00, 100);
            return;
        }
        this.showImportMessage("Processing " + validFiles.size() + " file(s)...", 0x55AAFF, 60);
        CompletableFuture.runAsync(() -> {
            int successCount = 0;
            int invalidCount = 0;
            Path capesDir = LocalAssetManager.INSTANCE.getCapesUploadDir();
            try {
                Files.createDirectories(capesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (Minecraft.m_91087_() != null) {
                    Minecraft.m_91087_().execute(() -> this.showImportMessage("Error: Could not create capes directory", 0xFF5555, 100));
                }
                return;
            }
            for (Path file : validFiles) {
                if (this.processDroppedFile(file, capesDir)) {
                    ++successCount;
                    continue;
                }
                ++invalidCount;
            }
            int finalSuccessCount = successCount;
            int finalInvalidCount = invalidCount;
            if (Minecraft.m_91087_() != null) {
                Minecraft.m_91087_().execute(() -> {
                    if (finalSuccessCount > 0) {
                        this.refreshCapeListAsync();
                        Object message = String.format("\u2713 Imported %d cape%s", finalSuccessCount, finalSuccessCount == 1 ? "" : "s");
                        if (finalInvalidCount > 0) {
                            message = (String)message + String.format(" (%d invalid)", finalInvalidCount);
                        }
                        this.showImportMessage((String)message, finalSuccessCount > finalInvalidCount ? 0x55FF55 : 0xFFAA00, 200);
                    } else {
                        this.showImportMessage("\u26a0 No valid capes found (must be 2:1 ratio or animation strip)", 0xFF5555, 200);
                    }
                });
            }
        }).exceptionally(throwable -> {
            if (Minecraft.m_91087_() != null) {
                Minecraft.m_91087_().execute(() -> this.showImportMessage("Error processing files: " + throwable.getMessage(), 0xFF5555, 200));
            }
            return null;
        });
    }

    @Nullable
    private BufferedImage getVanillaElytraImage() {
        try {
            ResourceLocation VANILLA_ELYTRA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/elytra.png");
            InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(VANILLA_ELYTRA_TEXTURE).get()).m_215507_();
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            return image;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to load vanilla elytra texture for custom cape creation", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processDroppedFile(Path sourceFile, Path targetDir) {
        try {
            BufferedImage finalAtlas;
            block20: {
                BufferedImage sourceAtlas;
                block21: {
                    boolean isStandardFormat;
                    String lowerCaseName = sourceFile.toString().toLowerCase();
                    boolean isGif = lowerCaseName.endsWith(".gif");
                    int frameCount = 1;
                    if (isGif) {
                        try (InputStream is = Files.newInputStream(sourceFile, new OpenOption[0]);){
                            GifUtil.GifData gifData = GifUtil.processGif(is);
                            if (gifData == null || gifData.atlas() == null) {
                                boolean bl = false;
                                return bl;
                            }
                            sourceAtlas = gifData.atlas();
                            frameCount = gifData.frameCount();
                            isStandardFormat = true;
                        }
                    } else {
                        SkinResolution frameRes;
                        BufferedImage image = ImageIO.read(sourceFile.toFile());
                        if (image == null) {
                            return false;
                        }
                        sourceAtlas = image;
                        int w = image.getWidth();
                        int h = image.getHeight();
                        int frameHeightIfCape = w / 2;
                        isStandardFormat = false;
                        if (w > 0 && h > 0 && w % 2 == 0 && h % frameHeightIfCape == 0 && (frameRes = SkinResolution.fromDimensions(w, frameHeightIfCape)) != null) {
                            isStandardFormat = true;
                            frameCount = h / frameHeightIfCape;
                        }
                    }
                    if (!isStandardFormat) break block21;
                    QuickSkin.LOGGER.info("Processing as a standard cape format ({} frames): {}", (Object)frameCount, (Object)sourceFile.getFileName());
                    int normalizedWidth = 64;
                    int normalizedHeight = 32 * frameCount;
                    BufferedImage normalizedAtlas = HDTextureProcessor.downsampleTexture(sourceAtlas, normalizedWidth, normalizedHeight);
                    if (this.isElytraAreaTransparent(normalizedAtlas)) {
                        QuickSkin.LOGGER.info("Detected transparent elytra. Compositing with vanilla elytra.");
                        BufferedImage vanillaElytraBase = this.getVanillaElytraImage();
                        if (vanillaElytraBase == null) {
                            finalAtlas = normalizedAtlas;
                            break block20;
                        } else {
                            BufferedImage compositeAtlas = new BufferedImage(normalizedWidth, normalizedHeight, 2);
                            Graphics2D g = compositeAtlas.createGraphics();
                            g.setComposite(AlphaComposite.Clear);
                            g.fillRect(0, 0, normalizedWidth, normalizedHeight);
                            g.setComposite(AlphaComposite.SrcOver);
                            for (int i = 0; i < frameCount; ++i) {
                                int yOffset = i * 32;
                                g.drawImage((Image)vanillaElytraBase, 0, yOffset, null);
                                g.drawImage((Image)normalizedAtlas.getSubimage(0, yOffset, 64, 32), 0, yOffset, null);
                            }
                            g.dispose();
                            finalAtlas = compositeAtlas;
                        }
                        break block20;
                    } else {
                        finalAtlas = normalizedAtlas;
                    }
                    break block20;
                }
                QuickSkin.LOGGER.info("Processing non-standard image as a custom static cape: {}", (Object)sourceFile.getFileName());
                BufferedImage vanillaElytraBase = this.getVanillaElytraImage();
                if (vanillaElytraBase == null) {
                    vanillaElytraBase = new BufferedImage(64, 32, 2);
                }
                BufferedImage newCapeTexture = new BufferedImage(64, 32, 2);
                Graphics2D g = newCapeTexture.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, 64, 32);
                g.setComposite(AlphaComposite.SrcOver);
                g.drawImage((Image)vanillaElytraBase, 0, 0, null);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.drawImage(sourceAtlas, 0, 0, 22, 17, null);
                g.dispose();
                finalAtlas = newCapeTexture;
            }
            if (finalAtlas == null) return false;
            Path targetPath = this.resolveTargetPath(sourceFile, targetDir);
            this.saveImageWithAlpha(finalAtlas, targetPath);
            return true;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Error processing dropped file {}: {}", (Object)sourceFile.getFileName(), (Object)e.getMessage());
        }
        return false;
    }

    private boolean isElytraAreaTransparent(BufferedImage image) {
        double scale = (double)image.getWidth() / 64.0;
        int elytraX = (int)(22.0 * scale);
        int elytraY = 0;
        int elytraWidth = (int)(32.0 * scale);
        int elytraHeight = (int)(16.0 * scale);
        int samplePoints = 5;
        for (int i = 0; i < samplePoints; ++i) {
            for (int j = 0; j < samplePoints; ++j) {
                int x = elytraX + i * elytraWidth / (samplePoints - 1);
                int y = elytraY + j * elytraHeight / (samplePoints - 1);
                int pixel = image.getRGB(x = Math.min(x, image.getWidth() - 1), y = Math.min(y, image.getHeight() - 1));
                int alpha = pixel >> 24 & 0xFF;
                if (alpha <= 10) continue;
                return false;
            }
        }
        return true;
    }

    private Path resolveTargetPath(Path sourceFile, Path targetDir) {
        String fileName = sourceFile.getFileName().toString();
        String nameWithoutExt = fileName.substring(0, fileName.lastIndexOf(46));
        String ext = ".png";
        Path targetPath = targetDir.resolve(nameWithoutExt + ext);
        int counter = 1;
        while (Files.exists(targetPath, new LinkOption[0])) {
            targetPath = targetDir.resolve(nameWithoutExt + "_" + counter + ext);
            ++counter;
        }
        return targetPath;
    }

    private void showImportMessage(String message, int color, int duration) {
        this.importMessage = message;
        this.importMessageColor = color;
        this.importMessageTimer = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageWithAlpha(BufferedImage image, Path outputPath) throws IOException {
        BufferedImage argbImage;
        if (image.getType() != 2) {
            argbImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = argbImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        } else {
            argbImage = image;
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        if (!writers.hasNext()) {
            QuickSkin.LOGGER.warn("No PNG writer found, using fallback");
            ImageIO.write((RenderedImage)argbImage, "png", outputPath.toFile());
            return;
        }
        ImageWriter writer = writers.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputPath.toFile());){
            writer.setOutput(ios);
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            writer.write(metadata, new IIOImage(argbImage, null, metadata), writeParam);
        }
        finally {
            writer.dispose();
        }
    }

    private void renderCapeTexture(GuiGraphics graphics, ResourceLocation texture, int x, int y, Object capeObject) {
        int vHeight;
        int uWidth;
        float v;
        float u;
        boolean textureExists = false;
        try {
            if (this.f_96541_.m_91097_().m_118506_(texture) != null) {
                textureExists = true;
            } else if (this.f_96541_.m_91098_().m_213713_(texture).isPresent()) {
                textureExists = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!textureExists) {
            if (capeObject instanceof LocalAssetManager.LocalAsset) {
                this.renderLoadingTexture(graphics, x, y);
            } else {
                this.renderMissingTexture(graphics, x, y);
            }
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureWidth = 64;
        int textureHeight = 32;
        if (capeObject instanceof LocalAssetManager.LocalAsset) {
            LocalAssetManager.LocalAsset asset = (LocalAssetManager.LocalAsset)capeObject;
            if (asset.resolution() != null) {
                textureWidth = asset.resolution().width;
                int frameHeight = asset.resolution().height;
                textureHeight = asset.isAnimated() && asset.frameCount() > 1 ? frameHeight * asset.frameCount() : frameHeight;
            }
            u = 1.0f;
            v = 1.0f;
            uWidth = 10;
            vHeight = 16;
        } else if (capeObject instanceof KnownCapes) {
            KnownCapes cape = (KnownCapes)((Object)capeObject);
            u = 1.0f;
            v = 1.0f;
            uWidth = 10;
            vHeight = 16;
            if (cape.isAnimated()) {
                Integer cachedHeight = this.animatedCapeHeightCache.get(cape.getId());
                if (cachedHeight != null) {
                    textureHeight = cachedHeight;
                } else {
                    try {
                        InputStream stream = ((Resource)this.f_96541_.m_91098_().m_213713_(texture).get()).m_215507_();
                        BufferedImage image = ImageIO.read(stream);
                        stream.close();
                        if (image != null) {
                            textureWidth = image.getWidth();
                            textureHeight = image.getHeight();
                            this.animatedCapeHeightCache.put(cape.getId(), textureHeight);
                        }
                    }
                    catch (Exception e) {
                        QuickSkin.LOGGER.warn("Failed to read animated cape dimensions for preview: {}", (Object)cape.getId());
                    }
                }
            }
        } else {
            u = 1.0f;
            v = 1.0f;
            uWidth = 10;
            vHeight = 16;
        }
        int capePartWidth = 10;
        int capePartHeight = 16;
        float scale = (float)this.capeDisplaySize / 56.0f;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x + (float)this.capeDisplaySize / 2.0f, (float)y + (float)this.capeDisplaySize / 2.0f, 0.0f);
        poseStack.m_85841_(scale * 3.5f, scale * 3.5f, 1.0f);
        poseStack.m_252880_((float)(-capePartWidth) / 2.0f, (float)(-capePartHeight) / 2.0f, 0.0f);
        graphics.m_280411_(texture, 0, 0, capePartWidth, capePartHeight, u, v, uWidth, vHeight, textureWidth, textureHeight);
        poseStack.m_85849_();
    }

    private void renderLoadingTexture(GuiGraphics graphics, int x, int y) {
        graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, -14540254);
        graphics.m_280137_(this.f_96547_, "Loading", x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2 - 4, 0x888888);
    }

    private void renderMissingTexture(GuiGraphics graphics, int x, int y) {
        graphics.m_280509_(x, y, x + this.capeDisplaySize, y + this.capeDisplaySize, -16777216);
        graphics.m_280509_(x, y, x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2, -65281);
        graphics.m_280509_(x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2, x + this.capeDisplaySize, y + this.capeDisplaySize, -65281);
        graphics.m_280137_(this.f_96547_, "Missing", x + this.capeDisplaySize / 2, y + this.capeDisplaySize / 2 - 4, 0xFFFFFF);
    }

    private void renderCustomIndicator(GuiGraphics graphics, int x, int y) {
        int indicatorSize = Math.max(4, this.capeDisplaySize / 16);
        int rarityColor = -11184641;
        graphics.m_280509_(x + this.capeDisplaySize - indicatorSize * 2, y + this.capeDisplaySize - indicatorSize * 2, x + this.capeDisplaySize - indicatorSize / 2, y + this.capeDisplaySize - indicatorSize / 2, rarityColor);
    }

    private void renderRarityIndicator(GuiGraphics graphics, KnownCapes cape, int x, int y) {
        int owners;
        int rarityColor = cape.isCustom() ? -11184641 : ((owners = cape.getApproximateOwners()) > 1000000 ? -16711936 : (owners > 100000 ? -256 : (owners > 10000 ? -30720 : (owners > 1000 ? -65400 : -65536))));
        int indicatorSize = Math.max(4, this.capeDisplaySize / 16);
        graphics.m_280509_(x + this.capeDisplaySize - indicatorSize * 2, y + this.capeDisplaySize - indicatorSize * 2, x + this.capeDisplaySize - indicatorSize / 2, y + this.capeDisplaySize - indicatorSize / 2, rarityColor);
    }

    private void renderAnimatedIndicator(GuiGraphics graphics, int x, int y) {
        String badgeText = "GIF";
        int textWidth = this.f_96547_.m_92895_(badgeText);
        int badgeWidth = textWidth + 4;
        Objects.requireNonNull(this.f_96547_);
        int badgeHeight = 9 + 2;
        int margin = 2;
        int badgeX = x + margin;
        int badgeY = y + margin;
        int bgColor = -805253889;
        graphics.m_280509_(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, bgColor);
        int borderColor = -16733475;
        graphics.m_280637_(badgeX, badgeY, badgeWidth, badgeHeight, borderColor);
        graphics.m_280488_(this.f_96547_, badgeText, badgeX + 2, badgeY + 1, -1);
    }

    private boolean isSelected(Object capeObj) {
        if (this.selectedCapeObject == null || capeObj == null) {
            return false;
        }
        if (capeObj instanceof KnownCapes) {
            KnownCapes kc = (KnownCapes)((Object)capeObj);
            return kc.equals(this.selectedCapeObject);
        }
        if (capeObj instanceof LocalAssetManager.LocalAsset) {
            LocalAssetManager.LocalAsset la = (LocalAssetManager.LocalAsset)capeObj;
            Object object = this.selectedCapeObject;
            if (object instanceof LocalAssetManager.LocalAsset) {
                LocalAssetManager.LocalAsset selectedLa = (LocalAssetManager.LocalAsset)object;
                return la.hash().equals(selectedLa.hash());
            }
        }
        return false;
    }

    private List<Component> getCapeTooltip(Object capeObject) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (capeObject instanceof KnownCapes) {
            KnownCapes cape = (KnownCapes)((Object)capeObject);
            tooltip.add((Component)Component.m_237113_((String)cape.getDisplayName()).m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(0xFFFF00)));
            tooltip.add((Component)Component.m_237113_((String)cape.getDescription()).m_130938_(s -> s.m_178520_(0xAAAAAA)));
            String rarity = cape.isCustom() ? "Custom" : (cape.getApproximateOwners() > 1000000 ? "Common" : (cape.getApproximateOwners() > 100000 ? "Uncommon" : (cape.getApproximateOwners() > 10000 ? "Rare" : (cape.getApproximateOwners() > 1000 ? "Epic" : "Legendary"))));
            tooltip.add((Component)Component.m_237113_((String)("Rarity: " + rarity)).m_130938_(s -> s.m_178520_(0x888888)));
        } else if (capeObject instanceof LocalAssetManager.LocalAsset) {
            LocalAssetManager.LocalAsset localCape = (LocalAssetManager.LocalAsset)capeObject;
            tooltip.add((Component)Component.m_237113_((String)localCape.friendlyName()).m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(0x55FF55)));
            if (localCape.isAnimated()) {
                int frameCount = LocalAssetManager.INSTANCE.getFrameCountEstimate(localCape.hash());
                tooltip.add((Component)Component.m_237113_((String)("Animated cape (" + frameCount + " frames)")).m_130938_(s -> s.m_178520_(0xFFAA00)));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Static cape").m_130938_(s -> s.m_178520_(0xAAAAAA)));
            }
            SkinResolution resolution = LocalAssetManager.INSTANCE.getResolution(localCape.hash());
            if (resolution != null) {
                String resolutionText = resolution.width + "x" + resolution.height;
                tooltip.add((Component)Component.m_237113_((String)("Resolution: " + resolutionText)).m_130938_(s -> s.m_178520_(0x55FFFF)));
            }
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237113_((String)"Click to preview").m_130938_(s -> s.m_178520_(0x808080).m_131155_(Boolean.valueOf(true))));
        return tooltip;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Object clickedCape;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.maxScroll > 0) {
            int scrollbarWidth = this.scaleValue(6);
            int scrollbarX = this.gridX + this.gridWidth + 3;
            int scrollbarTrackHeight = this.gridHeight;
            if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)this.gridY && mouseY < (double)(this.gridY + scrollbarTrackHeight)) {
                this.isDraggingScrollbar = true;
                int thumbHeight = Mth.m_14045_((int)((int)((float)(scrollbarTrackHeight * scrollbarTrackHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(scrollbarTrackHeight - 8));
                int thumbY = this.gridY + (int)(this.scrollOffset * (double)(scrollbarTrackHeight - thumbHeight) / (double)this.maxScroll);
                if (mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight)) {
                    this.scrollbarClickOffset = mouseY - (double)thumbY;
                } else {
                    this.scrollbarClickOffset = (double)thumbHeight / 2.0;
                    this.updateScrollFromMouse(mouseY);
                }
                return true;
            }
        }
        if (button == 0 && this.isMouseOverGrid((int)mouseX, (int)mouseY) && (clickedCape = this.getCapeAt((int)mouseX, (int)mouseY)) != null) {
            if (clickedCape instanceof LocalAssetManager.LocalAsset) {
                int y;
                int deleteButtonY;
                int margin;
                int x;
                int deleteButtonX;
                LocalAssetManager.LocalAsset localCape = (LocalAssetManager.LocalAsset)clickedCape;
                int[] pos = this.getCapePosition(clickedCape);
                if (pos != null && this.isMouseOver((int)mouseX, (int)mouseY, deleteButtonX = (x = pos[0]) + this.capeDisplaySize - 11 - (margin = 2), deleteButtonY = (y = pos[1]) + margin, 11, 11)) {
                    this.handleDelete(localCape);
                    return true;
                }
            }
            this.selectedCapeObject = clickedCape;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f, (float)0.25f));
            Object capeId = "";
            Object object = this.selectedCapeObject;
            if (object instanceof KnownCapes) {
                KnownCapes cape = (KnownCapes)((Object)object);
                capeId = cape.isNoCape() ? "__NONE__" : "KNOWN_CAPE:" + cape.getId();
            } else {
                object = this.selectedCapeObject;
                if (object instanceof LocalAssetManager.LocalAsset) {
                    LocalAssetManager.LocalAsset localCape = (LocalAssetManager.LocalAsset)object;
                    capeId = "local_cape:" + localCape.hash();
                }
            }
            this.callback.accept((String)capeId);
            this.updateSpeedSliderVisibility();
            this.updatePlayerPreview();
            return true;
        }
        return false;
    }

    private void updateScrollFromMouse(double mouseY) {
        int scrollbarTrackHeight = this.gridHeight;
        int thumbHeight = Mth.m_14045_((int)((int)((float)(scrollbarTrackHeight * scrollbarTrackHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(scrollbarTrackHeight - 8));
        double scrollableTrackHeight = scrollbarTrackHeight - thumbHeight;
        if (scrollableTrackHeight > 0.0) {
            double scrollRatio = (mouseY - (double)this.gridY - this.scrollbarClickOffset) / scrollableTrackHeight;
            this.targetScrollOffset = Mth.m_14008_((double)(scrollRatio * (double)this.maxScroll), (double)0.0, (double)this.maxScroll);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void handleDelete(LocalAssetManager.LocalAsset capeToDelete) {
        MutableComponent message = Component.m_237113_((String)"This will permanently delete the cape file '").m_7220_((Component)Component.m_237113_((String)capeToDelete.friendlyName()).m_130938_(s -> s.m_178520_(0xFFFFAA))).m_130946_("'. Are you sure?");
        this.f_96541_.m_91152_((Screen)new DeletionConfirmScreen(this, (Component)Component.m_237113_((String)"Delete Cape"), (Component)message, confirmed -> {
            if (confirmed.booleanValue()) {
                this.deleteLocalCape(capeToDelete);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, true));
    }

    private void deleteLocalCape(LocalAssetManager.LocalAsset capeToDelete) {
        LocalAssetManager.DeleteResult result;
        if (this.isSelected(capeToDelete)) {
            this.selectedCapeObject = KnownCapes.NONE;
            this.callback.accept("__NONE__");
            this.updateSpeedSliderVisibility();
            this.updatePlayerPreview();
        }
        if ((result = LocalAssetManager.INSTANCE.deleteLocalAsset(capeToDelete.hash())) == LocalAssetManager.DeleteResult.SUCCESS) {
            this.refreshCapeListAsync();
            this.showImportMessage("Deleted " + capeToDelete.friendlyName(), 0x55FF55, 100);
        } else {
            this.showImportMessage("Error deleting cape file", 0xFF5555, 100);
        }
    }

    private int[] getCapePosition(Object capeToFind) {
        int index;
        int currentY = this.gridY - (int)this.scrollOffset;
        if (!this.localCapes.isEmpty()) {
            currentY += 20;
            index = this.localCapes.indexOf(capeToFind);
            if (index != -1) {
                int row = index / this.capesPerRow;
                int col = index % this.capesPerRow;
                int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
                int y = currentY + this.capePadding + row * (this.capeDisplaySize + this.capePadding);
                return new int[]{x, y};
            }
            int rows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            currentY += rows * (this.capeDisplaySize + this.capePadding);
        }
        if (!this.knownCapes.isEmpty()) {
            currentY += 20;
            index = this.knownCapes.indexOf(capeToFind);
            if (index != -1) {
                int row = index / this.capesPerRow;
                int col = index % this.capesPerRow;
                int x = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding);
                int y = currentY + this.capePadding + row * (this.capeDisplaySize + this.capePadding);
                return new int[]{x, y};
            }
        }
        return null;
    }

    private Object getCapeAt(int mouseX, int mouseY) {
        int sectionHeight;
        int rows;
        if (!this.isMouseOverGrid(mouseX, mouseY)) {
            return null;
        }
        int absoluteMouseY = mouseY + (int)this.scrollOffset;
        int currentY = this.gridY;
        if (!this.localCapes.isEmpty()) {
            rows = (int)Math.ceil((double)this.localCapes.size() / (double)this.capesPerRow);
            sectionHeight = rows * (this.capeDisplaySize + this.capePadding) + this.capePadding;
            if (absoluteMouseY >= (currentY += 20) && absoluteMouseY < currentY + sectionHeight) {
                return this.findCapeInGrid(mouseX, mouseY, absoluteMouseY, currentY, this.localCapes);
            }
            currentY += sectionHeight;
        }
        if (!this.knownCapes.isEmpty()) {
            currentY += 9;
            rows = (int)Math.ceil((double)this.knownCapes.size() / (double)this.capesPerRow);
            sectionHeight = rows * (this.capeDisplaySize + this.capePadding) + this.capePadding;
            if (absoluteMouseY >= (currentY += 20) && absoluteMouseY < currentY + sectionHeight) {
                return this.findCapeInGrid(mouseX, mouseY, absoluteMouseY, currentY, this.knownCapes);
            }
        }
        return null;
    }

    private Object findCapeInGrid(int mouseX, int mouseY, int absoluteMouseY, int sectionTopY, List<?> capes) {
        int capeY;
        int capeX;
        int relX = mouseX - this.gridX - this.capePadding;
        int relY = absoluteMouseY - sectionTopY - this.capePadding;
        int col = relX / (this.capeDisplaySize + this.capePadding);
        int row = relY / (this.capeDisplaySize + this.capePadding);
        if (col < 0 || col >= this.capesPerRow) {
            return null;
        }
        int index = row * this.capesPerRow + col;
        if (index >= 0 && index < capes.size() && this.isMouseOver(mouseX, mouseY, capeX = this.gridX + this.capePadding + col * (this.capeDisplaySize + this.capePadding), capeY = sectionTopY + this.capePadding + row * (this.capeDisplaySize + this.capePadding) - (int)this.scrollOffset, this.capeDisplaySize, this.capeDisplaySize)) {
            return capes.get(index);
        }
        return null;
    }

    private boolean isMouseOverGrid(int mouseX, int mouseY) {
        return mouseX >= this.gridX && mouseX < this.gridX + this.gridWidth && mouseY >= this.gridY && mouseY < this.gridY + this.gridHeight;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isMouseOverGrid((int)mouseX, (int)mouseY)) {
            this.targetScrollOffset = Mth.m_14008_((double)(this.targetScrollOffset - delta * (double)this.scrollSpeed), (double)0.0, (double)this.maxScroll);
            this.preloadVisibleTextures();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void openFileDialog() {
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.png;*.gif")).flip();
                String file = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select Cape", (CharSequence)"", (PointerBuffer)filters, (CharSequence)"PNG & GIF Images", (boolean)false);
                if (file != null && !file.isEmpty()) {
                    this.m_7400_(List.of(Path.of(file, new String[0])));
                }
            }
        });
    }

    private void renderScrollbar(GuiGraphics graphics) {
        if (this.maxScroll <= 0) {
            return;
        }
        int scrollbarWidth = this.scaleValue(6);
        int scrollbarX = this.gridX + this.gridWidth + 3;
        int scrollbarTrackEnd = this.gridY + this.gridHeight;
        graphics.m_280509_(scrollbarX, this.gridY, scrollbarX + scrollbarWidth, scrollbarTrackEnd, Integer.MIN_VALUE);
        int thumbHeight = Mth.m_14045_((int)((int)((float)(this.gridHeight * this.gridHeight) / (float)this.totalContentHeight)), (int)this.scaleValue(32), (int)(this.gridHeight - 8));
        int thumbY = this.gridY + (int)(this.scrollOffset * (double)(this.gridHeight - thumbHeight) / (double)this.maxScroll);
        graphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -8355712);
        graphics.m_280509_(scrollbarX + 1, thumbY + 1, scrollbarX + scrollbarWidth - 1, thumbY + thumbHeight - 1, -4144960);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.starfield != null) {
            this.starfield.close();
        }
        BlurHandler.cleanup();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        Object currentSelection = this.selectedCapeObject;
        double currentScrollRatio = this.maxScroll > 0 ? this.scrollOffset / (double)this.maxScroll : 0.0;
        this.playerWidgetX = 0;
        this.playerWidgetY = 0;
        BlurHandler.cleanup();
        super.m_6574_(minecraft, width, height);
        this.selectedCapeObject = currentSelection;
        if (this.maxScroll > 0) {
            this.scrollOffset = this.targetScrollOffset = currentScrollRatio * (double)this.maxScroll;
        }
        this.preloadVisibleTextures();
    }

    private class SpeedSlider
    extends AbstractSliderButton {
        final double minSpeed = 0.05;
        final double maxSpeed = 0.5;

        public SpeedSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.minSpeed = 0.05;
            this.maxSpeed = 0.5;
            double currentSpeed = (Double)Config.ANIMATION_SPEED_MULTIPLIER.get();
            double clampedSpeed = Mth.m_14008_((double)currentSpeed, (double)0.05, (double)0.5);
            this.f_93577_ = Math.sqrt((clampedSpeed - 0.05) / 0.45);
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Controls animation speed from 10% (very slow) to 100%.")));
            this.m_5695_();
        }

        protected void m_5695_() {
            int percentage = (int)Math.round(10.0 + this.f_93577_ * 90.0);
            this.m_93666_((Component)Component.m_237113_((String)String.format("Animation Speed: %d%%", percentage)));
        }

        protected void m_5697_() {
            double v = this.f_93577_;
            double speed = 0.05 + v * v * 0.45;
            Config.ANIMATION_SPEED_MULTIPLIER.set((Object)speed);
        }

        public void m_7691_(double pMouseX, double pMouseY) {
            Config.ANIMATION_SPEED_MULTIPLIER.save();
        }
    }
}

