/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.screen;

import com.quickskin.mod.features.gui.client.effect.BlurHandler;
import com.quickskin.mod.features.gui.client.widget.ButtonFactory;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class RenameScreen
extends Screen {
    private final Screen parent;
    private final Component message;
    private final String initialValue;
    private final Consumer<String> callback;
    private EditBox nameEditBox;
    private Button confirmButton;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int MESSAGE_COLOR = 0xFFFFFF;
    private int panelWidth = 340;
    private int panelHeight = 180;
    private int panelX;
    private int panelY;

    public RenameScreen(Screen parent, Component title, Component message, String initialValue, Consumer<String> callback) {
        super(title);
        this.parent = parent;
        this.message = message;
        this.initialValue = initialValue;
        this.callback = callback;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
        int boxWidth = 260;
        int boxX = this.panelX + (this.panelWidth - boxWidth) / 2;
        int boxY = this.panelY + 75;
        this.nameEditBox = new EditBox(this.f_96547_, boxX, boxY, boxWidth, 20, this.f_96539_);
        this.nameEditBox.m_94199_(50);
        this.nameEditBox.m_94144_(this.initialValue);
        this.nameEditBox.m_94151_(this::onNameChanged);
        this.m_142416_((GuiEventListener)this.nameEditBox);
        this.m_264313_((GuiEventListener)this.nameEditBox);
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        this.m_142416_((GuiEventListener)ButtonFactory.createStyled(buttonStartX, buttonY, buttonWidth, buttonHeight, CommonComponents.f_130656_, button -> this.m_7379_()));
        this.confirmButton = (Button)this.m_142416_((GuiEventListener)ButtonFactory.createPrimary(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, CommonComponents.f_130655_, button -> {
            this.callback.accept(this.nameEditBox.m_94155_());
            this.m_7379_();
        }));
        this.onNameChanged(this.initialValue);
    }

    private void onNameChanged(String newName) {
        if (this.confirmButton != null) {
            this.confirmButton.f_93623_ = !newName.trim().isEmpty();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 257 || keyCode == 335) && this.confirmButton.f_93623_) {
            this.confirmButton.m_5691_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.m_88315_(graphics, -1, -1, partialTicks);
        }
        graphics.m_280262_();
        BlurHandler.renderBlur();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x60000000);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1342177280);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + 1, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        int titleY = this.panelY + 20;
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, titleY, 0xFFFFFF);
        if (!this.message.getString().isEmpty()) {
            int messageY = this.panelY + 45;
            graphics.m_280653_(this.f_96547_, this.message, this.f_96543_ / 2, messageY, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7861_() {
        super.m_7861_();
        BlurHandler.cleanup();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

