/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class CustomFontRenderer {
    private final Font awtFont;
    private final boolean antiAlias;
    private final boolean fractionalMetrics;
    private final Map<Character, CharData> charDataMap = new HashMap<Character, CharData>();
    private DynamicTexture fontTexture;
    private ResourceLocation fontTextureLocation;
    private final FontMetrics fontMetrics;
    private final FontRenderContext fontRenderContext;
    private final int textureWidth = 2048;
    private final int textureHeight = 2048;
    private int currentX = 0;
    private int currentY = 0;
    private int currentRowHeight = 0;
    private static final int PADDING = 2;

    public CustomFontRenderer(Font font, boolean antiAlias, boolean fractionalMetrics) {
        this.awtFont = font;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
        BufferedImage tempImage = new BufferedImage(1, 1, 2);
        Graphics2D g = tempImage.createGraphics();
        this.applyRenderingHints(g);
        g.setFont(this.awtFont);
        this.fontMetrics = g.getFontMetrics();
        this.fontRenderContext = g.getFontRenderContext();
        g.dispose();
        this.setupTexture();
    }

    private void setupTexture() {
        NativeImage image = new NativeImage(2048, 2048, true);
        this.fontTexture = new DynamicTexture(image);
        this.fontTextureLocation = Minecraft.m_91087_().m_91097_().m_118490_("custom_font_" + System.nanoTime(), this.fontTexture);
        String commonChars = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u2713";
        for (char c : commonChars.toCharArray()) {
            this.cacheChar(c);
        }
        this.fontTexture.m_117985_();
    }

    private void applyRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, 100);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.fractionalMetrics) {
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    private void cacheChar(char character) {
        if (this.charDataMap.containsKey(Character.valueOf(character))) {
            return;
        }
        Rectangle2D bounds = this.awtFont.getStringBounds(String.valueOf(character), this.fontRenderContext);
        if (character == ' ' || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            CharData charData = new CharData();
            charData.advance = this.fontMetrics.charWidth(character);
            charData.width = 0.0f;
            charData.height = 0.0f;
            this.charDataMap.put(Character.valueOf(character), charData);
            return;
        }
        int texWidth = (int)Math.ceil(bounds.getWidth()) + 2;
        int texHeight = (int)Math.ceil(bounds.getHeight()) + 2;
        if (this.currentX + texWidth >= 2048) {
            this.currentX = 0;
            this.currentY += this.currentRowHeight;
            this.currentRowHeight = 0;
        }
        if (this.currentY + texHeight >= 2048) {
            System.err.println("Custom font atlas is full!");
            return;
        }
        BufferedImage charImage = new BufferedImage(texWidth, texHeight, 2);
        Graphics2D g = charImage.createGraphics();
        this.applyRenderingHints(g);
        g.setFont(this.awtFont);
        g.setColor(Color.WHITE);
        g.drawString(String.valueOf(character), (float)(-bounds.getX()) + 1.0f, (float)(-bounds.getY()) + 1.0f);
        g.dispose();
        NativeImage nativeImage = this.fontTexture.m_117991_();
        if (nativeImage == null) {
            return;
        }
        for (int px = 0; px < texWidth; ++px) {
            for (int py = 0; py < texHeight; ++py) {
                int awtColor = charImage.getRGB(px, py);
                int alpha = awtColor >> 24 & 0xFF;
                nativeImage.m_84988_(this.currentX + px, this.currentY + py, 0xFFFFFF | alpha << 24);
            }
        }
        CharData charData = new CharData();
        charData.width = (float)bounds.getWidth();
        charData.height = (float)bounds.getHeight();
        charData.xOffset = (float)bounds.getX();
        charData.yOffset = (float)bounds.getY();
        charData.advance = this.fontMetrics.charWidth(character);
        charData.textureX = this.currentX;
        charData.textureY = this.currentY;
        charData.textureWidth = texWidth;
        charData.textureHeight = texHeight;
        this.charDataMap.put(Character.valueOf(character), charData);
        this.currentX += texWidth;
        this.currentRowHeight = Math.max(this.currentRowHeight, texHeight);
    }

    public void drawString(PoseStack poseStack, String text, float x, float y, int color) {
        if (text == null || text.isEmpty()) {
            return;
        }
        boolean needsUpload = false;
        for (char character : text.toCharArray()) {
            if (this.charDataMap.containsKey(Character.valueOf(character))) continue;
            this.cacheChar(character);
            needsUpload = true;
        }
        if (needsUpload) {
            this.fontTexture.m_117985_();
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.fontTextureLocation);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float currentX = x;
        float baselineY = y + (float)this.fontMetrics.getAscent();
        for (char character : text.toCharArray()) {
            CharData charData = this.charDataMap.get(Character.valueOf(character));
            if (charData == null || charData.width == 0.0f) {
                currentX += charData != null ? charData.advance : 0.0f;
                continue;
            }
            float glyphX = currentX + charData.xOffset;
            float glyphY = baselineY + charData.yOffset;
            float x0 = Math.round(glyphX);
            float y0 = Math.round(glyphY);
            float x1 = Math.round(glyphX + charData.width);
            float y1 = Math.round(glyphY + charData.height);
            float u0 = ((float)charData.textureX + 1.0f) / 2048.0f;
            float v0 = ((float)charData.textureY + 1.0f) / 2048.0f;
            float u1 = u0 + charData.width / 2048.0f;
            float v1 = v0 + charData.height / 2048.0f;
            bufferBuilder.m_252986_(matrix, x0, y0, 0.0f).m_7421_(u0, v0).m_85950_(red, green, blue, alpha).m_5752_();
            bufferBuilder.m_252986_(matrix, x0, y1, 0.0f).m_7421_(u0, v1).m_85950_(red, green, blue, alpha).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y1, 0.0f).m_7421_(u1, v1).m_85950_(red, green, blue, alpha).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y0, 0.0f).m_7421_(u1, v0).m_85950_(red, green, blue, alpha).m_5752_();
            currentX += charData.advance;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public float getStringWidth(String text) {
        float width = 0.0f;
        for (char c : text.toCharArray()) {
            CharData charData;
            if (!this.charDataMap.containsKey(Character.valueOf(c))) {
                this.cacheChar(c);
            }
            if ((charData = this.charDataMap.get(Character.valueOf(c))) == null) continue;
            width += charData.advance;
        }
        return width;
    }

    public int getFontHeight() {
        return this.fontMetrics.getHeight();
    }

    public void drawCenteredString(PoseStack poseStack, String text, float x, float y, int color) {
        float width = this.getStringWidth(text);
        this.drawString(poseStack, text, x - width / 2.0f, y, color);
    }

    public void drawStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        int shadowColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        this.drawString(poseStack, text, x + 1.0f, y + 1.0f, shadowColor);
        this.drawString(poseStack, text, x, y, color);
    }

    public void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        float width = this.getStringWidth(text);
        this.drawStringWithShadow(poseStack, text, x - width / 2.0f, y, color);
    }

    public void close() {
        if (this.fontTexture != null) {
            this.fontTexture.close();
            this.fontTexture = null;
        }
    }

    private static class CharData {
        public int textureX;
        public int textureY;
        public int textureWidth;
        public int textureHeight;
        public float width;
        public float height;
        public float xOffset;
        public float yOffset;
        public float advance;

        private CharData() {
        }
    }
}

