/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.util;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;

public class UIScalingHelper {
    public static ScalingInfo getScalingInfo() {
        return new ScalingInfo(Minecraft.m_91087_());
    }

    public static int getPercentWidth(int percentage) {
        ScalingInfo info = UIScalingHelper.getScalingInfo();
        return info.scaledWidth * percentage / 100;
    }

    public static int getPercentHeight(int percentage) {
        ScalingInfo info = UIScalingHelper.getScalingInfo();
        return info.scaledHeight * percentage / 100;
    }

    public static class ScalingInfo {
        public final int scaledWidth;
        public final int scaledHeight;
        public final int guiScale;
        public final float scaleFactor;
        public final ScreenSize screenSize;
        public final boolean useHighQualityText;
        public final float fontScale;

        private ScalingInfo(Minecraft mc) {
            Window window = mc.m_91268_();
            this.guiScale = window.m_85385_(((Integer)mc.f_91066_.m_231928_().m_231551_()).intValue(), mc.m_91390_());
            this.scaledWidth = window.m_85445_();
            this.scaledHeight = window.m_85446_();
            float widthScale = (float)this.scaledWidth / 1920.0f;
            float heightScale = (float)this.scaledHeight / 1080.0f;
            this.scaleFactor = Math.min(widthScale, heightScale);
            this.screenSize = this.determineScreenSize(this.scaledWidth);
            this.useHighQualityText = this.guiScale <= 2;
            this.fontScale = this.calculateFontScale();
        }

        private float calculateFontScale() {
            return 1.0f;
        }

        private ScreenSize determineScreenSize(int width) {
            if (width < 1366) {
                return ScreenSize.SMALL;
            }
            if (width < 1920) {
                return ScreenSize.MEDIUM;
            }
            if (width < 2560) {
                return ScreenSize.LARGE;
            }
            return ScreenSize.XLARGE;
        }
    }

    public static enum ScreenSize {
        SMALL,
        MEDIUM,
        LARGE,
        XLARGE;

    }
}

