/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.gui.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.Config;
import com.quickskin.mod.features.gui.client.widget.DangerButton;
import com.quickskin.mod.features.gui.client.widget.PrimaryButton;
import com.quickskin.mod.features.gui.client.widget.RotateButton;
import com.quickskin.mod.features.gui.client.widget.StyledButton;
import com.quickskin.mod.features.gui.client.widget.TabButton;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonFactory {
    public static Button createStyled(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        if (((Boolean)Config.ENABLE_STYLED_BUTTONS.get()).booleanValue()) {
            return new StyledButton(x, y, width, height, label, onPress);
        }
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(x, y, width, height).m_253136_();
    }

    public static Button createPrimary(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        if (((Boolean)Config.ENABLE_STYLED_BUTTONS.get()).booleanValue()) {
            return new PrimaryButton(x, y, width, height, label, onPress);
        }
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(x, y, width, height).m_253136_();
    }

    public static Button createDanger(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        return new DangerButton(x, y, width, height, label, onPress);
    }

    public static Button createRotate(int x, int y, int size, Button.OnPress onPress) {
        if (((Boolean)Config.ENABLE_STYLED_BUTTONS.get()).booleanValue()) {
            return new RotateButton(x, y, size, onPress);
        }
        MutableComponent buttonText = Component.m_237113_((String)"\u21ba");
        return new Button(x, y, size, size, (Component)buttonText, onPress, Supplier::get){

            public void m_280139_(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                Component message = this.m_6035_();
                PoseStack poseStack = pGuiGraphics.m_280168_();
                poseStack.m_85836_();
                float scale = 2.8f;
                float textWidth = pFont.m_92852_((FormattedText)message);
                poseStack.m_252880_((float)this.m_252754_() + (float)this.m_5711_() / 1.8f, (float)this.m_252907_() + (float)this.m_93694_() / 4.0f, 0.0f);
                poseStack.m_85841_(scale, scale, 1.0f);
                int n = (int)(-textWidth / 2.0f);
                Objects.requireNonNull(pFont);
                pGuiGraphics.m_280430_(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
                poseStack.m_85849_();
            }
        };
    }

    public static Button createTab(int x, int y, int width, int height, Component label, boolean selected, Button.OnPress onPress) {
        return new TabButton(x, y, width, height, label, selected, onPress);
    }
}

