/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.localstorage.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.core.data.AnimationMetadata;
import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.core.util.SkinModelDetector;
import com.quickskin.mod.features.animation.client.AnimatedTextureManager;
import com.quickskin.mod.features.animation.util.GifUtil;
import com.quickskin.mod.features.localstorage.client.HDTextureProcessor;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

@OnlyIn(value=Dist.CLIENT)
public class LocalAssetManager {
    public static final LocalAssetManager INSTANCE = new LocalAssetManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path skinsUploadDir;
    private final Path capesUploadDir;
    private final Path cacheDir;
    private final Path metadataDir;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);
    private final Map<String, AssetMetadata> metadataCache = new ConcurrentHashMap<String, AssetMetadata>();
    private final Map<String, ResourceLocation> registeredTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, ResourceLocation> previewTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, ResourceLocation> thumbnailTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, ResourceLocation> geckoLibTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, Path> hashToSourcePath = new ConcurrentHashMap<String, Path>();
    private final Map<String, CompletableFuture<ResourceLocation>> textureLoadingFutures = new ConcurrentHashMap<String, CompletableFuture<ResourceLocation>>();

    private LocalAssetManager() {
        Path gameDir = Minecraft.m_91087_().f_91069_.toPath();
        Path uploadsDir = gameDir.resolve("quickskin/uploads");
        this.skinsUploadDir = uploadsDir.resolve("skins");
        this.capesUploadDir = uploadsDir.resolve("capes");
        this.cacheDir = gameDir.resolve("quickskin_cache/local");
        this.metadataDir = gameDir.resolve("quickskin_cache/metadata");
        try {
            Files.createDirectories(this.skinsUploadDir, new FileAttribute[0]);
            Files.createDirectories(this.capesUploadDir, new FileAttribute[0]);
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            Files.createDirectories(this.metadataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to create local skin directories", (Throwable)e);
        }
        if (!this.executorService.isShutdown()) {
            CompletableFuture.runAsync(this::discoverLocalAssets, this.executorService);
        } else {
            this.discoverLocalAssets();
        }
    }

    public Path getSkinsUploadDir() {
        return this.skinsUploadDir;
    }

    public Path getCapesUploadDir() {
        return this.capesUploadDir;
    }

    public List<LocalAsset> discoverLocalAssets() {
        ArrayList<AssetMetadata> metadata = new ArrayList<AssetMetadata>();
        metadata.addAll(this.scanDirectoryFast(this.skinsUploadDir, "skin"));
        metadata.addAll(this.scanDirectoryFast(this.capesUploadDir, "cape"));
        this.metadataCache.clear();
        this.hashToSourcePath.clear();
        for (AssetMetadata meta : metadata) {
            this.metadataCache.put(meta.hash(), meta);
            if (meta.path() == null) continue;
            this.hashToSourcePath.put(meta.hash(), meta.path());
        }
        return metadata.stream().map(LocalAsset::fromMetadata).toList();
    }

    private List<AssetMetadata> scanDirectoryFast(Path dir, String type) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<AssetMetadata> found = new ArrayList<AssetMetadata>();
        try (Stream<Path> stream = Files.walk(dir, 1, new FileVisitOption[0]);){
            stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && (p.toString().toLowerCase().endsWith(".png") || p.toString().toLowerCase().endsWith(".gif") && "cape".equals(type))).forEach(path -> {
                try {
                    String hash = this.computeFileHash((Path)path);
                    boolean isOriginalGif = path.toString().toLowerCase().endsWith(".gif");
                    String friendlyName = path.getFileName().toString().replaceFirst("[.][^.]+$", "");
                    long fileSize = Files.size(path);
                    if (isOriginalGif) {
                        this.processGifAsset((Path)path, hash, friendlyName, type, fileSize, (List<AssetMetadata>)found);
                    } else {
                        this.processPngAsset((Path)path, hash, friendlyName, type, fileSize, (List<AssetMetadata>)found);
                    }
                }
                catch (Exception e) {
                    QuickSkin.LOGGER.warn("Failed to process asset {}: {}", (Object)path.getFileName(), (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to scan directory: {}", (Object)dir, (Object)e);
        }
        return found;
    }

    private void processPngAsset(Path path, String hash, String friendlyName, String type, long fileSize, List<AssetMetadata> found) throws IOException {
        Path metaPath;
        Path cachePath = this.cacheDir.resolve(hash + ".png");
        if (Files.notExists(cachePath, new LinkOption[0])) {
            Files.copy(path, cachePath, new CopyOption[0]);
        }
        boolean isAnimated = false;
        int frameCount = 1;
        SkinResolution resolution = null;
        String skinModel = null;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            BufferedImage img = ImageIO.read(is);
            if (img != null) {
                int w = img.getWidth();
                int h = img.getHeight();
                if ("cape".equals(type)) {
                    int frameHeight = w / 2;
                    if (frameHeight > 0 && h % frameHeight == 0) {
                        frameCount = h / frameHeight;
                        isAnimated = frameCount > 1;
                        resolution = this.detectCapeResolution(w, frameHeight);
                    } else {
                        isAnimated = false;
                        frameCount = 1;
                        resolution = this.detectCapeResolution(w, h);
                    }
                } else {
                    isAnimated = false;
                    frameCount = 1;
                    resolution = SkinResolution.fromDimensions(w, h);
                    skinModel = SkinModelDetector.detectSkinModel(img);
                }
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.warn("Could not read image dimensions for {}: {}", (Object)path.getFileName(), (Object)e.getMessage());
        }
        if (isAnimated && "cape".equals(type) && Files.notExists(metaPath = this.metadataDir.resolve(hash + ".json"), new LinkOption[0])) {
            ArrayList<GifUtil.FrameData> frames = new ArrayList<GifUtil.FrameData>();
            int defaultDelay = 50;
            for (int i = 0; i < frameCount; ++i) {
                frames.add(new GifUtil.FrameData(defaultDelay));
            }
            AnimationMetadata animMeta = new AnimationMetadata(frames, frameCount);
            try (BufferedWriter writer = Files.newBufferedWriter(metaPath, new OpenOption[0]);){
                GSON.toJson((Object)animMeta, (Appendable)writer);
            }
        }
        AssetMetadata metadata = new AssetMetadata(hash, friendlyName, type, path, resolution, isAnimated, frameCount, fileSize, skinModel);
        found.add(metadata);
    }

    private void processGifAsset(Path gifPath, String hash, String friendlyName, String type, long fileSize, List<AssetMetadata> found) throws IOException {
        AnimationMetadata animMeta;
        Path pngAtlasPath;
        block22: {
            pngAtlasPath = this.cacheDir.resolve(hash + ".png");
            Path metaPath = this.metadataDir.resolve(hash + ".json");
            animMeta = null;
            if (Files.exists(metaPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(metaPath);){
                    animMeta = (AnimationMetadata)GSON.fromJson((Reader)reader, AnimationMetadata.class);
                }
            }
            if (Files.notExists(pngAtlasPath, new LinkOption[0]) || animMeta == null) {
                QuickSkin.LOGGER.debug("Converting GIF to PNG atlas: {}", (Object)gifPath.getFileName());
                try (InputStream is = Files.newInputStream(gifPath, new OpenOption[0]);){
                    GifUtil.GifData gifData = GifUtil.processGif(is);
                    if (gifData == null) break block22;
                    LocalAssetManager.saveImageWithAlpha(gifData.atlas(), pngAtlasPath);
                    animMeta = new AnimationMetadata(gifData.frames(), gifData.frameCount());
                    try (BufferedWriter writer = Files.newBufferedWriter(metaPath, new OpenOption[0]);){
                        GSON.toJson((Object)animMeta, (Appendable)writer);
                    }
                }
            }
        }
        if (animMeta != null) {
            SkinResolution resolution = this.detectResolutionFast(pngAtlasPath, type, true);
            AssetMetadata metadata = new AssetMetadata(hash, friendlyName, type, gifPath, resolution, true, animMeta.frameCount(), fileSize, null);
            found.add(metadata);
        }
    }

    private String computeFileHash(Path path) throws IOException {
        long fileSize = Files.size(path);
        if (fileSize > 65536L) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                MessageDigest digest = DigestUtils.getSha1Digest();
                byte[] buffer = new byte[65536];
                int bytesRead = is.read(buffer);
                digest.update(buffer, 0, bytesRead);
                digest.update(Long.toString(fileSize).getBytes());
                String string = Hex.encodeHexString((byte[])digest.digest());
                return string;
            }
        }
        return DigestUtils.sha1Hex((byte[])Files.readAllBytes(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private SkinResolution detectResolutionFast(Path path, String type, boolean isAnimated) {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            BufferedImage img = ImageIO.read(is);
            if (img == null) return null;
            if ("cape".equals(type)) {
                AssetMetadata meta;
                int singleFrameHeight = img.getHeight();
                if (isAnimated && (meta = (AssetMetadata)this.metadataCache.values().stream().filter(m -> m.path().equals(path)).findFirst().orElse(null)) != null && meta.frameCount() > 0) {
                    singleFrameHeight = img.getHeight() / meta.frameCount();
                }
                SkinResolution skinResolution = this.detectCapeResolution(img.getWidth(), singleFrameHeight);
                return skinResolution;
            }
            SkinResolution skinResolution = SkinResolution.fromDimensions(img.getWidth(), img.getHeight());
            return skinResolution;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.debug("Could not detect resolution for {}: {}", (Object)path.getFileName(), (Object)e.getMessage());
        }
        return null;
    }

    public ResourceLocation getTextureLocation(String hash, TextureQuality quality) {
        Map<String, ResourceLocation> targetCache = this.getTargetCache(quality);
        ResourceLocation cached = targetCache.get(hash);
        if (cached != null) {
            return cached;
        }
        return this.loadTextureSync(hash, quality);
    }

    public ResourceLocation getTextureLocation(String hash, TextureQuality quality, boolean allowAsync) {
        Map<String, ResourceLocation> targetCache = this.getTargetCache(quality);
        ResourceLocation cached = targetCache.get(hash);
        if (cached != null) {
            return cached;
        }
        if (allowAsync && !this.executorService.isShutdown()) {
            String futureKey = hash + "_" + String.valueOf((Object)quality);
            this.textureLoadingFutures.computeIfAbsent(futureKey, k -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    return this.loadImageDataForRegistration(hash, quality);
                }
                catch (Exception e) {
                    QuickSkin.LOGGER.error("Async texture data loading failed for {}: {}", (Object)hash, (Object)e.getMessage());
                    return null;
                }
            }, this.executorService).thenApplyAsync(nativeImage -> {
                if (nativeImage == null) {
                    return DefaultPlayerSkin.m_118626_();
                }
                return this.registerDynamicTexture(hash, quality, (NativeImage)nativeImage, targetCache);
            }, (Executor)Minecraft.m_91087_())).exceptionally(throwable -> {
                QuickSkin.LOGGER.error("Async texture registration failed for {}: {}", (Object)hash, (Object)throwable.getMessage());
                return DefaultPlayerSkin.m_118626_();
            }));
            return DefaultPlayerSkin.m_118626_();
        }
        return this.loadTextureSync(hash, quality);
    }

    private ResourceLocation loadTextureSync(String hash, TextureQuality quality) {
        try {
            Map<String, ResourceLocation> targetCache = this.getTargetCache(quality);
            ResourceLocation cached = targetCache.get(hash);
            if (cached != null) {
                return cached;
            }
            NativeImage imageToRegister = this.loadImageDataForRegistration(hash, quality);
            if (imageToRegister != null) {
                return this.registerDynamicTexture(hash, quality, imageToRegister, targetCache);
            }
            return DefaultPlayerSkin.m_118626_();
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to sync load texture {}: {}", (Object)hash, (Object)e.getMessage());
            return DefaultPlayerSkin.m_118626_();
        }
    }

    @Nullable
    private NativeImage loadImageDataForRegistration(String hash, TextureQuality quality) throws IOException {
        Path texturePath = this.getCachePathForHash(hash);
        if (texturePath == null) {
            return null;
        }
        AssetMetadata metadata = this.metadataCache.get(hash);
        String assetType = metadata != null ? metadata.type() : "skin";
        try (InputStream inputStream = Files.newInputStream(texturePath, new OpenOption[0]);){
            NativeImage nativeImage;
            NativeImage imageToProcess;
            if ("skin".equals(assetType)) {
                imageToProcess = HDTextureProcessor.processHDSkin(inputStream, true);
            } else {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage == null) {
                    NativeImage nativeImage2 = null;
                    return nativeImage2;
                }
                imageToProcess = LocalAssetManager.convertToNativeImage(bufferedImage);
            }
            if (imageToProcess != null) {
                nativeImage = this.applyQualityAdjustment(imageToProcess, quality);
                return nativeImage;
            }
            nativeImage = null;
            return nativeImage;
        }
    }

    @Nullable
    public AnimationMetadata getAnimationMetadata(String hash) {
        Path metaPath = this.metadataDir.resolve(hash + ".json");
        if (Files.exists(metaPath, new LinkOption[0])) {
            AnimationMetadata animationMetadata;
            block9: {
                BufferedReader reader = Files.newBufferedReader(metaPath);
                try {
                    animationMetadata = (AnimationMetadata)GSON.fromJson((Reader)reader, AnimationMetadata.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        QuickSkin.LOGGER.error("Failed to read animation metadata for {}", (Object)hash, (Object)e);
                    }
                }
                ((Reader)reader).close();
            }
            return animationMetadata;
        }
        return null;
    }

    @Nullable
    public GifUtil.GifData getGifData(String hash) {
        if (!this.isAnimated(hash)) {
            return null;
        }
        AnimationMetadata meta = this.getAnimationMetadata(hash);
        if (meta == null) {
            return null;
        }
        BufferedImage atlas = this.getSourceImage(hash);
        if (atlas == null) {
            return null;
        }
        return new GifUtil.GifData(atlas, meta.frames(), meta.frameCount());
    }

    public boolean isAnimated(String hash) {
        AssetMetadata metadata = this.metadataCache.get(hash);
        return metadata != null && metadata.isAnimated();
    }

    public int getFrameCountEstimate(String hash) {
        AssetMetadata metadata = this.metadataCache.get(hash);
        return metadata != null ? metadata.frameCount() : 1;
    }

    public Map<String, ResourceLocation> getTargetCache(TextureQuality quality) {
        return switch (quality) {
            default -> throw new IncompatibleClassChangeError();
            case TextureQuality.FULL -> this.registeredTextures;
            case TextureQuality.PREVIEW -> this.previewTextures;
            case TextureQuality.THUMBNAIL -> this.thumbnailTextures;
            case TextureQuality.GECKOLIB_NORMALIZED -> this.geckoLibTextures;
        };
    }

    @Nullable
    private Path getCachePathForHash(String hash) {
        Path pngPath = this.cacheDir.resolve(hash + ".png");
        if (Files.exists(pngPath, new LinkOption[0])) {
            return pngPath;
        }
        return null;
    }

    private SkinResolution detectCapeResolution(int width, int height) {
        if (height <= 0 || width != height * 2) {
            return null;
        }
        return SkinResolution.fromDimensions(width, height);
    }

    private ResourceLocation registerDynamicTexture(String hash, TextureQuality quality, NativeImage imageToRegister, Map<String, ResourceLocation> targetCache) {
        try {
            DynamicTexture dynamicTexture = new DynamicTexture(imageToRegister);
            String textureId = "quickskin/local/" + hash + "_" + quality.name().toLowerCase();
            ResourceLocation rl = Minecraft.m_91087_().m_91097_().m_118490_(textureId, dynamicTexture);
            targetCache.put(hash, rl);
            return rl;
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to register dynamic texture for {}", (Object)hash, (Object)e);
            imageToRegister.close();
            return DefaultPlayerSkin.m_118626_();
        }
    }

    private NativeImage applyQualityAdjustment(NativeImage sourceImage, TextureQuality quality) {
        int targetHeight;
        int targetWidth;
        switch (quality) {
            case FULL: {
                return sourceImage;
            }
            case PREVIEW: {
                targetWidth = 256;
                targetHeight = 256;
                break;
            }
            case THUMBNAIL: 
            case GECKOLIB_NORMALIZED: {
                targetWidth = 64;
                targetHeight = 64;
                break;
            }
            default: {
                return sourceImage;
            }
        }
        if (sourceImage.m_84982_() <= targetWidth && sourceImage.m_85084_() <= targetHeight) {
            return sourceImage;
        }
        NativeImage downsampled = new NativeImage(targetWidth, targetHeight, true);
        sourceImage.m_85034_(0, 0, sourceImage.m_84982_(), sourceImage.m_85084_(), downsampled);
        sourceImage.close();
        return downsampled;
    }

    public List<LocalAsset> scanAndCacheUploads() {
        return this.discoverLocalAssets();
    }

    public boolean hasTexture(String hash) {
        return this.getCachePathForHash(hash) != null;
    }

    public void saveTexture(String hash, byte[] data) {
        if (this.hasTexture(hash)) {
            return;
        }
        try {
            Path path = this.cacheDir.resolve(hash + ".png");
            Files.write(path, data, new OpenOption[0]);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save texture from network: {}", (Object)hash, (Object)e);
        }
    }

    @Nullable
    public byte[] getTextureBytes(String hash) {
        Path path = this.getCachePathForHash(hash);
        if (path == null) {
            return null;
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to read texture from cache: {}", (Object)hash, (Object)e);
            return null;
        }
    }

    public ResourceLocation getTextureLocation(String hash) {
        return this.getTextureLocation(hash, TextureQuality.FULL);
    }

    @Nullable
    public SkinResolution getResolution(String hash) {
        AssetMetadata metadata = this.metadataCache.get(hash);
        return metadata != null ? metadata.resolution() : null;
    }

    public RenameResult renameLocalAsset(String hash, String newFriendlyName) {
        return RenameResult.SUCCESS;
    }

    public DeleteResult deleteLocalAsset(String hash) {
        AssetMetadata metadata = this.metadataCache.get(hash);
        if (metadata == null) {
            return DeleteResult.NOT_FOUND;
        }
        try {
            Files.deleteIfExists(metadata.path());
            Files.deleteIfExists(this.cacheDir.resolve(hash + ".png"));
            Files.deleteIfExists(this.metadataDir.resolve(hash + ".json"));
            QuickSkin.LOGGER.debug("Deleted source and cached assets for hash: {}", (Object)hash);
            this.metadataCache.remove(hash);
            this.hashToSourcePath.remove(hash);
            this.registeredTextures.remove(hash);
            this.previewTextures.remove(hash);
            this.thumbnailTextures.remove(hash);
            this.geckoLibTextures.remove(hash);
            String animationId = "cape_" + hash;
            if (AnimatedTextureManager.hasAnimation(animationId)) {
                AnimatedTextureManager.removeAnimation(animationId);
            }
            QuickSkin.LOGGER.info("Deleted and cleaned up local asset with hash: {}", (Object)hash);
            return DeleteResult.SUCCESS;
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to delete asset with hash {}: {}", (Object)hash, (Object)e);
            return DeleteResult.IO_ERROR;
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Nullable
    public BufferedImage getSourceImage(String hash) {
        Path path = this.getCachePathForHash(hash);
        if (path != null) {
            BufferedImage bufferedImage;
            block9: {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    bufferedImage = ImageIO.read(is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        QuickSkin.LOGGER.error("Failed to read source image for hash {}: {}", (Object)hash, (Object)e);
                    }
                }
                is.close();
            }
            return bufferedImage;
        }
        return null;
    }

    public static NativeImage convertToNativeImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        NativeImage nativeImage = new NativeImage(width, height, true);
        boolean disableTransparency = ClientSkinManager.getInstance().shouldDisableSkinTransparency();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                if (disableTransparency) {
                    argb = argb & 0xFFFFFF | 0xFF000000;
                }
                int abgr = argb & 0xFF00FF00 | (argb & 0xFF) << 16 | (argb & 0xFF0000) >> 16;
                nativeImage.m_84988_(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public void saveTextureToUpload(String hash, byte[] data, String type, @Nullable SkinResolution resolution, String friendlyName) {
        try {
            Path targetDir = "cape".equals(type) ? this.capesUploadDir : this.skinsUploadDir;
            String safeFilename = friendlyName.replaceAll("[^a-zA-Z0-9._\\-]", "_") + ".png";
            Path targetPath = targetDir.resolve(safeFilename);
            int counter = 1;
            while (Files.exists(targetPath, new LinkOption[0])) {
                String nameWithoutExt = friendlyName.replaceAll("[^a-zA-Z0-9._\\-]", "_");
                safeFilename = nameWithoutExt + "_" + counter + ".png";
                targetPath = targetDir.resolve(safeFilename);
                ++counter;
            }
            Files.write(targetPath, data, new OpenOption[0]);
            QuickSkin.LOGGER.info("Saved to upload directory: {} -> {}", (Object)friendlyName, (Object)targetPath.getFileName());
            boolean isAnimated = "cape".equals(type) && this.getAnimationMetadata(hash) != null;
            int frameCount = isAnimated ? this.getAnimationMetadata(hash).frameCount() : 1;
            AssetMetadata metadata = new AssetMetadata(hash, friendlyName, type, targetPath, resolution, isAnimated, frameCount, data.length, null);
            this.metadataCache.put(hash, metadata);
            QuickSkin.LOGGER.info("Created metadata for {} texture: {} (hash: {})", new Object[]{type, friendlyName, hash});
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Failed to save to upload directory: {}", (Object)friendlyName, (Object)e);
        }
    }

    public void saveTextureAndCreateMetadata(String hash, byte[] data, String type, @Nullable SkinResolution resolution) {
        this.saveTexture(hash, data);
        if (!this.metadataCache.containsKey(hash)) {
            boolean isAnimated = "cape".equals(type) && this.getAnimationMetadata(hash) != null;
            int frameCount = isAnimated ? this.getAnimationMetadata(hash).frameCount() : 1;
            AssetMetadata partialMeta = new AssetMetadata(hash, "Network Asset", type, null, resolution, isAnimated, frameCount, data.length, null);
            this.metadataCache.put(hash, partialMeta);
            QuickSkin.LOGGER.info("Created partial metadata for networked {} texture: {}", (Object)type, (Object)hash);
        }
    }

    public void saveAnimationMetadata(String hash, AnimationMetadata metadata) {
        AssetMetadata oldMeta;
        Path metaPath = this.metadataDir.resolve(hash + ".json");
        if (Files.notExists(metaPath, new LinkOption[0])) {
            try (BufferedWriter writer = Files.newBufferedWriter(metaPath, new OpenOption[0]);){
                GSON.toJson((Object)metadata, (Appendable)writer);
                QuickSkin.LOGGER.info("Saved animation metadata from network for hash: {}", (Object)hash);
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Failed to save animation metadata from network for hash {}: {}", (Object)hash, (Object)e);
            }
        }
        if ((oldMeta = this.metadataCache.get(hash)) != null) {
            boolean isAnimated;
            boolean bl = isAnimated = metadata.frameCount() > 1;
            if (oldMeta.isAnimated() != isAnimated) {
                AssetMetadata newMeta = new AssetMetadata(oldMeta.hash(), oldMeta.friendlyName(), oldMeta.type(), oldMeta.path(), oldMeta.resolution(), isAnimated, metadata.frameCount(), oldMeta.fileSize(), oldMeta.skinModel());
                this.metadataCache.put(hash, newMeta);
                QuickSkin.LOGGER.info("Corrected in-memory animation status for hash {}: isAnimated={}", (Object)hash, (Object)isAnimated);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveImageWithAlpha(BufferedImage image, Path outputPath) throws IOException {
        BufferedImage argbImage;
        if (image.getType() != 2) {
            argbImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = argbImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        } else {
            argbImage = image;
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        if (!writers.hasNext()) {
            QuickSkin.LOGGER.warn("No PNG writer found, using fallback");
            ImageIO.write((RenderedImage)argbImage, "png", outputPath.toFile());
            return;
        }
        ImageWriter writer = writers.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputPath.toFile());){
            writer.setOutput(ios);
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            writer.write(metadata, new IIOImage(argbImage, null, metadata), writeParam);
        }
        finally {
            writer.dispose();
        }
    }

    public void clearTextureCaches() {
        QuickSkin.LOGGER.info("Clearing all texture caches to reload with new settings");
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        this.registeredTextures.values().forEach(arg_0 -> ((TextureManager)textureManager).m_118513_(arg_0));
        this.previewTextures.values().forEach(arg_0 -> ((TextureManager)textureManager).m_118513_(arg_0));
        this.thumbnailTextures.values().forEach(arg_0 -> ((TextureManager)textureManager).m_118513_(arg_0));
        this.geckoLibTextures.values().forEach(arg_0 -> ((TextureManager)textureManager).m_118513_(arg_0));
        this.registeredTextures.clear();
        this.previewTextures.clear();
        this.thumbnailTextures.clear();
        this.geckoLibTextures.clear();
        this.textureLoadingFutures.clear();
    }

    public void clearPlayerSkinTextures() {
        QuickSkin.LOGGER.info("Clearing player skin textures (keeping GUI textures)");
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        this.registeredTextures.values().forEach(arg_0 -> ((TextureManager)textureManager).m_118513_(arg_0));
        this.registeredTextures.clear();
    }

    public record AssetMetadata(String hash, String friendlyName, String type, Path path, @Nullable SkinResolution resolution, boolean isAnimated, int frameCount, long fileSize, @Nullable String skinModel) {
    }

    public static enum TextureQuality {
        FULL,
        PREVIEW,
        THUMBNAIL,
        GECKOLIB_NORMALIZED;

    }

    public static enum RenameResult {
        SUCCESS,
        NAME_TAKEN,
        INVALID_NAME,
        IO_ERROR,
        NOT_FOUND;

    }

    public static enum DeleteResult {
        SUCCESS,
        NOT_FOUND,
        IO_ERROR;

    }

    public record LocalAsset(String hash, String friendlyName, String type, Path path, @Nullable SkinResolution resolution, boolean isAnimated, int frameCount, @Nullable String skinModel) {
        public static LocalAsset fromMetadata(AssetMetadata metadata) {
            return new LocalAsset(metadata.hash(), metadata.friendlyName(), metadata.type(), metadata.path(), metadata.resolution(), metadata.isAnimated(), metadata.frameCount(), metadata.skinModel());
        }
    }
}

