/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.localstorage.common;

import net.minecraft.resources.ResourceLocation;

public enum KnownCapes {
    NONE("No Cape", "__NONE__", "Remove cape", true, 0, false),
    RICKROLL("Rickroll Cape", "rickroll", "Never gonna give you up", true, 0, true, true),
    ANGEL("Angel Cape", "angel", "A custom mod cape", true, 0, true),
    AXOLOTL("Axolotl Cape", "axolotl", "A custom mod cape", true, 0, true),
    BMO("BMO Cape", "bmo", "Or Football?!", true, 0, true),
    CAT("Cat Cape", "cat", "A custom mod cape", true, 0, true),
    DEMON("Demon Cape", "demon", "A custom mod cape", true, 0, true),
    FOX("Fox Cape", "fox", "A custom mod cape", true, 0, true),
    GLASS("Glass Cape", "glass", "A custom mod cape", true, 0, true),
    HEART("Heart Cape", "heart", "A custom mod cape", true, 0, true),
    INTERROGATION("Interrogation Cape", "interrogation", "A custom mod cape", true, 0, true),
    NETHER_PORTAL("Nether Portal Cape", "nether_portal", "A custom mod cape", true, 0, true),
    OLD("Old Cape", "old", "A custom mod cape", true, 0, true),
    BURNOUT("Burnout Cape", "burnout", "A custom mod cape", true, 0, true),
    STRAWBERRY("Strawberry Cape", "strawberry", "A custom mod cape", true, 0, true),
    WAFFLE("Waffle Cape", "waffle", "A custom mod cape", true, 0, true),
    WARDE("Warden Cape", "warden", "A custom mod cape", true, 0, true),
    MIGRATOR("Migrator Cape", "migrator", "Red cape with gold trim", true, 5600000, false),
    ANNIVERSARY_15TH("15th Anniversary Cape", "15th_anniversary", "Green creeper cape with '15'", true, 1300000, false),
    FOLLOWERS("Follower's Cape", "followers", "TikTok cape", true, 700000, false),
    VANILLA("Vanilla Cape", "vanilla", "Orange cape for Java+Bedrock owners", true, 600000, false),
    PAN("Pan Cape", "pan", "Pancake cape for all Bedrock players", true, 600000, false),
    CHERRY_BLOSSOM("Cherry Blossom Cape", "cherry_blossom", "Pink cape from 2023 mob vote", true, 450000, false),
    PURPLE_HEART("Purple Heart Cape", "purple_heart", "Twitch cape", true, 380000, false),
    PRIDE("Pride Cape", "pride", "2023 Pride celebration cape", true, 275000, false),
    COMMON("Common Cape", "common", "Gray cape", true, 270000, false),
    MENACE("Menace Cape", "menace", "Purple cape", true, 250000, false),
    MOJANG_OFFICE("Mojang Office Cape", "mojang_office", "Office cape", false, 178000, false),
    HOME("Home Cape", "home", "Light blue cape", false, 170000, false),
    YEARN("Yearn Cape", "yearn", "Gray cape", false, 132000, false),
    MCC_15TH_YEAR("MCC 15th Year", "mcc_15th", "Minecraft Championship cape", true, 100000, false),
    COPPER("Copper Cape", "copper", "New official copper-themed cape", true, 100000, false),
    FOUNDERS("Founder's Cape", "founders", "Minecon 2019 cape", false, 49000, false),
    XBOX("Xbox Cape", "xbox", "Xbox Game Studios anniversary cape", false, 45000, false),
    MINECRAFT_EXPERIENCE("Experience Cape", "experience", "Minecraft Experience event", false, 18000, false),
    MINECON_2016("MineCon 2016", "minecon_2016", "Enderman cape", false, 7200, false),
    MINECON_2015("MineCon 2015", "minecon_2015", "Iron golem cape", false, 6800, false),
    MINECON_2013("MineCon 2013", "minecon_2013", "Green piston cape", false, 6000, false),
    MINECON_2012("MineCon 2012", "minecon_2012", "Blue pickaxe cape", false, 4000, false),
    MINECON_2011("MineCon 2011", "minecon_2011", "Red creeper cape", false, 3500, false),
    REALMS_MAPMAKER("Realms Mapmaker", "realms", "For Realms content creators", false, 370, false),
    MOJANG("Mojang Cape", "mojang", "Classic Mojang employee cape", false, 200, false),
    MOJANG_STUDIOS("Mojang Studios Cape", "mojang_studios", "New Mojang Studios cape", false, 160, false),
    TRANSLATOR("Translator Cape", "translator", "For translation contributors", false, 80, false),
    MOJIRA_MODERATOR("Mojira Moderator", "mojira", "Bug tracker moderators", false, 55, false),
    MOJANG_CLASSIC("Mojang (Classic)", "mojang_classic", "Old Mojang cape", false, 25, false),
    COBALT("Cobalt Cape", "cobalt", "Cobalt game champion", false, 17, false),
    SCROLLS("Scrolls Cape", "scrolls", "Scrolls game champion", false, 9, false),
    TURTLE("Turtle Cape", "turtle", "Personal cape", false, 3, false),
    VALENTINE("Valentine Cape", "valentine", "Valentine's cape", false, 2, false),
    TEST("Test Cape", "test", "Test cape", false, 2, false),
    MILLIONTH_CUSTOMER("Millionth Customer", "millionth", "1,000,000th customer cape", false, 1, false),
    PRISMARINE("Prismarine Cape", "prismarine", "Personal cape", false, 1, false),
    SNOWMAN("Snowman Cape", "snowman", "Ray Cokes cape", false, 1, false),
    SPADE("Spade Cape", "spade", "Personal cape", false, 1, false),
    BIRTHDAY("Birthday Cape", "birthday", "Birthday cape", false, 1, false),
    DB("dB Cape", "db", "Personal cape", false, 1, false),
    OXEYE("Oxeye Cape", "oxeye", "Personal cape", false, 1, false),
    BACON("Bacon Cape", "bacon", "Personal cape for Miclee", false, 1, false),
    CUBED("Cubed Cape", "cubed", "Personal cape for Dr. Cubed", false, 1, false),
    FROG("Frog Cape", "frog", "Personal cape for Grumm", false, 1, false),
    SNAIL("Snail Cape", "snail", "Personal cape for Bile", false, 1, false);

    private final String displayName;
    private final String id;
    private final String description;
    private final boolean obtainable;
    private final int approximateOwners;
    private final ResourceLocation textureLocation;
    private final boolean isCustom;
    private final boolean isAnimated;

    private KnownCapes(String displayName, String id, String description, boolean obtainable, int approximateOwners, boolean isCustom) {
        this(displayName, id, description, obtainable, approximateOwners, isCustom, false);
    }

    private KnownCapes(String displayName, String id, String description, boolean obtainable, int approximateOwners, boolean isCustom, boolean isAnimated) {
        this.displayName = displayName;
        this.id = id;
        this.description = description;
        this.obtainable = obtainable;
        this.approximateOwners = approximateOwners;
        this.isCustom = isCustom;
        this.isAnimated = isAnimated;
        this.textureLocation = id.equals("__NONE__") ? null : ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)("textures/capes/" + id + ".png"));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObtainable() {
        return this.obtainable;
    }

    public int getApproximateOwners() {
        return this.approximateOwners;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public static KnownCapes getById(String id) {
        for (KnownCapes cape : KnownCapes.values()) {
            if (!cape.getId().equalsIgnoreCase(id)) continue;
            return cape;
        }
        return null;
    }

    public boolean isNoCape() {
        return this == NONE;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }
}

