/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.packet;

import com.quickskin.mod.features.networking.server.ServerConfigManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record C2SServerConfigPacket(String key, boolean value) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.key);
        buf.writeBoolean(this.value);
    }

    public static C2SServerConfigPacket decode(FriendlyByteBuf buf) {
        return new C2SServerConfigPacket(buf.m_130277_(), buf.readBoolean());
    }

    public static void handle(C2SServerConfigPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (!player.m_20310_(2)) {
                return;
            }
            ServerConfigManager.getInstance(player.f_8924_).setConfig(msg.key(), msg.value());
            ServerConfigManager.getInstance(player.f_8924_).broadcastConfig(msg.key());
        });
    }
}

