/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.packet;

import com.quickskin.mod.event.ServerEvents;
import com.quickskin.mod.features.appearance.common.SkinAPI;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record C2SUpdateSkinPacket(String skinUsername, String capeId, String model) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.skinUsername);
        buf.m_130070_(this.capeId);
        buf.m_130070_(this.model);
    }

    public static C2SUpdateSkinPacket decode(FriendlyByteBuf buf) {
        return new C2SUpdateSkinPacket(buf.m_130277_(), buf.m_130277_(), buf.m_130277_());
    }

    public static void handle(C2SUpdateSkinPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (msg.skinUsername().isBlank()) {
                ServerEvents.setCustomLook(player, null, null, null);
                return;
            }
            ServerEvents.setCustomLook(player, msg.skinUsername(), msg.capeId(), msg.model());
            if (!msg.skinUsername().startsWith("local_skin:")) {
                SkinAPI.fetchProfile(msg.skinUsername()).thenAcceptAsync(skinProfile -> {
                    if (skinProfile == null) {
                        player.m_213846_((Component)Component.m_237113_((String)("Could not find player " + msg.skinUsername())));
                    }
                }, (Executor)player.f_8924_);
            }
        });
    }
}

