/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.packet;

import com.quickskin.mod.core.data.AnimationMetadata;
import com.quickskin.mod.features.animation.util.GifUtil;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.networking.packet.S2CSendAnimationMetadataPacket;
import com.quickskin.mod.features.networking.server.ServerAnimationCache;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SUploadAnimationMetadataPacket(String hash, AnimationMetadata metadata) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.writeInt(this.metadata.frameCount());
        buf.m_236828_(this.metadata.frames(), (b, frame) -> b.writeInt(frame.delay()));
    }

    public static C2SUploadAnimationMetadataPacket decode(FriendlyByteBuf buf) {
        String hash = buf.m_130277_();
        int frameCount = buf.readInt();
        List frames = (List)buf.m_236838_(ArrayList::new, b -> new GifUtil.FrameData(b.readInt()));
        return new C2SUploadAnimationMetadataPacket(hash, new AnimationMetadata(frames, frameCount));
    }

    public static void handle(C2SUploadAnimationMetadataPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ServerAnimationCache.getInstance().storeMetadata(msg.hash(), msg.metadata());
            S2CSendAnimationMetadataPacket broadcastPacket = new S2CSendAnimationMetadataPacket(msg.hash(), msg.metadata());
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)broadcastPacket);
        });
        ctx.setPacketHandled(true);
    }
}

