/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.packet;

import com.quickskin.mod.client.ClientSkinManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CServerConfigPacket(String key, boolean value) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.key);
        buf.writeBoolean(this.value);
    }

    public static S2CServerConfigPacket decode(FriendlyByteBuf buf) {
        return new S2CServerConfigPacket(buf.m_130277_(), buf.readBoolean());
    }

    public static void handle(S2CServerConfigPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> S2CServerConfigPacket.handleClientSide(msg.key(), msg.value())));
        ctx.setPacketHandled(true);
    }

    private static void handleClientSide(String key, boolean value) {
        switch (key) {
            case "disableSkinTransparency": {
                ClientSkinManager.getInstance().setServerDisableSkinTransparency(value);
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91080_ != null) break;
                ClientSkinManager.getInstance().checkAndReloadIfPending();
                break;
            }
        }
    }
}

