/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.packet;

import com.quickskin.mod.core.data.SkinResolution;
import com.quickskin.mod.features.networking.client.TextureChunkReceiver;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record S2CTextureChunkPacket(String hash, int chunkIndex, int totalChunks, byte[] chunkData, @Nullable SkinResolution resolution) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130087_(this.chunkData);
        buf.writeBoolean(this.resolution != null);
        if (this.resolution != null) {
            buf.m_130068_((Enum)this.resolution);
        }
    }

    public static S2CTextureChunkPacket decode(FriendlyByteBuf buf) {
        String hash = buf.m_130277_();
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        byte[] chunkData = buf.m_130052_();
        SkinResolution resolution = null;
        if (buf.readBoolean()) {
            resolution = (SkinResolution)buf.m_130066_(SkinResolution.class);
        }
        return new S2CTextureChunkPacket(hash, chunkIndex, totalChunks, chunkData, resolution);
    }

    public static void handle(S2CTextureChunkPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            if (msg.chunkIndex < 0 || msg.chunkIndex >= msg.totalChunks) {
                return;
            }
            TextureChunkReceiver.getInstance().receiveChunk(msg.hash(), msg.chunkIndex(), msg.totalChunks(), msg.chunkData(), msg.resolution());
        });
        ctx.setPacketHandled(true);
    }
}

