/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.server;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.core.data.AnimationMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerAnimationCache {
    private static final ServerAnimationCache INSTANCE = new ServerAnimationCache();
    private final Map<String, AnimationMetadata> metadataCache = new ConcurrentHashMap<String, AnimationMetadata>();

    public static ServerAnimationCache getInstance() {
        return INSTANCE;
    }

    public void storeMetadata(String hash, AnimationMetadata metadata) {
        if (!this.metadataCache.containsKey(hash)) {
            this.metadataCache.put(hash, metadata);
            QuickSkin.LOGGER.info("[SERVER] Stored new animation metadata for hash: {}", (Object)hash);
        }
    }

    public boolean hasMetadata(String hash) {
        return this.metadataCache.containsKey(hash);
    }

    public AnimationMetadata getMetadata(String hash) {
        return this.metadataCache.get(hash);
    }

    public Map<String, AnimationMetadata> getMetadataCacheView() {
        return Collections.unmodifiableMap(this.metadataCache);
    }

    public static void clear() {
        ServerAnimationCache.INSTANCE.metadataCache.clear();
        QuickSkin.LOGGER.info("[SERVER] Cleared animation metadata cache.");
    }
}

