/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.server;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.features.networking.PacketHandler;
import com.quickskin.mod.features.networking.packet.S2CServerConfigPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.network.PacketDistributor;

public class ServerConfigManager
extends SavedData {
    private static final String DATA_NAME = "quickskin_server_config";
    private final Map<String, Boolean> configMap = new HashMap<String, Boolean>();

    public ServerConfigManager() {
        this.configMap.put("disableSkinTransparency", false);
    }

    public static ServerConfigManager getInstance(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (ServerConfigManager)storage.m_164861_(ServerConfigManager::load, ServerConfigManager::new, DATA_NAME);
    }

    public static ServerConfigManager load(CompoundTag tag) {
        ServerConfigManager manager = new ServerConfigManager();
        if (tag.m_128441_("disableSkinTransparency")) {
            manager.configMap.put("disableSkinTransparency", tag.m_128471_("disableSkinTransparency"));
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        for (Map.Entry<String, Boolean> entry : this.configMap.entrySet()) {
            tag.m_128379_(entry.getKey(), entry.getValue().booleanValue());
        }
        return tag;
    }

    public boolean getConfig(String key) {
        return this.configMap.getOrDefault(key, false);
    }

    public void setConfig(String key, boolean value) {
        this.configMap.put(key, value);
        this.m_77762_();
        QuickSkin.LOGGER.info("Server config updated: {} = {}", (Object)key, (Object)value);
    }

    public void broadcastConfig(String key) {
        boolean value = this.getConfig(key);
        S2CServerConfigPacket packet = new S2CServerConfigPacket(key, value);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
        QuickSkin.LOGGER.info("Broadcasting server config to all clients: {} = {}", (Object)key, (Object)value);
    }

    public void syncToPlayer(ServerPlayer player) {
        for (Map.Entry<String, Boolean> entry : this.configMap.entrySet()) {
            S2CServerConfigPacket packet = new S2CServerConfigPacket(entry.getKey(), entry.getValue());
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
        QuickSkin.LOGGER.info("Synced server config to player: {}", (Object)player.m_7755_().getString());
    }
}

