/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.networking.server;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.core.data.SkinResolution;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerTextureCache {
    private static final ServerTextureCache INSTANCE = new ServerTextureCache();
    private final Map<String, byte[]> textureCache = new ConcurrentHashMap<String, byte[]>();
    private final Map<String, SkinResolution> textureResolutions = new ConcurrentHashMap<String, SkinResolution>();
    private final Map<String, ChunkAssembly> incompleteTextures = new ConcurrentHashMap<String, ChunkAssembly>();
    private static final long MAX_CACHE_SIZE_BYTES = 0x6400000L;

    public static ServerTextureCache getInstance() {
        return INSTANCE;
    }

    public void storeTexture(String hash, byte[] data) {
        this.storeTexture(hash, data, null);
    }

    public void storeTexture(String hash, byte[] data, @Nullable SkinResolution resolution) {
        if (this.textureCache.containsKey(hash)) {
            return;
        }
        if (this.getCurrentCacheSize() + (long)data.length > 0x6400000L) {
            this.cleanupOldTextures();
        }
        this.textureCache.put(hash, data);
        if (resolution != null) {
            this.textureResolutions.put(hash, resolution);
        }
        QuickSkin.LOGGER.info("[SERVER] Stored new texture with hash: {} (size: {} bytes, resolution: {})", new Object[]{hash, data.length, resolution != null ? resolution.name() : "UNKNOWN"});
    }

    public boolean hasTexture(String hash) {
        return this.textureCache.containsKey(hash);
    }

    @Nullable
    public byte[] getTexture(String hash) {
        return this.textureCache.get(hash);
    }

    public void storeTextureChunk(String hash, int chunkIndex, int totalChunks, byte[] chunkData, @Nullable SkinResolution resolution) {
        ChunkAssembly assembly = this.incompleteTextures.computeIfAbsent(hash, k -> new ChunkAssembly(totalChunks, resolution));
        if (assembly.addChunk(chunkIndex, chunkData)) {
            byte[] completeData = assembly.assembleTexture();
            if (completeData != null) {
                this.storeTexture(hash, completeData, resolution);
            }
            this.incompleteTextures.remove(hash);
        }
    }

    @Nullable
    public SkinResolution getResolution(String hash) {
        return this.textureResolutions.get(hash);
    }

    private long getCurrentCacheSize() {
        return this.textureCache.values().stream().mapToLong(data -> ((byte[])data).length).sum();
    }

    private void cleanupOldTextures() {
        int toRemove = this.textureCache.size() / 4;
        this.textureCache.keySet().stream().limit(toRemove).forEach(hash -> {
            this.textureCache.remove(hash);
            this.textureResolutions.remove(hash);
        });
        QuickSkin.LOGGER.info("[SERVER] Cleaned up {} textures from cache", (Object)toRemove);
    }

    public static void clear() {
        ServerTextureCache.INSTANCE.textureCache.clear();
        ServerTextureCache.INSTANCE.textureResolutions.clear();
        ServerTextureCache.INSTANCE.incompleteTextures.clear();
        QuickSkin.LOGGER.info("[SERVER] Cleared texture cache.");
    }

    private static class ChunkAssembly {
        private final byte[][] chunks;
        private final boolean[] received;
        private final SkinResolution resolution;
        private int receivedCount = 0;

        public ChunkAssembly(int totalChunks, @Nullable SkinResolution resolution) {
            this.chunks = new byte[totalChunks][];
            this.received = new boolean[totalChunks];
            this.resolution = resolution;
        }

        public synchronized boolean addChunk(int index, byte[] data) {
            if (index < 0 || index >= this.chunks.length || this.received[index]) {
                return false;
            }
            this.chunks[index] = data;
            this.received[index] = true;
            ++this.receivedCount;
            return this.receivedCount == this.chunks.length;
        }

        @Nullable
        public byte[] assembleTexture() {
            if (this.receivedCount != this.chunks.length) {
                return null;
            }
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                totalSize += chunk.length;
            }
            byte[] result = new byte[totalSize];
            int offset = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, result, offset, chunk.length);
                offset += chunk.length;
            }
            return result;
        }
    }
}

