/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.webserver;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.features.webserver.handlers.ImportSkinHandler;
import com.quickskin.mod.features.webserver.handlers.StatusHandler;
import com.quickskin.mod.features.webserver.util.RateLimiter;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class WebServerManager {
    private static final Logger LOGGER = QuickSkin.LOGGER;
    public static final WebServerManager INSTANCE = new WebServerManager();
    private HttpServer server;
    private RateLimiter rateLimiter;
    private ScheduledExecutorService cleanupExecutor;
    private int currentPort;
    private boolean running = false;

    private WebServerManager() {
    }

    public boolean start(int port, String allowedOrigin, int maxRequestsPerMinute, String allowedUrlDomain) {
        int[] portsToTry;
        if (this.running) {
            LOGGER.warn("Web server is already running");
            return false;
        }
        for (int portToTry : portsToTry = new int[]{port, 25591, 25592, 25593, 25594, 25595}) {
            try {
                this.server = HttpServer.create(new InetSocketAddress("127.0.0.1", portToTry), 0);
                this.currentPort = portToTry;
                this.rateLimiter = new RateLimiter(maxRequestsPerMinute);
                this.server.createContext("/api/status", new StatusHandler(allowedOrigin, this.currentPort));
                this.server.createContext("/api/skins/import", new ImportSkinHandler(allowedOrigin, this.rateLimiter, allowedUrlDomain));
                this.server.setExecutor(Executors.newFixedThreadPool(4));
                this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor();
                this.cleanupExecutor.scheduleAtFixedRate(this.rateLimiter::cleanup, 1L, 1L, TimeUnit.MINUTES);
                this.server.start();
                this.running = true;
                if (portToTry != port) {
                    LOGGER.info("Port {} was in use, using alternative port {}", (Object)port, (Object)portToTry);
                }
                LOGGER.info("QuickSkin Web Server started on http://127.0.0.1:{}", (Object)this.currentPort);
                LOGGER.info("Allowed Origin: {}", (Object)allowedOrigin);
                return true;
            }
            catch (IOException e) {
                if (portToTry == portsToTry[portsToTry.length - 1]) {
                    LOGGER.error("Failed to start web server on any port", (Throwable)e);
                    return false;
                }
                LOGGER.debug("Port {} unavailable, trying next port", (Object)portToTry);
            }
        }
        return false;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        try {
            if (this.server != null) {
                this.server.stop(2);
                this.server = null;
            }
            if (this.cleanupExecutor != null) {
                this.cleanupExecutor.shutdown();
                try {
                    if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.cleanupExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.cleanupExecutor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.cleanupExecutor = null;
            }
            this.running = false;
            LOGGER.info("QuickSkin Web Server stopped");
        }
        catch (Exception e) {
            LOGGER.error("Error stopping web server", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getCurrentPort() {
        return this.currentPort;
    }
}

