/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.webserver.handlers;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.features.webserver.dto.StatusResponse;
import com.quickskin.mod.features.webserver.handlers.BaseHandler;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import org.slf4j.Logger;

public class StatusHandler
extends BaseHandler
implements HttpHandler {
    private static final Logger LOGGER = QuickSkin.LOGGER;
    private final int port;

    public StatusHandler(String allowedOrigin, int port) {
        super(allowedOrigin);
        this.port = port;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String method = exchange.getRequestMethod();
            if (method.equals("OPTIONS")) {
                this.setCorsHeaders(exchange);
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equals("GET")) {
                this.sendTextResponse(exchange, 405, "Method not allowed");
                return;
            }
            StatusResponse response = new StatusResponse("ok", "2.4.1", this.port, true);
            this.sendJsonResponse(exchange, 200, response);
        }
        catch (Exception e) {
            LOGGER.error("Error handling status request", (Throwable)e);
            this.sendTextResponse(exchange, 500, "Internal server error");
        }
    }
}

