/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.features.webserver.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class RateLimiter {
    private final int maxRequestsPerMinute;
    private final Map<String, RequestCounter> requestCounts = new ConcurrentHashMap<String, RequestCounter>();
    private final long windowMs = 60000L;

    public RateLimiter(int maxRequestsPerMinute) {
        this.maxRequestsPerMinute = maxRequestsPerMinute;
    }

    public boolean allowRequest(String clientAddress) {
        int currentCount;
        long now = System.currentTimeMillis();
        RequestCounter counter = this.requestCounts.computeIfAbsent(clientAddress, k -> new RequestCounter());
        if (now - counter.windowStart > 60000L) {
            counter.count.set(0);
            counter.windowStart = now;
        }
        return (currentCount = counter.count.incrementAndGet()) <= this.maxRequestsPerMinute;
    }

    public void cleanup() {
        long now = System.currentTimeMillis();
        this.requestCounts.entrySet().removeIf(entry -> now - ((RequestCounter)entry.getValue()).windowStart > 120000L);
    }

    private static class RequestCounter {
        AtomicInteger count = new AtomicInteger(0);
        long windowStart = System.currentTimeMillis();

        private RequestCounter() {
        }
    }
}

