/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<String> ACTIVE_SKIN;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SAVED_SKINS;
    public static final ForgeConfigSpec.IntValue DISK_CACHE_DURATION_HOURS;
    public static final ForgeConfigSpec.ConfigValue<String> ACTIVE_ANIMATION;
    public static final ForgeConfigSpec.EnumValue<HDSkinQuality> HD_SKIN_QUALITY;
    public static final ForgeConfigSpec.IntValue MAX_HD_CACHE_SIZE_MB;
    public static final ForgeConfigSpec.BooleanValue ENABLE_HD_SKINS;
    public static final ForgeConfigSpec.BooleanValue AUTO_DOWNSAMPLE_HD;
    public static final ForgeConfigSpec.BooleanValue ENABLE_ANIMATED_CAPES;
    public static final ForgeConfigSpec.IntValue MAX_GIF_FRAMES;
    public static final ForgeConfigSpec.IntValue MAX_GIF_SIZE_KB;
    public static final ForgeConfigSpec.IntValue ANIMATION_RENDER_DISTANCE;
    public static final ForgeConfigSpec.IntValue MAX_ANIMATION_FPS;
    public static final ForgeConfigSpec.DoubleValue ANIMATION_SPEED_MULTIPLIER;
    public static final ForgeConfigSpec.IntValue MAX_CONCURRENT_ANIMATIONS;
    public static final ForgeConfigSpec.IntValue ANIMATION_MEMORY_LIMIT_MB;
    public static final ForgeConfigSpec.BooleanValue ENABLE_ANIMATION_LOD;
    public static final ForgeConfigSpec.IntValue GIF_PROCESSING_THREADS;
    public static final ForgeConfigSpec SPEC;

    static {
        BUILDER.push("general");
        ACTIVE_SKIN = BUILDER.comment("The active skin to be applied, format: 'username:model;capeUsername'.").define("activeSkin", (Object)"");
        ACTIVE_ANIMATION = BUILDER.comment("The active animation to be used for the player preview.").define("activeAnimation", (Object)"animation.player.idle");
        SAVED_SKINS = BUILDER.comment("A list of saved skins for quick access, with each in the format: 'username:model;capeUsername'.").defineList("savedSkins", new ArrayList(), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("caching");
        DISK_CACHE_DURATION_HOURS = BUILDER.comment(new String[]{"How long to keep skin profiles in the local disk cache, in hours.", "The cache is stored in '.minecraft/quickskin_cache/'.", "Set to 0 to disable disk cache.", "Set to -1 for infinite cache time."}).defineInRange("diskCacheDurationHours", 24, -1, 8760);
        BUILDER.pop();
        BUILDER.push("hd_skins");
        ENABLE_HD_SKINS = BUILDER.comment("Enable support for HD (high resolution) skin textures.").define("enableHDSkins", true);
        HD_SKIN_QUALITY = BUILDER.comment(new String[]{"Quality setting for HD skin preview and rendering.", "LOW: Thumbnail quality for performance", "MEDIUM: Preview quality for balance", "HIGH: Full resolution for quality"}).defineEnum("hdSkinQuality", (Enum)HDSkinQuality.MEDIUM);
        MAX_HD_CACHE_SIZE_MB = BUILDER.comment("Maximum memory size for HD texture cache in MB.").defineInRange("maxHDCacheSizeMB", 256, 64, 2048);
        AUTO_DOWNSAMPLE_HD = BUILDER.comment("Automatically downsample HD skins for better performance.").define("autoDownsampleHD", true);
        BUILDER.pop();
        BUILDER.push("animated_capes");
        ENABLE_ANIMATED_CAPES = BUILDER.comment("Enable support for animated GIF capes.").define("enableAnimatedCapes", true);
        MAX_GIF_FRAMES = BUILDER.comment("Maximum number of frames allowed in animated capes.").defineInRange("maxGifFrames", 60, 1, 200);
        MAX_GIF_SIZE_KB = BUILDER.comment("Maximum file size for animated capes in KB.").defineInRange("maxGifSizeKB", 2048, 256, 8192);
        ANIMATION_RENDER_DISTANCE = BUILDER.comment("Distance in blocks at which animated capes stop animating for performance.").defineInRange("animationRenderDistance", 32, 8, 128);
        MAX_ANIMATION_FPS = BUILDER.comment("Maximum FPS for animated capes to prevent performance issues.").defineInRange("maxAnimationFPS", 20, 5, 60);
        ANIMATION_SPEED_MULTIPLIER = BUILDER.comment("Speed multiplier for animated capes. 1.0 is default, 2.0 is double speed, 0.001.").defineInRange("animationSpeedMultiplier", 1.0, 0.001, 4.0);
        MAX_CONCURRENT_ANIMATIONS = BUILDER.comment("Maximum number of animated capes that can run simultaneously.").defineInRange("maxConcurrentAnimations", 4, 1, 16);
        ANIMATION_MEMORY_LIMIT_MB = BUILDER.comment("Memory limit for animation frame cache in MB.").defineInRange("animationMemoryLimitMB", 64, 16, 512);
        ENABLE_ANIMATION_LOD = BUILDER.comment("Enable Level of Detail system for animated capes based on distance.").define("enableAnimationLOD", true);
        GIF_PROCESSING_THREADS = BUILDER.comment("Number of threads to use for GIF processing.").defineInRange("gifProcessingThreads", 2, 1, 8);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static enum HDSkinQuality {
        LOW,
        MEDIUM,
        HIGH;

    }
}

