/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod;

import com.mojang.logging.LogUtils;
import com.quickskin.mod.Config;
import com.quickskin.mod.compat.SkinLayers3DCompatibility;
import com.quickskin.mod.network.PacketHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="quickskin")
public class QuickSkin {
    public static final String MODID = "quickskin";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean isGeckoLibLoaded;

    public QuickSkin(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        isGeckoLibLoaded = ModList.get().isLoaded("geckolib");
        if (isGeckoLibLoaded) {
            GeckoLib.initialize();
            LOGGER.info("GeckoLib found, enabling 3D player previews and animations.");
        } else {
            LOGGER.warn("GeckoLib not found. 3D player preview and animations will be disabled.");
        }
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::commonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SkinLayers3DCompatibility::init);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketHandler.register();
            LOGGER.info("QuickSkin packet handler registered");
        });
    }
}

