/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.network.C2STextureChunkPacket;
import com.quickskin.mod.network.C2SUpdateSkinPacket;
import com.quickskin.mod.network.C2SUploadAnimationMetadataPacket;
import com.quickskin.mod.network.PacketHandler;
import com.quickskin.mod.util.SkinResolution;
import com.quickskin.mod.util.TextureChunker;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinSwapper {
    public static void applySkin(String skinUsername, String capeId, String model) {
        if (skinUsername == null || skinUsername.isBlank()) {
            SkinSwapper.clearSkin();
            return;
        }
        if (Minecraft.m_91087_().m_91403_() != null) {
            List<C2STextureChunkPacket> chunks;
            SkinResolution resolution;
            String hash;
            byte[] data;
            if (skinUsername.startsWith("local_skin:") && (data = LocalSkinManager.INSTANCE.getTextureBytes(hash = skinUsername.substring("local_skin:".length()))) != null) {
                resolution = LocalSkinManager.INSTANCE.getResolution(hash);
                chunks = TextureChunker.chunkTextureForUpload(hash, data, resolution);
                chunks.forEach(chunk -> PacketHandler.INSTANCE.sendToServer(chunk));
            }
            if (capeId != null && capeId.startsWith("local_cape:")) {
                LocalSkinManager.AnimationMetadata metadata;
                hash = capeId.substring("local_cape:".length());
                data = LocalSkinManager.INSTANCE.getTextureBytes(hash);
                if (data != null) {
                    resolution = LocalSkinManager.INSTANCE.getResolution(hash);
                    chunks = TextureChunker.chunkTextureForUpload(hash, data, resolution);
                    chunks.forEach(chunk -> PacketHandler.INSTANCE.sendToServer(chunk));
                }
                if (LocalSkinManager.INSTANCE.isAnimated(hash) && (metadata = LocalSkinManager.INSTANCE.getAnimationMetadata(hash)) != null) {
                    PacketHandler.INSTANCE.sendToServer((Object)new C2SUploadAnimationMetadataPacket(hash, metadata));
                }
            }
            PacketHandler.INSTANCE.sendToServer((Object)new C2SUpdateSkinPacket(skinUsername, capeId != null ? capeId : "", model));
        } else {
            QuickSkin.LOGGER.warn("Cannot apply skin to server (not connected). Skin has been saved and will be applied when you join a world.");
        }
    }

    public static void clearSkin() {
        if (Minecraft.m_91087_().m_91403_() != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new C2SUpdateSkinPacket("", "", "slim"));
        } else {
            QuickSkin.LOGGER.warn("Cannot clear skin on server (not connected). Skin has been cleared locally and will be reset when you join a world.");
        }
    }
}

