/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.AnimatedTextureManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.compat.SkinLayers3DCompatibility;
import com.quickskin.mod.network.C2SRequestTexturePacket;
import com.quickskin.mod.network.PacketHandler;
import com.quickskin.mod.network.TextureChunkReceiver;
import com.quickskin.mod.util.KnownCapes;
import com.quickskin.mod.util.SkinAPI;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSkinManager {
    private static final ClientSkinManager INSTANCE = new ClientSkinManager();
    public static final ResourceLocation HIDE_CAPE_SENTINEL = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"hide_cape");
    private static final ResourceLocation VANILLA_ELYTRA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/elytra.png");
    private static BufferedImage vanillaElytraImage = null;
    private static final float MAX_CAPE_SCALE = 32.0f;
    private final Map<UUID, CustomSkinData> customSkins = new ConcurrentHashMap<UUID, CustomSkinData>();
    private final Map<UUID, String> modelOverrides = new ConcurrentHashMap<UUID, String>();

    private ClientSkinManager() {
    }

    public static ClientSkinManager getInstance() {
        return INSTANCE;
    }

    private void refreshPlayerRenderer(UUID playerUuid) {
        Player player;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91060_ != null && (player = mc.f_91073_.m_46003_(playerUuid)) != null) {
            BlockPos pos = player.m_20183_();
            mc.f_91060_.m_109721_(pos, mc.f_91073_.m_8055_(pos), mc.f_91073_.m_8055_(pos));
            SkinLayers3DCompatibility.refreshPlayerLayers(playerUuid);
        }
    }

    public void applyLook(UUID playerUuid, String skinId, @Nullable String capeId, @Nullable String model) {
        if (model != null) {
            this.setModelOverride(playerUuid, model);
        }
        if (skinId.startsWith("local_skin:")) {
            String hash = skinId.substring("local_skin:".length());
            if (!LocalSkinManager.INSTANCE.hasTexture(hash) && Minecraft.m_91087_().m_91403_() != null) {
                TextureChunkReceiver.getInstance().registerPendingRequest(hash, "skin");
                PacketHandler.INSTANCE.sendToServer((Object)new C2SRequestTexturePacket(hash));
            }
            ResourceLocation location = LocalSkinManager.INSTANCE.getTextureLocation(hash);
            this.updateCustomSkinData(playerUuid, skinId, location, capeId, this.modelOverrides.get(playerUuid));
            this.processCapeById(playerUuid, capeId);
            this.refreshPlayerRenderer(playerUuid);
        } else {
            this.updateCustomSkinData(playerUuid, skinId, null, capeId, this.modelOverrides.get(playerUuid));
            this.processCapeById(playerUuid, capeId);
            SkinAPI.fetchProfile(skinId).thenAcceptAsync(profile -> {
                if (profile != null) {
                    this.applySkin(playerUuid, (GameProfile)profile);
                }
            }, (Executor)Minecraft.m_91087_());
        }
    }

    private void processCapeById(UUID playerUuid, @Nullable String capeId) {
        CustomSkinData data = this.customSkins.get(playerUuid);
        if (data == null) {
            return;
        }
        if (capeId != null && !capeId.isBlank() && !capeId.equals("__NONE__")) {
            if (capeId.startsWith("local_cape:")) {
                String hash = capeId.substring("local_cape:".length());
                if (!LocalSkinManager.INSTANCE.hasTexture(hash) && Minecraft.m_91087_().m_91403_() != null) {
                    TextureChunkReceiver.getInstance().registerPendingRequest(hash, "cape");
                    PacketHandler.INSTANCE.sendToServer((Object)new C2SRequestTexturePacket(hash));
                }
                String animationId = "cape_" + hash;
                boolean isAnimated = false;
                if (!AnimatedTextureManager.hasAnimation(animationId)) {
                    meta = LocalSkinManager.INSTANCE.getAnimationMetadata(hash);
                    if (meta != null && meta.frameCount() > 1) {
                        isAnimated = true;
                        BufferedImage atlasImage = LocalSkinManager.INSTANCE.getSourceImage(hash);
                        if (atlasImage != null) {
                            NativeImage nativeAtlas = LocalSkinManager.convertToNativeImage(atlasImage);
                            AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, meta.frames(), meta.frameCount());
                        } else {
                            QuickSkin.LOGGER.error("Could not find source atlas image for animated cape hash: {}", (Object)hash);
                        }
                    }
                } else {
                    meta = LocalSkinManager.INSTANCE.getAnimationMetadata(hash);
                    boolean bl = isAnimated = meta != null && meta.frameCount() > 1;
                }
                if (isAnimated) {
                    this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
                } else {
                    ResourceLocation capeTexture = LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.PREVIEW);
                    this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, capeTexture, data.model());
                }
            } else if (capeId.startsWith("KNOWN_CAPE:")) {
                String id = capeId.substring("KNOWN_CAPE:".length());
                KnownCapes cape = KnownCapes.getById(id);
                if (cape != null) {
                    this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, cape.getTextureLocation(), data.model());
                }
            } else {
                SkinAPI.fetchProfile(capeId).thenAcceptAsync(profile -> {
                    if (profile != null) {
                        this.applyCape(playerUuid, (GameProfile)profile);
                    }
                }, (Executor)Minecraft.m_91087_());
            }
        } else {
            this.updateCustomSkinData(playerUuid, data.skinId(), data.skinLocation(), capeId, null, data.model());
        }
    }

    @Nullable
    public ResourceLocation getCapeLocationForId(@Nullable String capeId) {
        if (capeId == null || capeId.isEmpty()) {
            return null;
        }
        if (capeId.equals("__NONE__")) {
            return HIDE_CAPE_SENTINEL;
        }
        if (capeId.startsWith("local_cape:")) {
            boolean isAnimated;
            String hash = capeId.substring("local_cape:".length());
            LocalSkinManager.AnimationMetadata animMeta = LocalSkinManager.INSTANCE.getAnimationMetadata(hash);
            boolean bl = isAnimated = animMeta != null && animMeta.frameCount() > 1;
            if (isAnimated) {
                ResourceLocation animatedTexture;
                BufferedImage atlasImage;
                String animationId = "cape_" + hash;
                if (!AnimatedTextureManager.hasAnimation(animationId) && (atlasImage = LocalSkinManager.INSTANCE.getSourceImage(hash)) != null) {
                    NativeImage nativeAtlas = LocalSkinManager.convertToNativeImage(atlasImage);
                    AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, animMeta.frames(), animMeta.frameCount());
                }
                if ((animatedTexture = AnimatedTextureManager.getCurrentFrameTexture(animationId)) != null) {
                    return animatedTexture;
                }
                return LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.FULL);
            }
            return LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.FULL);
        }
        if (capeId.startsWith("KNOWN_CAPE:")) {
            String id = capeId.substring("KNOWN_CAPE:".length());
            KnownCapes cape = KnownCapes.getById(id);
            return cape != null ? cape.getTextureLocation() : null;
        }
        return null;
    }

    public void applyLookLocally(String skinId, String capeId, String model) {
        UUID localPlayerId = Minecraft.m_91087_().m_91094_().m_240411_();
        this.applyLook(localPlayerId, skinId, capeId, model);
        SkinLayers3DCompatibility.refreshLocalPlayerLayers();
    }

    public void applySkin(UUID playerUuid, GameProfile profile) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, texture) -> {
            if (type == MinecraftProfileTexture.Type.SKIN) {
                this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> new CustomSkinData(data.skinId(), location, data.capeId(), data.capeLocation(), data.model()));
                this.refreshPlayerRenderer(playerUuid);
            }
        }, true);
    }

    public void applyCape(UUID playerUuid, GameProfile profile) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, texture) -> {
            if (type == MinecraftProfileTexture.Type.CAPE) {
                this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> new CustomSkinData(data.skinId(), data.skinLocation(), data.capeId(), location, data.model()));
                this.refreshPlayerRenderer(playerUuid);
            }
        }, true);
    }

    private void updateCustomSkinData(UUID playerUuid, String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable String model) {
        this.updateCustomSkinData(playerUuid, skinId, skinLocation, capeId, null, model);
    }

    private void updateCustomSkinData(UUID playerUuid, String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable ResourceLocation capeLocation, @Nullable String model) {
        this.customSkins.compute(playerUuid, (uuid, data) -> {
            String finalModel;
            String finalCapeId;
            String oldCapeId;
            String string = oldCapeId = data != null ? data.capeId() : null;
            String string2 = capeId != null ? capeId : (finalCapeId = data != null ? data.capeId() : "");
            if (oldCapeId != null && !oldCapeId.equals(finalCapeId) && oldCapeId.startsWith("local_cape:")) {
                String hash = oldCapeId.substring("local_cape:".length());
                String animationId = "cape_" + hash;
                AnimatedTextureManager.removeAnimation(animationId);
            }
            String string3 = model != null ? model : (finalModel = data != null ? data.model() : "slim");
            ResourceLocation finalCapeLocation = capeLocation != null ? capeLocation : (data != null ? data.capeLocation() : null);
            return new CustomSkinData(skinId, skinLocation, finalCapeId, finalCapeLocation, finalModel);
        });
    }

    public void clearSkin(UUID playerUuid) {
        CustomSkinData data = this.customSkins.remove(playerUuid);
        if (data != null) {
            if (data.capeId() != null && data.capeId().startsWith("local_cape:")) {
                String hash = data.capeId().substring("local_cape:".length());
                String animationId = "cape_" + hash;
                AnimatedTextureManager.removeAnimation(animationId);
            }
            this.refreshPlayerRenderer(playerUuid);
        }
        this.modelOverrides.remove(playerUuid);
    }

    @Nullable
    public ResourceLocation getSkinLocation(UUID playerUuid) {
        CustomSkinData data = this.customSkins.get(playerUuid);
        if (data == null) {
            return null;
        }
        if (data.skinId != null && data.skinId.startsWith("local_skin:")) {
            String hash = data.skinId.substring("local_skin:".length());
            return LocalSkinManager.INSTANCE.getTextureLocation(hash);
        }
        return data.skinLocation();
    }

    @Nullable
    public ResourceLocation getCapeLocation(UUID playerUuid) {
        String hash;
        CustomSkinData data = this.customSkins.get(playerUuid);
        if (data == null || data.capeId() == null) {
            return null;
        }
        ResourceLocation dynamicLocation = this.getCapeLocationForId(data.capeId());
        if (dynamicLocation != null) {
            return dynamicLocation;
        }
        if (data.capeId().startsWith("local_cape:") && LocalSkinManager.INSTANCE.isAnimated(hash = data.capeId().substring("local_cape:".length()))) {
            BufferedImage atlasImage;
            String animationId = "cape_" + hash;
            LocalSkinManager.AnimationMetadata meta = LocalSkinManager.INSTANCE.getAnimationMetadata(hash);
            if (meta != null && meta.frameCount() > 1 && (atlasImage = LocalSkinManager.INSTANCE.getSourceImage(hash)) != null) {
                NativeImage nativeAtlas = LocalSkinManager.convertToNativeImage(atlasImage);
                AnimatedTextureManager.registerAnimation(animationId, nativeAtlas, meta.frames(), meta.frameCount());
                dynamicLocation = AnimatedTextureManager.getCurrentFrameTexture(animationId);
                if (dynamicLocation != null) {
                    return dynamicLocation;
                }
            }
            return LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.FULL);
        }
        return data.capeLocation();
    }

    @Nullable
    public String getModelName(UUID playerUuid) {
        if (this.modelOverrides.containsKey(playerUuid)) {
            return this.modelOverrides.get(playerUuid);
        }
        CustomSkinData data = this.customSkins.get(playerUuid);
        return data != null ? data.model() : null;
    }

    public void setModelOverride(UUID playerUuid, String model) {
        String finalModel = model == null || model.isBlank() ? "slim" : model;
        this.modelOverrides.put(playerUuid, finalModel);
        this.customSkins.computeIfPresent(playerUuid, (uuid, data) -> new CustomSkinData(data.skinId(), data.skinLocation(), data.capeId(), data.capeLocation(), finalModel));
        this.refreshPlayerRenderer(playerUuid);
    }

    public void clearAll() {
        for (CustomSkinData data : this.customSkins.values()) {
            if (data.capeId() == null || !data.capeId().startsWith("local_cape:")) continue;
            String hash = data.capeId().substring("local_cape:".length());
            AnimatedTextureManager.removeAnimation("cape_" + hash);
        }
        this.customSkins.clear();
        this.modelOverrides.clear();
    }

    public void refreshUsersOfTexture(String textureHash) {
        String localSkinId = "local_skin:" + textureHash;
        String localCapeId = "local_cape:" + textureHash;
        for (Map.Entry<UUID, CustomSkinData> entry : this.customSkins.entrySet()) {
            boolean capeMatch;
            UUID playerUuid = entry.getKey();
            CustomSkinData data = entry.getValue();
            boolean bl = capeMatch = data.capeId() != null && data.capeId().equals(localCapeId);
            if ((data.skinId() == null || !data.skinId().equals(localSkinId)) && !capeMatch) continue;
            if (capeMatch) {
                String animationId = "cape_" + textureHash;
                AnimatedTextureManager.refreshAnimation(animationId);
            }
            this.refreshPlayerRenderer(playerUuid);
        }
    }

    public boolean hasActiveSkin(UUID playerUuid) {
        CustomSkinData data = this.customSkins.get(playerUuid);
        return data != null && data.skinId() != null && !data.skinId().isEmpty();
    }

    public boolean hasActiveCape(UUID playerUuid) {
        boolean hasActiveCape;
        CustomSkinData data = this.customSkins.get(playerUuid);
        boolean bl = hasActiveCape = data != null && data.capeId() != null && !data.capeId().isEmpty();
        if (hasActiveCape) {
            // empty if block
        }
        return hasActiveCape;
    }

    public void debugPlayerCapeAnimation(UUID playerUuid) {
    }

    private BufferedImage getVanillaElytraImage() {
        if (vanillaElytraImage == null) {
            try {
                InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(VANILLA_ELYTRA_TEXTURE).get()).m_215507_();
                vanillaElytraImage = ImageIO.read(stream);
                stream.close();
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Failed to load vanilla elytra texture", (Throwable)e);
            }
        }
        return vanillaElytraImage;
    }

    private record CustomSkinData(String skinId, @Nullable ResourceLocation skinLocation, @Nullable String capeId, @Nullable ResourceLocation capeLocation, String model) {
    }
}

