/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class StreamingFrameLoader {
    private static final int MAX_MEMORY_MB = 64;
    private static final Map<String, FrameCache> frameCache = new ConcurrentHashMap<String, FrameCache>();

    public static FrameCache getOrCreateCache(String textureId, Path gifPath) {
        return frameCache.computeIfAbsent(textureId, k -> new FrameCache(gifPath));
    }

    public static void removeCache(String textureId) {
        FrameCache cache = frameCache.remove(textureId);
        if (cache != null) {
            cache.cleanup();
        }
    }

    public static void cleanupAll() {
        frameCache.values().forEach(FrameCache::cleanup);
        frameCache.clear();
    }

    public static long getTotalMemoryUsage() {
        return frameCache.values().stream().mapToLong(cache -> cache.memoryUsage.get()).sum();
    }

    public static class FrameCache {
        private final Queue<CachedFrame> frames = new LinkedList<CachedFrame>();
        private final Path gifPath;
        private final AtomicLong memoryUsage = new AtomicLong(0L);

        public FrameCache(Path gifPath) {
            this.gifPath = gifPath;
        }

        public NativeImage getFrame(int frameIndex) {
            CachedFrame cached = this.findCachedFrame(frameIndex);
            if (cached != null) {
                cached.lastAccess = System.currentTimeMillis();
                return cached.image;
            }
            return this.loadFrameAsync(frameIndex);
        }

        private CachedFrame findCachedFrame(int frameIndex) {
            return this.frames.stream().filter(frame -> frame.frameIndex == frameIndex).findFirst().orElse(null);
        }

        private NativeImage loadFrameAsync(int frameIndex) {
            this.evictOldFramesIfNeeded();
            try {
                ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
                reader.setInput(ImageIO.createImageInputStream(Files.newInputStream(this.gifPath, new OpenOption[0])));
                BufferedImage frame = reader.read(frameIndex);
                NativeImage nativeImage = FrameCache.convertToNativeImage(frame);
                CachedFrame cachedFrame = new CachedFrame(frameIndex, nativeImage);
                this.frames.offer(cachedFrame);
                this.memoryUsage.addAndGet(FrameCache.calculateImageSize(nativeImage));
                reader.dispose();
                return nativeImage;
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Failed to load frame {}", (Object)frameIndex, (Object)e);
                return null;
            }
        }

        private void evictOldFramesIfNeeded() {
            long currentMemory = this.memoryUsage.get();
            long maxMemory = 0x4000000L;
            while (currentMemory > maxMemory && !this.frames.isEmpty()) {
                CachedFrame oldest = this.frames.poll();
                if (oldest == null) continue;
                oldest.image.close();
                this.memoryUsage.addAndGet(-FrameCache.calculateImageSize(oldest.image));
                currentMemory = this.memoryUsage.get();
            }
        }

        private static long calculateImageSize(NativeImage image) {
            return (long)image.m_84982_() * (long)image.m_85084_() * 4L;
        }

        private static NativeImage convertToNativeImage(BufferedImage bufferedImage) {
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            NativeImage nativeImage = new NativeImage(width, height, false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = bufferedImage.getRGB(x, y);
                    nativeImage.m_84988_(x, y, rgb);
                }
            }
            return nativeImage;
        }

        public void cleanup() {
            for (CachedFrame frame : this.frames) {
                frame.image.close();
            }
            this.frames.clear();
            this.memoryUsage.set(0L);
        }
    }

    public static class CachedFrame {
        final int frameIndex;
        final NativeImage image;
        long lastAccess;

        public CachedFrame(int frameIndex, NativeImage image) {
            this.frameIndex = frameIndex;
            this.image = image;
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

