/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.client.geckolib;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.AnimationManager;
import com.quickskin.mod.client.geckolib.GeoPlayerEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class GeoPlayerModel
extends GeoModel<GeoPlayerEntity> {
    private static final ResourceLocation FALLBACK_ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"animations/idle.animation.json");

    public ResourceLocation getModelResource(GeoPlayerEntity animatable) {
        if (animatable != null && "slim".equalsIgnoreCase(animatable.getModelName())) {
            return ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/player_slim.geo.json");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"geo/player.geo.json");
    }

    public ResourceLocation getTextureResource(GeoPlayerEntity animatable) {
        if (animatable == null) {
            QuickSkin.LOGGER.error("GeoPlayerEntity is null in getTextureResource!");
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/steve.png");
        }
        return animatable.getSkinLocation();
    }

    public ResourceLocation getAnimationResource(GeoPlayerEntity animatable) {
        String animationName;
        if (animatable != null && (animationName = animatable.getCurrentAnimation()) != null && !animationName.isEmpty()) {
            ResourceLocation animationFile = AnimationManager.getInstance().getAnimationFile(animationName);
            if (animationFile != null) {
                return animationFile;
            }
            QuickSkin.LOGGER.warn("Could not find animation file for animation: {}. Falling back to default.", (Object)animationName);
        }
        return FALLBACK_ANIMATION;
    }

    public void setCustomAnimations(GeoPlayerEntity animatable, long instanceId, AnimationState<GeoPlayerEntity> animationState) {
        if (animatable == null || animationState == null) {
            QuickSkin.LOGGER.error("Null parameters in setCustomAnimations - animatable: {}, animationState: {}", (Object)(animatable != null ? 1 : 0), (Object)(animationState != null ? 1 : 0));
            return;
        }
        try {
            this.ensureRequiredData(animationState, animatable);
            super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error in setCustomAnimations", (Throwable)e);
        }
    }

    public void applyMolangQueries(GeoPlayerEntity animatable, double currentTick) {
        if (animatable == null) {
            QuickSkin.LOGGER.error("Animatable is null in applyMolangQueries!");
            return;
        }
    }

    public void handleAnimations(GeoPlayerEntity animatable, long instanceId, AnimationState<GeoPlayerEntity> animationState) {
        if (animatable == null || animationState == null) {
            QuickSkin.LOGGER.error("Null parameters in handleAnimations - animatable: {}, animationState: {}", (Object)(animatable != null ? 1 : 0), (Object)(animationState != null ? 1 : 0));
            return;
        }
        try {
            this.ensureRequiredData(animationState, animatable);
            super.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error in handleAnimations", (Throwable)e);
        }
    }

    private void ensureRequiredData(AnimationState<GeoPlayerEntity> animationState, GeoPlayerEntity animatable) {
        if (animationState.getData(DataTickets.ENTITY_MODEL_DATA) == null) {
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(false, false, 0.0f, 0.0f));
        }
        if (animationState.getData(DataTickets.TICK) == null) {
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick(null));
        }
        if (animationState.getData(DataTickets.ENTITY) == null) {
            animationState.setData(DataTickets.ENTITY, null);
        }
    }
}

