/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.quickskin.mod.Config;
import com.quickskin.mod.SkinSwapper;
import com.quickskin.mod.client.AnimatedTextureManager;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.event.ServerAnimationCache;
import com.quickskin.mod.util.SkinAPI;
import com.quickskin.mod.util.SkinData;
import com.quickskin.mod.util.SkinLoadingMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCommand {
    private static final SuggestionProvider<CommandSourceStack> MODEL_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"default", "slim"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAMES_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)ctx.getSource()).m_5982_(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> ANIMATION_IDS_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82981_(Arrays.stream(AnimatedTextureManager.getAllAnimationIds()), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES_SUGGESTIONS).executes(ctx -> SkinCommand.setSkin((CommandContext<CommandSourceStack>)ctx, Optional.empty(), Optional.empty()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)StringArgumentType.string()).suggests(MODEL_SUGGESTIONS).executes(ctx -> SkinCommand.setSkin((CommandContext<CommandSourceStack>)ctx, Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"model")), Optional.empty()))).then(Commands.m_82129_((String)"capeUsername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES_SUGGESTIONS).executes(ctx -> SkinCommand.setSkin((CommandContext<CommandSourceStack>)ctx, Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"model")), Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"capeUsername"))))))))).then(Commands.m_82127_((String)"clear").executes(SkinCommand::clearSkin))).then(Commands.m_82127_((String)"reload").executes(SkinCommand::reloadSkin))).then(Commands.m_82127_((String)"save").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES_SUGGESTIONS).executes(ctx -> SkinCommand.saveSkin((CommandContext<CommandSourceStack>)ctx, Optional.empty(), Optional.empty()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)StringArgumentType.string()).suggests(MODEL_SUGGESTIONS).executes(ctx -> SkinCommand.saveSkin((CommandContext<CommandSourceStack>)ctx, Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"model")), Optional.empty()))).then(Commands.m_82129_((String)"capeUsername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES_SUGGESTIONS).executes(ctx -> SkinCommand.saveSkin((CommandContext<CommandSourceStack>)ctx, Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"model")), Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"capeUsername"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"stats").executes(SkinCommand::showStats))).then(Commands.m_82127_((String)"reset").executes(SkinCommand::resetStats))).then(Commands.m_82127_((String)"cache").then(Commands.m_82127_((String)"clear").executes(SkinCommand::clearCache)))).then(Commands.m_82127_((String)"clientanimations").executes(SkinCommand::debugClientAnimations))).then(Commands.m_82127_((String)"memory").executes(SkinCommand::debugMemory))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").executes(SkinCommand::debugCurrentPlayerCape)).then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES_SUGGESTIONS).executes(SkinCommand::debugPlayerCape)))).then(Commands.m_82127_((String)"refresh").then(Commands.m_82129_((String)"animationId", (ArgumentType)StringArgumentType.string()).suggests(ANIMATION_IDS_SUGGESTIONS).executes(SkinCommand::refreshAnimation)))).then(Commands.m_82127_((String)"localcache").executes(SkinCommand::debugLocalCache))).then(Commands.m_82127_((String)"servercache").executes(SkinCommand::debugServerAnimationCache))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadskin").executes(SkinCommand::reloadSkin));
    }

    private static int setSkin(CommandContext<CommandSourceStack> context, Optional<String> modelOpt, Optional<String> capeUsernameOpt) {
        String username = StringArgumentType.getString(context, (String)"username");
        String model = modelOpt.orElse("slim");
        String capeUsername = capeUsernameOpt.orElse("");
        SkinData skinData = new SkinData(username, model, capeUsername, null);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Applying skin: " + skinData.toEncodedString())), true);
        SkinSwapper.applySkin(skinData.getUsername(), skinData.getCapeUsername(), skinData.getModel());
        ClientSkinManager.getInstance().applyLookLocally(skinData.getUsername(), skinData.getCapeUsername(), skinData.getModel());
        Config.ACTIVE_SKIN.set((Object)skinData.toEncodedString());
        Config.ACTIVE_SKIN.save();
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        if (saved.stream().noneMatch(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(username))) {
            saved.add(skinData.toEncodedString());
            Config.SAVED_SKINS.set(saved);
            Config.SAVED_SKINS.save();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added '" + username + "' to saved skins.")), false);
        } else {
            List updatedList = saved.stream().map(s -> {
                SkinData sd = SkinData.fromString(s);
                if (sd.getUsername().equalsIgnoreCase(username)) {
                    return skinData.toEncodedString();
                }
                return s;
            }).collect(Collectors.toList());
            Config.SAVED_SKINS.set(updatedList);
            Config.SAVED_SKINS.save();
        }
        return 1;
    }

    private static int clearSkin(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Resetting to default skin."), true);
        SkinSwapper.clearSkin();
        ClientSkinManager.getInstance().clearSkin(Minecraft.m_91087_().m_91094_().m_240411_());
        Config.ACTIVE_SKIN.set((Object)"");
        Config.ACTIVE_SKIN.save();
        return 1;
    }

    private static int reloadSkin(CommandContext<CommandSourceStack> context) {
        SkinData activeSkin = SkinData.fromString((String)Config.ACTIVE_SKIN.get());
        String username = activeSkin.getUsername();
        if (!username.isBlank()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Reloading skin: " + activeSkin.toEncodedString())), true);
            SkinAPI.clearCache(username);
            SkinSwapper.applySkin(activeSkin.getUsername(), activeSkin.getCapeUsername(), activeSkin.getModel());
            ClientSkinManager.getInstance().applyLookLocally(activeSkin.getUsername(), activeSkin.getCapeUsername(), activeSkin.getModel());
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Resetting to default skin."), true);
            SkinSwapper.clearSkin();
            ClientSkinManager.getInstance().clearSkin(Minecraft.m_91087_().m_91094_().m_240411_());
        }
        return 1;
    }

    private static int saveSkin(CommandContext<CommandSourceStack> context, Optional<String> modelOpt, Optional<String> capeUsernameOpt) {
        String username = StringArgumentType.getString(context, (String)"username");
        String model = modelOpt.orElse("slim");
        String capeUsername = capeUsernameOpt.orElse("");
        SkinData skinData = new SkinData(username, model, capeUsername, null);
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        if (saved.stream().anyMatch(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(username))) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("'" + username + "' is already in the saved list. Use /skin set to update it.")));
            return 0;
        }
        saved.add(skinData.toEncodedString());
        Config.SAVED_SKINS.set(saved);
        Config.SAVED_SKINS.save();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Saved '" + skinData.toEncodedString() + "' to skin list.")), true);
        return 1;
    }

    private static int showStats(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Displaying skin loading statistics in log..."), true);
        SkinLoadingMonitor.printStatistics();
        return 1;
    }

    private static int resetStats(CommandContext<CommandSourceStack> context) {
        SkinLoadingMonitor.resetStatistics();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Reset skin loading statistics."), true);
        return 1;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) {
        SkinAPI.clearAllCache();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Cleared all cached skin profiles."), true);
        return 1;
    }

    private static int debugClientAnimations(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"--- Client Animation Debug ---"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Active animations: " + AnimatedTextureManager.getActiveCount())), false);
        long memoryUsageMB = AnimatedTextureManager.getEstimatedMemoryUsage() / 1024L / 1024L;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Memory usage: ~" + memoryUsageMB + " MB")), false);
        String[] animationIds = AnimatedTextureManager.getAllAnimationIds();
        if (animationIds.length > 0) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Live Animation States:"), false);
            for (String id : animationIds) {
                AnimatedTextureManager.AnimationState state = AnimatedTextureManager.getAnimation(id);
                if (state == null) continue;
                String info = String.format("  ID: %s | Frame: %d/%d | Valid: %s", id, state.getCurrentFrame(), state.getFrameCount(), state.isValid());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)info), false);
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No animations are currently active."), false);
        }
        return 1;
    }

    private static int debugMemory(CommandContext<CommandSourceStack> context) {
        long animationMemoryMB = AnimatedTextureManager.getEstimatedMemoryUsage() / 1024L / 1024L;
        long memoryLimit = ((Integer)Config.ANIMATION_MEMORY_LIMIT_MB.get()).intValue();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"--- Memory Debug ---"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Animation Memory: %d MB / %d MB", animationMemoryMB, memoryLimit)), false);
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long usedMemory = totalMemory - freeMemory;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("JVM Memory: %d MB Used / %d MB Total", usedMemory, totalMemory)), false);
        return 1;
    }

    private static int debugCurrentPlayerCape(CommandContext<CommandSourceStack> context) {
        UUID playerUuid = Minecraft.m_91087_().m_91094_().m_240411_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Debugging current player cape. Check console for details."), true);
        ClientSkinManager.getInstance().debugPlayerCapeAnimation(playerUuid);
        return 1;
    }

    private static int debugPlayerCape(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        if (Minecraft.m_91087_().f_91073_ != null) {
            for (AbstractClientPlayer player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (!player.m_7755_().getString().equalsIgnoreCase(playerName)) continue;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Debugging cape for " + playerName + ". Check console.")), true);
                ClientSkinManager.getInstance().debugPlayerCapeAnimation(player.m_20148_());
                return 1;
            }
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Player '" + playerName + "' not found.")));
        return 0;
    }

    private static int refreshAnimation(CommandContext<CommandSourceStack> context) {
        String animationId = StringArgumentType.getString(context, (String)"animationId");
        boolean success = AnimatedTextureManager.refreshAnimation(animationId);
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully refreshed animation: " + animationId)), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to refresh animation: " + animationId)));
        }
        return success ? 1 : 0;
    }

    private static int debugLocalCache(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"--- Client Local Data Cache ---"), false);
        List<LocalSkinManager.LocalAsset> assets = LocalSkinManager.INSTANCE.discoverLocalAssets();
        if (assets.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No local assets found in uploads directory."), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Checking status of local assets..."), false);
        for (LocalSkinManager.LocalAsset asset : assets) {
            String hash = asset.hash();
            boolean textureCached = LocalSkinManager.INSTANCE.hasTexture(hash);
            boolean metadataCached = LocalSkinManager.INSTANCE.getAnimationMetadata(hash) != null;
            MutableComponent textureStatus = Component.m_237113_((String)(textureCached ? "OK" : "MISSING")).m_130948_(Style.f_131099_.m_131140_(textureCached ? ChatFormatting.GREEN : ChatFormatting.RED));
            MutableComponent metadataStatus = Component.m_237113_((String)(metadataCached ? "OK" : "N/A")).m_130948_(Style.f_131099_.m_131140_(metadataCached ? ChatFormatting.GREEN : ChatFormatting.GRAY));
            String message = String.format("  %s (%s...): Texture: ", asset.friendlyName(), hash.substring(0, 8));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SkinCommand.lambda$debugLocalCache$36(message, (Component)textureStatus, (Component)metadataStatus), false);
        }
        return 1;
    }

    private static int debugServerAnimationCache(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).m_81377_() == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"This command must be run on the server or by an operator."));
            return 0;
        }
        ServerAnimationCache cache = ServerAnimationCache.getInstance();
        Map<String, LocalSkinManager.AnimationMetadata> cacheView = cache.getMetadataCacheView();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"--- Server Animation Metadata Cache ---"), false);
        if (cacheView.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Cache is currently empty."), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Found " + cacheView.size() + " cached metadata entries:")), false);
            cacheView.forEach((hash, metadata) -> {
                String info = String.format("  Hash: %s... | Frames: %d", hash.substring(0, 8), metadata.frameCount());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)info), false);
            });
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$debugLocalCache$36(String message, Component textureStatus, Component metadataStatus) {
        return Component.m_237113_((String)message).m_7220_(textureStatus).m_7220_((Component)Component.m_237113_((String)" | Metadata: ")).m_7220_(metadataStatus);
    }
}

