/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.compat;

import com.quickskin.mod.QuickSkin;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class SkinLayers3DCompatibility {
    private static final String SKINLAYERS_MODID = "skinlayers3d";
    private static boolean isLoaded = false;
    private static boolean initialized = false;
    private static Class<?> skinLayersModBaseClass;
    private static Class<?> playerSettingsClass;
    private static Method refreshLayersMethod;
    private static Method clearMeshesMethod;
    private static Method setCurrentSkinMethod;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        isLoaded = ModList.get().isLoaded(SKINLAYERS_MODID);
        if (isLoaded) {
            QuickSkin.LOGGER.info("3d-Skin-Layers detected, initializing compatibility layer...");
            try {
                skinLayersModBaseClass = Class.forName("dev.tr7zw.skinlayers.SkinLayersModBase");
                playerSettingsClass = Class.forName("dev.tr7zw.skinlayers.accessor.PlayerSettings");
                refreshLayersMethod = skinLayersModBaseClass.getDeclaredMethod("refreshLayers", Player.class);
                refreshLayersMethod.setAccessible(true);
                clearMeshesMethod = playerSettingsClass.getDeclaredMethod("clearMeshes", new Class[0]);
                setCurrentSkinMethod = playerSettingsClass.getDeclaredMethod("setCurrentSkin", ResourceLocation.class);
                QuickSkin.LOGGER.info("3d-Skin-Layers compatibility layer initialized successfully!");
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to initialize 3d-Skin-Layers compatibility: {}", (Object)e.getMessage());
                isLoaded = false;
            }
        } else {
            QuickSkin.LOGGER.debug("3d-Skin-Layers not detected, skipping compatibility layer.");
        }
    }

    public static boolean isAvailable() {
        return isLoaded && initialized;
    }

    public static void refreshPlayerLayers(UUID playerUuid) {
        if (!SkinLayers3DCompatibility.isAvailable()) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Player player = mc.f_91073_.m_46003_(playerUuid);
            if (player == null) {
                return;
            }
            refreshLayersMethod.invoke(null, player);
            QuickSkin.LOGGER.debug("Refreshed 3d-Skin-Layers for player: {}", (Object)playerUuid);
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to refresh 3d-Skin-Layers for player {}: {}", (Object)playerUuid, (Object)e.getMessage());
        }
    }

    public static void refreshLocalPlayerLayers() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91094_() != null) {
            SkinLayers3DCompatibility.refreshPlayerLayers(mc.m_91094_().m_240411_());
        }
    }

    public static void clearPlayerMeshes(UUID playerUuid) {
        if (!SkinLayers3DCompatibility.isAvailable()) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Player player = mc.f_91073_.m_46003_(playerUuid);
            if (player == null) {
                return;
            }
            if (playerSettingsClass.isInstance(player)) {
                Object playerSettings = playerSettingsClass.cast(player);
                clearMeshesMethod.invoke(playerSettings, new Object[0]);
                setCurrentSkinMethod.invoke(playerSettings, new Object[]{null});
                QuickSkin.LOGGER.debug("Cleared 3d-Skin-Layers meshes for player: {}", (Object)playerUuid);
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Failed to clear 3d-Skin-Layers meshes for player {}: {}", (Object)playerUuid, (Object)e.getMessage());
        }
    }
}

