/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.mojang.brigadier.CommandDispatcher;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.SkinSwapper;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.GeckoClientEvents;
import com.quickskin.mod.command.SkinCommand;
import com.quickskin.mod.gui.PlayerSkinMenuScreen;
import com.quickskin.mod.util.SkinData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    private static boolean initialSkinAppliedThisSession = false;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof PauseScreen) {
            if (QuickSkin.isGeckoLibLoaded) {
                GeckoClientEvents.onScreenInit(event);
            } else {
                ClientEvents.addGeckoLibMissingWidgets(event);
            }
        }
    }

    private static void addGeckoLibMissingWidgets(@NotNull ScreenEvent.Init.Post event) {
        int groupY;
        int groupX;
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent message = Component.m_237113_((String)"Requires GeckoLib for 3D Preview").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
        int changeSkinBtnWidth = 98;
        int getGeckoBtnWidth = 98;
        int btnHeight = 20;
        int spacing = 4;
        int totalWidgetWidth = changeSkinBtnWidth + spacing + getGeckoBtnWidth;
        int messageWidth = font.m_92852_((FormattedText)message);
        int rightmostX = 0;
        int targetY = -1;
        Object object = event.getScreen();
        if (object instanceof TitleScreen) {
            TitleScreen screen = (TitleScreen)object;
            targetY = screen.f_96544_ / 4 + 48 + 72;
            rightmostX = screen.f_96543_ / 2 + 124;
            for (GuiEventListener listener : event.getListenersList()) {
                AbstractWidget widget;
                if (!(listener instanceof AbstractWidget) || (widget = (AbstractWidget)listener).m_252907_() != targetY) continue;
                rightmostX = Math.max(rightmostX, widget.m_252754_() + widget.m_5711_());
            }
            groupX = rightmostX + spacing;
            groupY = targetY;
        } else {
            object = event.getScreen();
            if (object instanceof PauseScreen) {
                PauseScreen screen = (PauseScreen)object;
                Button saveAndQuitButton = null;
                int maxWidth = 0;
                for (Object listener : event.getListenersList()) {
                    Button button2;
                    if (!(listener instanceof Button) || (button2 = (Button)listener).m_5711_() <= maxWidth) continue;
                    maxWidth = button2.m_5711_();
                }
                if (maxWidth > 0) {
                    int maxY = -1;
                    for (GuiEventListener listener : event.getListenersList()) {
                        Button button3;
                        if (!(listener instanceof Button) || (button3 = (Button)listener).m_5711_() != maxWidth || button3.m_252907_() <= maxY) continue;
                        maxY = button3.m_252907_();
                        saveAndQuitButton = button3;
                    }
                }
                if (saveAndQuitButton != null) {
                    targetY = saveAndQuitButton.m_252907_();
                    rightmostX = saveAndQuitButton.m_252754_() + saveAndQuitButton.m_5711_();
                    for (Object listener : event.getListenersList()) {
                        AbstractWidget widget;
                        if (!(listener instanceof AbstractWidget) || (widget = (AbstractWidget)listener).m_252907_() != targetY) continue;
                        rightmostX = Math.max(rightmostX, widget.m_252754_() + widget.m_5711_());
                    }
                    groupX = rightmostX + spacing;
                    groupY = targetY;
                } else {
                    groupX = screen.f_96543_ - totalWidgetWidth - 4;
                    groupY = 4;
                }
            } else {
                return;
            }
        }
        Objects.requireNonNull(font);
        int textY = groupY - 9 - 2;
        int textX = groupX + (totalWidgetWidth - messageWidth) / 2;
        if (textY > 2) {
            Objects.requireNonNull(font);
            event.addListener((GuiEventListener)new StringWidget(textX, textY, messageWidth, 9, (Component)message, font));
        }
        event.addListener((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Change Skin"), button -> Minecraft.m_91087_().m_91152_((Screen)new PlayerSkinMenuScreen(event.getScreen(), null))).m_252987_(groupX, groupY, changeSkinBtnWidth, btnHeight).m_253136_());
        event.addListener((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Get GeckoLib"), button -> Util.m_137581_().m_137646_("https://www.curseforge.com/minecraft/mc-mods/geckolib")).m_252987_(groupX + changeSkinBtnWidth + spacing, groupY, getGeckoBtnWidth, btnHeight).m_253136_());
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        QuickSkin.LOGGER.info("Player disconnected, resetting session flags and clearing skin cache.");
        initialSkinAppliedThisSession = false;
        ClientSkinManager.getInstance().clearAll();
        if (QuickSkin.isGeckoLibLoaded) {
            GeckoClientEvents.onClientDisconnect();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (initialSkinAppliedThisSession || !event.getLevel().m_5776_() || !((entity = event.getEntity()) instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)entity;
        SkinData activeSkin = SkinData.fromString((String)Config.ACTIVE_SKIN.get());
        String username = activeSkin.getUsername();
        if (username.isBlank()) {
            QuickSkin.LOGGER.info("No custom skin configured, using default.");
            initialSkinAppliedThisSession = true;
            return;
        }
        QuickSkin.LOGGER.info("Player joined world. Applying initial skin: {}", (Object)activeSkin.toEncodedString());
        SkinSwapper.applySkin(activeSkin.getUsername(), activeSkin.getCapeUsername(), activeSkin.getModel());
        ClientSkinManager.getInstance().applyLookLocally(activeSkin.getUsername(), activeSkin.getCapeUsername(), activeSkin.getModel());
        initialSkinAppliedThisSession = true;
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        SkinCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

