/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.LocalSkinManager;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerAnimationCache {
    private static final ServerAnimationCache INSTANCE = new ServerAnimationCache();
    private final Map<String, LocalSkinManager.AnimationMetadata> metadataCache = new ConcurrentHashMap<String, LocalSkinManager.AnimationMetadata>();

    public static ServerAnimationCache getInstance() {
        return INSTANCE;
    }

    public void storeMetadata(String hash, LocalSkinManager.AnimationMetadata metadata) {
        if (!this.metadataCache.containsKey(hash)) {
            this.metadataCache.put(hash, metadata);
            QuickSkin.LOGGER.info("[SERVER] Stored new animation metadata for hash: {}", (Object)hash);
        }
    }

    public boolean hasMetadata(String hash) {
        return this.metadataCache.containsKey(hash);
    }

    public LocalSkinManager.AnimationMetadata getMetadata(String hash) {
        return this.metadataCache.get(hash);
    }

    public Map<String, LocalSkinManager.AnimationMetadata> getMetadataCacheView() {
        return Collections.unmodifiableMap(this.metadataCache);
    }

    public static void clear() {
        ServerAnimationCache.INSTANCE.metadataCache.clear();
        QuickSkin.LOGGER.info("[SERVER] Cleared animation metadata cache.");
    }
}

