/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.event;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.event.ServerAnimationCache;
import com.quickskin.mod.network.PacketHandler;
import com.quickskin.mod.network.S2CSendAnimationMetadataPacket;
import com.quickskin.mod.network.S2CUpdateSkinPacket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="quickskin", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    private static final Map<UUID, CustomLook> activeCustomLooks = new ConcurrentHashMap<UUID, CustomLook>();

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        activeCustomLooks.forEach((uuid, look) -> {
            S2CSendAnimationMetadataPacket metaPacket;
            LocalSkinManager.AnimationMetadata metadata;
            String hash;
            S2CUpdateSkinPacket packet = new S2CUpdateSkinPacket((UUID)uuid, look.skinIdentifier(), look.capeIdentifier(), look.model());
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
            if (look.capeIdentifier() != null && look.capeIdentifier().startsWith("local_cape:")) {
                hash = look.capeIdentifier().substring("local_cape:".length());
                metadata = ServerAnimationCache.getInstance().getMetadata(hash);
                if (metadata != null) {
                    QuickSkin.LOGGER.info("[SERVER] Sending metadata for hash {} to new player {}", (Object)hash, (Object)player2.m_7755_().getString());
                    metaPacket = new S2CSendAnimationMetadataPacket(hash, metadata);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)metaPacket);
                }
            }
            if (look.skinIdentifier() != null && look.skinIdentifier().startsWith("local_skin:")) {
                hash = look.skinIdentifier().substring("local_skin:".length());
                metadata = ServerAnimationCache.getInstance().getMetadata(hash);
                if (metadata != null) {
                    metaPacket = new S2CSendAnimationMetadataPacket(hash, metadata);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)metaPacket);
                }
            }
        });
    }

    public static void setCustomLook(ServerPlayer player, String skinIdentifier, @Nullable String capeIdentifier, String model) {
        if (skinIdentifier != null && !skinIdentifier.isBlank()) {
            CustomLook look = new CustomLook(skinIdentifier, capeIdentifier, model);
            activeCustomLooks.put(player.m_20148_(), look);
            QuickSkin.LOGGER.info("[SERVER] Applying custom look for {} and broadcasting.", (Object)player.m_7755_().getString());
            S2CUpdateSkinPacket packet = new S2CUpdateSkinPacket(player.m_20148_(), skinIdentifier, capeIdentifier, model);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
        } else if (activeCustomLooks.remove(player.m_20148_()) != null) {
            QuickSkin.LOGGER.info("[SERVER] Clearing custom look for {} and broadcasting.", (Object)player.m_7755_().getString());
            S2CUpdateSkinPacket clearPacket = new S2CUpdateSkinPacket(player.m_20148_(), null, null, null);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)clearPacket);
        }
    }

    private record CustomLook(String skinIdentifier, @Nullable String capeIdentifier, String model) {
    }
}

